/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import pyrosim.legacy_2006_2.legacy.v17.Quad;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Prism
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Point3D[] d_points;
    private Color[] d_colors;

    private Prism() {
        this.d_points = new Point3D[8];
    }

    public Prism(double d, double d2, double d3, double d4, double d5, double d6) {
        this.d_points = new Point3D[8];
        this.d_points[0] = new Point3D(d, d3, d5);
        this.d_points[1] = new Point3D(d2, d3, d5);
        this.d_points[2] = new Point3D(d2, d4, d5);
        this.d_points[3] = new Point3D(d, d4, d5);
        this.d_points[4] = new Point3D(d, d3, d6);
        this.d_points[5] = new Point3D(d2, d3, d6);
        this.d_points[6] = new Point3D(d2, d4, d6);
        this.d_points[7] = new Point3D(d, d4, d6);
    }

    public Prism(Point3D point3D, Point3D point3D2) {
        this(point3D.x, point3D2.x, point3D.y, point3D2.y, point3D.z, point3D2.z);
    }

    public Prism(Point3D[] point3DArray) {
        if (point3DArray.length != 8) {
            throw new IllegalArgumentException("Array must have 8 points.");
        }
        this.d_points = point3DArray;
    }

    public Object clone() {
        Prism prism = new Prism();
        for (int i = 0; i < 8; ++i) {
            prism.d_points[i] = new Point3D(this.d_points[i].x, this.d_points[i].y, this.d_points[i].z);
        }
        if (this.d_colors != null) {
            prism.d_colors = new Color[this.d_colors.length];
            System.arraycopy(this.d_colors, 0, prism.d_colors, 0, this.d_colors.length);
        }
        return prism;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Prism)) {
            return false;
        }
        return Arrays.equals(this.d_points, ((Prism)object).d_points) && Arrays.equals(this.d_colors, ((Prism)object).d_colors);
    }

    public void translate(double d, double d2, double d3) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += d;
            this.d_points[i].y += d2;
            this.d_points[i].z += d3;
        }
    }

    public void mirror(int n, UnitDouble unitDouble) {
    }

    public Point3D getPoint(int n) {
        return this.d_points[n];
    }

    public Color getColor(int n) {
        return this.d_colors[n];
    }

    public void setColor(Color color) {
        this.setColors(new Color[]{color, color, color, color, color, color});
    }

    public void setColors(Color[] colorArray) {
        if (colorArray.length != 6) {
            throw new IllegalArgumentException();
        }
        this.d_colors = colorArray;
    }

    public Quad getFace(int n) {
        Quad quad = null;
        switch (n) {
            case 0: {
                quad = new Quad(this.getPoint(3), this.getPoint(0), this.getPoint(4), this.getPoint(7));
                break;
            }
            case 1: {
                quad = new Quad(this.getPoint(1), this.getPoint(2), this.getPoint(6), this.getPoint(5));
                break;
            }
            case 2: {
                quad = new Quad(this.getPoint(0), this.getPoint(1), this.getPoint(5), this.getPoint(4));
                break;
            }
            case 3: {
                quad = new Quad(this.getPoint(2), this.getPoint(3), this.getPoint(7), this.getPoint(6));
                break;
            }
            case 4: {
                quad = new Quad(this.getPoint(3), this.getPoint(2), this.getPoint(1), this.getPoint(0));
                break;
            }
            case 5: {
                quad = new Quad(this.getPoint(4), this.getPoint(5), this.getPoint(6), this.getPoint(7));
                break;
            }
            default: {
                return null;
            }
        }
        if (this.d_colors != null) {
            quad.setColor(this.d_colors[n]);
        }
        return quad;
    }

    public static Quad getFaceForBox(Point3D point3D, Point3D point3D2, int n) {
        Quad quad = null;
        switch (n) {
            case 0: {
                quad = new Quad(new Point3D(point3D.x, point3D2.y, point3D.z), new Point3D(point3D.x, point3D.y, point3D.z), new Point3D(point3D.x, point3D.y, point3D2.z), new Point3D(point3D.x, point3D2.y, point3D2.z));
                break;
            }
            case 1: {
                quad = new Quad(new Point3D(point3D2.x, point3D.y, point3D.z), new Point3D(point3D2.x, point3D2.y, point3D.z), new Point3D(point3D2.x, point3D2.y, point3D2.z), new Point3D(point3D2.x, point3D.y, point3D2.z));
                break;
            }
            case 2: {
                quad = new Quad(new Point3D(point3D.x, point3D.y, point3D.z), new Point3D(point3D2.x, point3D.y, point3D.z), new Point3D(point3D2.x, point3D.y, point3D2.z), new Point3D(point3D.x, point3D.y, point3D2.z));
                break;
            }
            case 3: {
                quad = new Quad(new Point3D(point3D2.x, point3D2.y, point3D.z), new Point3D(point3D.x, point3D2.y, point3D.z), new Point3D(point3D.x, point3D2.y, point3D2.z), new Point3D(point3D2.x, point3D2.y, point3D2.z));
                break;
            }
            case 4: {
                quad = new Quad(new Point3D(point3D.x, point3D2.y, point3D.z), new Point3D(point3D2.x, point3D2.y, point3D.z), new Point3D(point3D2.x, point3D.y, point3D.z), new Point3D(point3D.x, point3D.y, point3D.z));
                break;
            }
            case 5: {
                quad = new Quad(new Point3D(point3D.x, point3D.y, point3D2.z), new Point3D(point3D2.x, point3D.y, point3D2.z), new Point3D(point3D2.x, point3D2.y, point3D2.z), new Point3D(point3D.x, point3D2.y, point3D2.z));
                break;
            }
            default: {
                return null;
            }
        }
        return quad;
    }
}

