/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.IFileImage;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class MVBackgroundImage
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double d_anchorImageX;
    private double d_anchorImageY;
    private UnitPoint2D d_anchorModel;
    private double d_aX;
    private double d_aY;
    private double d_bX;
    private double d_bY;
    private UnitDouble d_distAB;
    private float d_opacity = 1.0f;
    private String d_filename = null;
    private IFileImage d_image;

    public MVBackgroundImage(String string, Point2D point2D, UnitPoint2D unitPoint2D, Point2D point2D2, Point2D point2D3, UnitDouble unitDouble, float f) {
        this.d_anchorImageX = point2D.getX();
        this.d_anchorImageY = point2D.getY();
        this.d_anchorModel = unitPoint2D;
        this.d_aX = point2D2.getX();
        this.d_aY = point2D2.getY();
        this.d_bX = point2D3.getX();
        this.d_bY = point2D3.getY();
        this.d_distAB = unitDouble;
        this.d_opacity = f;
        this.d_filename = string;
    }

    public String toString() {
        Point2D.Double double_ = this.d_anchorModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        double d = this.d_distAB.getValue(Geometry.GEOM_LENGTH_UNIT);
        return this.d_filename + ";" + this.d_anchorImageX + "," + this.d_anchorImageY + ";" + double_.getX() + "," + double_.getY() + ";" + this.d_aX + "," + this.d_bY + ";" + this.d_bX + "," + this.d_bY + ";" + d + ";" + this.d_opacity;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_image != null) {
            this.d_filename = this.d_image.getFilename();
            this.d_image = null;
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof MVBackgroundImage)) {
            return 1;
        }
        return ((MVBackgroundImage)object).getID().compareTo(this.getID());
    }

    public Object clone() {
        try {
            MVBackgroundImage mVBackgroundImage = (MVBackgroundImage)super.clone();
            mVBackgroundImage.d_filename = this.d_filename;
            mVBackgroundImage.d_anchorImageX = this.d_anchorImageX;
            mVBackgroundImage.d_anchorImageY = this.d_anchorImageY;
            mVBackgroundImage.d_anchorModel = (UnitPoint2D)this.d_anchorModel.clone();
            mVBackgroundImage.d_aX = this.d_aX;
            mVBackgroundImage.d_aY = this.d_aY;
            mVBackgroundImage.d_bX = this.d_bX;
            mVBackgroundImage.d_bY = this.d_bY;
            mVBackgroundImage.d_distAB = (UnitDouble)this.d_distAB.clone();
            mVBackgroundImage.d_opacity = this.d_opacity;
            return mVBackgroundImage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MVBackgroundImage)) {
            return false;
        }
        MVBackgroundImage mVBackgroundImage = (MVBackgroundImage)object;
        boolean bl = mVBackgroundImage.d_filename.equals(this.d_filename) && (mVBackgroundImage.d_anchorModel != null ? mVBackgroundImage.d_anchorModel.equals(this.d_anchorModel) : this.d_anchorModel == null) && (mVBackgroundImage.d_distAB != null ? mVBackgroundImage.d_distAB.equals(this.d_distAB) : this.d_distAB == null) && mVBackgroundImage.d_anchorImageX == this.d_anchorImageX && mVBackgroundImage.d_anchorImageY == this.d_anchorImageY && mVBackgroundImage.d_aX == this.d_aX && mVBackgroundImage.d_aY == this.d_aY && mVBackgroundImage.d_bX == this.d_bX && mVBackgroundImage.d_bY == this.d_bY && mVBackgroundImage.d_opacity == this.d_opacity;
        return bl;
    }

    public AffineTransform getTransform() {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.d_anchorModel.x.getValue(unit), this.d_anchorModel.y.getValue(unit));
        double d = 1.0 / this.getBackgroundImageScale().getValue(unit);
        affineTransform.scale(d, d);
        affineTransform.translate(-this.d_anchorImageX, -this.d_anchorImageY);
        return affineTransform;
    }

    public UnitDouble getBackgroundImageScale() {
        double d = this.d_bX - this.d_aX;
        double d2 = this.d_bY - this.d_aY;
        double d3 = Math.sqrt(d * d + d2 * d2);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        return new UnitDouble(d3 / this.d_distAB.getValue(unit), unit);
    }

    public String getID() {
        return this.d_filename;
    }

    public UnitPoint2D getAnchorModel() {
        return this.d_anchorModel;
    }

    public void setAnchorModel(UnitPoint2D unitPoint2D) {
        this.d_anchorModel = unitPoint2D;
    }

    public Point2D getAnchorImage() {
        return new Point2D.Double(this.d_anchorImageX, this.d_anchorImageY);
    }

    public void setAnchorImage(Point2D point2D) {
        this.d_anchorImageX = point2D.getX();
        this.d_anchorImageY = point2D.getY();
    }

    public UnitDouble getDistAB() {
        return this.d_distAB;
    }

    public void setDistAB(UnitDouble unitDouble) {
        this.d_distAB = unitDouble;
    }

    public Point2D getA() {
        return new Point2D.Double(this.d_aX, this.d_aY);
    }

    public void setA(Point2D point2D) {
        this.d_aX = point2D.getX();
        this.d_aY = point2D.getY();
    }

    public Point2D getB() {
        return new Point2D.Double(this.d_bX, this.d_bY);
    }

    public void setB(Point2D point2D) {
        this.d_bX = point2D.getX();
        this.d_bY = point2D.getY();
    }

    public float getOpacity() {
        return this.d_opacity;
    }

    public void setOpacity(float f) {
        this.d_opacity = f;
    }
}

