/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Vector2d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class Wall
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    public static final byte FACE_XMIN = 0;
    public static final byte FACE_XMAX = 1;
    public static final byte FACE_YMIN = 2;
    public static final byte FACE_YMAX = 3;
    public static final byte FACE_ZMIN = 4;
    public static final byte FACE_ZMAX = 5;
    public static final byte FACE_AB = 0;
    public static final byte FACE_ABP = 1;
    public static final byte FACE_A = 2;
    public static final byte FACE_B = 3;
    public static final byte FACE_BOTTOM = 4;
    public static final byte FACE_TOP = 5;
    private UnitPoint2D d_a;
    private UnitPoint2D d_b;
    private UnitDouble d_top;
    private UnitDouble d_bottom;
    private UnitDouble d_thickness;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;
    private transient Vector2d d_lastThicknessVector = null;
    private volatile FDSObject[] d_cachedRasterization = null;

    public Wall(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, Material material) {
        this(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, "Obstruction", material);
    }

    public Wall(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, String string, Material material) {
        super(string);
        this.d_a = unitPoint2D;
        this.d_b = unitPoint2D2;
        this.d_bottom = unitDouble;
        this.d_top = unitDouble2;
        this.d_thickness = unitDouble3;
        this.initFaces(new Material[]{material, material, material, material, material, material});
    }

    private void initFaces(Material[] materialArray) {
        this.d_faces = new Vector(6);
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            int n = this.internalFaceIndexToFDSIndex(by);
            this.d_faces.add(this.createFace(this, by, materialArray[n]));
        }
    }

    protected IFace createFace(Wall wall, byte by, Material material) {
        return new BlockFace(wall, by, material);
    }

    public void invalidateRasterizationCache() {
        if (!this.isAligned()) {
            this.d_cachedRasterization = null;
            ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
        }
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof Wall)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Wall wall = (Wall)object;
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            BlockFace blockFace = (BlockFace)iterator.next();
            blockFace.d_block = this;
        }
        this.d_a = (UnitPoint2D)wall.d_a.clone();
        this.d_b = (UnitPoint2D)wall.d_b.clone();
        this.d_top = (UnitDouble)wall.d_top.clone();
        this.d_bottom = (UnitDouble)wall.d_bottom.clone();
        this.d_thickness = (UnitDouble)wall.d_thickness.clone();
        this.d_thicken = wall.d_thicken;
        this.d_permitHole = wall.d_permitHole;
        this.d_sawtooth = wall.d_sawtooth;
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Wall wall = (Wall)object;
        return this.d_a.equals(wall.d_a) && this.d_b.equals(wall.d_b) && this.d_top.equals(wall.d_top) && this.d_bottom.equals(wall.d_bottom) && this.d_thickness.equals(wall.d_thickness) && this.d_thicken == wall.d_thicken && this.d_permitHole == wall.d_permitHole && this.d_sawtooth == wall.d_sawtooth;
    }

    @Override
    public String getPropertyHashString() {
        String string = super.getPropertyHashString();
        string = string + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return string;
    }

    public UnitPoint2D getStartPoint() {
        return this.d_a;
    }

    public void setStartPoint(UnitPoint2D unitPoint2D) {
        this.d_a = unitPoint2D;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint2D getEndPoint() {
        return this.d_b;
    }

    public void setEndPoint(UnitPoint2D unitPoint2D) {
        this.d_b = unitPoint2D;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public void setBottom(UnitDouble unitDouble) {
        this.d_bottom = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public void setTop(UnitDouble unitDouble) {
        this.d_top = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public void setThickness(UnitDouble unitDouble) {
        this.d_thickness = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    private Vector2d getThicknessVector(double d, Unit unit) {
        Vector2d vector2d;
        double d2 = this.d_b.x.getValue(unit) - this.d_a.x.getValue(unit);
        double d3 = this.d_b.y.getValue(unit) - this.d_a.y.getValue(unit);
        if (Math.abs(d2) < 1.0E-15 && Math.abs(d3) < 1.0E-15) {
            if (this.d_lastThicknessVector != null) {
                return this.d_lastThicknessVector;
            }
            vector2d = new Vector2d(1.0, 0.0);
        } else {
            vector2d = new Vector2d(-d3, d2);
            vector2d.normalize();
        }
        vector2d.scale(d);
        this.d_lastThicknessVector = new Vector2d(vector2d);
        return vector2d;
    }

    public boolean isAligned() {
        return this.d_a.x.equals(this.d_b.x) || this.d_a.y.equals(this.d_b.y);
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry geometry = new Geometry();
        super.getGeometry(geometry);
        Point3D point3D = geometry.getMinPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry geometry = new Geometry();
        super.getGeometry(geometry);
        Point3D point3D = geometry.getMaxPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    public FDSObject[] rasterizeToAllGrids() {
        PyroMod pyroMod = this.getDomains().iterator().next();
        Vector<FDSObject> vector = new Vector<FDSObject>();
        for (Grid grid : pyroMod.getGridManager()) {
            FDSObject[] fDSObjectArray = this.rasterizeToGrid(grid);
            if (fDSObjectArray == null) continue;
            vector.addAll(new VectorFromArray<FDSObject>(fDSObjectArray));
        }
        return vector.toArray(new AlignedBlock[vector.size()]);
    }

    public FDSObject[] rasterizeToGrid(Grid grid) {
        return null;
    }

    protected FDSObject createAlignedSegment(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, Material material, String string) {
        AlignedBlock alignedBlock = new AlignedBlock(unitPoint3D, unitPoint3D2, string, material);
        alignedBlock.setColor(this.getColor());
        alignedBlock.setIsSawtoothed(this.d_sawtooth);
        alignedBlock.setIsThickened(this.d_thicken);
        alignedBlock.setPermitsHole(this.d_permitHole);
        return alignedBlock;
    }

    @Override
    public void getGeometry(Geometry geometry) {
        boolean bl;
        PyroMod pyroMod = this.getDomains().iterator().next();
        boolean bl2 = bl = pyroMod.isPreviewMode() && !pyroMod.getGridManager().isEmpty() && !this.isAligned();
        if (bl) {
            if (this.d_cachedRasterization == null) {
                this.d_cachedRasterization = this.rasterizeToAllGrids();
                assert (this.d_cachedRasterization != null);
            }
            for (int i = 0; i < this.d_cachedRasterization.length; ++i) {
                this.d_cachedRasterization[i].getGeometry(geometry);
            }
        } else {
            super.getGeometry(geometry);
        }
    }

    private int getBoundingDivisionIndex(double[] dArray, double d, boolean bl) {
        int n = Arrays.binarySearch(dArray, d);
        if (n < 0) {
            n = -(n + 1);
            if (bl) {
                --n;
            }
        }
        if (n < 0) {
            n = 0;
        } else if (n >= dArray.length) {
            n = dArray.length - 1;
        }
        return n;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        if (this.isAligned()) {
            Object object;
            FDSInputRecord fDSInputRecord = new FDSInputRecord();
            fDSInputRecord.setType(this.getFDSType());
            Vector<Double> vector = new Vector<Double>(6);
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            Point3D point3D = this.getMinPoint().getValue(unit);
            Point3D point3D2 = this.getMaxPoint().getValue(unit);
            vector.add(new Double(point3D.x));
            vector.add(new Double(point3D2.x));
            vector.add(new Double(point3D.y));
            vector.add(new Double(point3D2.y));
            vector.add(new Double(point3D.z));
            vector.add(new Double(point3D2.z));
            fDSInputRecord.setValue("XB", vector);
            Color color = this.getColor();
            if (color != null) {
                object = color.getRGBComponents(null);
                Vector<Double> vector2 = new Vector<Double>(3);
                vector2.add(new Double((double)object[0]));
                vector2.add(new Double((double)object[1]));
                vector2.add(new Double((double)object[2]));
                fDSInputRecord.setValue("RGB", vector2);
            }
            fDSInputRecord.setComment(this.getName());
            this.fillInputRecordExtras(fDSInputRecord);
            object = this.getEventInputRecords(fDSInputRecord);
            if (object.size() != 0) {
                collection.addAll((Collection<FDSInputRecord>)object);
            } else {
                collection.add(fDSInputRecord);
            }
        } else {
            FDSObject[] fDSObjectArray;
            PyroMod pyroMod = this.getDomains().iterator().next();
            if (!pyroMod.getGridManager().isEmpty() && (fDSObjectArray = this.rasterizeToAllGrids()) != null) {
                for (int i = 0; i < fDSObjectArray.length; ++i) {
                    fDSObjectArray[i].getInputRecords(collection);
                }
            }
        }
    }

    protected void fillInputRecordExtras(FDSInputRecord fDSInputRecord) {
        int[] nArray = new int[]{this.fdsFaceIndexToInternalIndex(0), this.fdsFaceIndexToInternalIndex(1), this.fdsFaceIndexToInternalIndex(2), this.fdsFaceIndexToInternalIndex(3), this.fdsFaceIndexToInternalIndex(4), this.fdsFaceIndexToInternalIndex(5)};
        if (this.isUniformMaterial()) {
            fDSInputRecord.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[1])).getMaterial() && ((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[2])).getMaterial() && ((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[3])).getMaterial()) {
            VectorFromArray<String> vectorFromArray = new VectorFromArray<String>(((IFace)this.d_faces.get(nArray[5])).getMaterial().getName(), ((IFace)this.d_faces.get(nArray[0])).getMaterial().getName(), ((IFace)this.d_faces.get(nArray[4])).getMaterial().getName());
            fDSInputRecord.setValue("SURF_IDS", vectorFromArray);
        } else {
            Vector<String> vector = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                BlockFace blockFace = (BlockFace)this.d_faces.get(nArray[i]);
                vector.add(blockFace.getMaterial().getName());
            }
            fDSInputRecord.setValue("SURF_ID6", vector);
        }
        fDSInputRecord.setValue("PERMIT_HOLE", new Boolean(this.d_permitHole));
        fDSInputRecord.setValue("SAWTOOTH", new Boolean(this.d_sawtooth));
        fDSInputRecord.setValue("THICKEN", new Boolean(this.d_thicken));
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    protected int fdsFaceIndexToInternalIndex(int n) {
        for (int i = 0; i < this.d_faces.size(); ++i) {
            int n2 = this.internalFaceIndexToFDSIndex(i);
            if (n != n2) continue;
            return i;
        }
        return -1;
    }

    protected int internalFaceIndexToFDSIndex(int n) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        double d = this.getThickness().getValue(unit);
        int n2 = this.d_a.x.getValue(unit) < this.d_b.x.getValue(unit) ? (d < 0.0 ? 1 : 0) : (this.d_a.x.getValue(unit) > this.d_b.x.getValue(unit) ? (d < 0.0 ? 3 : 2) : (this.d_a.y.getValue(unit) < this.d_b.y.getValue(unit) ? (d < 0.0 ? 5 : 4) : (d < 0.0 ? 7 : 6)));
        switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return n;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return n;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return n;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return n;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return n;
            }
            case 5: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return n;
            }
            case 6: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return n;
            }
            case 7: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return n;
            }
        }
        return n;
    }

    @Override
    public void setMaterial(int n, Material material) {
        int n2 = this.fdsFaceIndexToInternalIndex(n);
        ((IFace)this.d_faces.get(n2)).setMaterial(material);
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void fireDomainEvent(IDomainEvent iDomainEvent) {
        if (iDomainEvent instanceof FDSObjectDomainEvent) {
            int n = ((FDSObjectDomainEvent)iDomainEvent).getEventType();
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.d_cachedRasterization = null;
                }
            }
        }
        ADomainObject.fireDomainEvent(this, iDomainEvent);
    }

    public void resumeUpdates(IDomainEvent iDomainEvent) {
        if (iDomainEvent instanceof FDSObjectDomainEvent) {
            int n = ((FDSObjectDomainEvent)iDomainEvent).getEventType();
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.d_cachedRasterization = null;
                }
            }
        }
        ADomainObject.resumeUpdates(this, iDomainEvent);
    }

    @Override
    public Material getMaterial(int n) {
        int n2 = this.fdsFaceIndexToInternalIndex(n);
        return ((IFace)this.d_faces.get(n2)).getMaterial();
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean bl) {
        this.d_permitHole = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean bl) {
        this.d_sawtooth = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean bl) {
        this.d_thicken = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Wall";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    public static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Wall d_block;
        private byte d_index;

        public BlockFace(Wall wall, byte by, Material material) {
            super(material);
            this.d_block = wall;
            this.d_index = by;
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry geometry) {
        }

        protected Color getDefaultColor() {
            return this.getMaterial().getColor();
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object) || !(object instanceof BlockFace)) {
                return false;
            }
            BlockFace blockFace = (BlockFace)object;
            return this.d_index == blockFace.d_index;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            byte by;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.d_index = by = getField.get("d_index", (byte)0);
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }
}

