/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedHole;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Hole
extends Wall
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        super(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, null);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Hole)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void imprint(Object object) {
        if (!(object instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Hole hole = (Hole)object;
        this.setColor(hole.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void fillInputRecordExtras(FDSInputRecord fDSInputRecord) {
    }

    @Override
    protected FDSObject createAlignedSegment(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, Material material, String string) {
        AlignedHole alignedHole = new AlignedHole(unitPoint3D, unitPoint3D2, string);
        alignedHole.setColor(this.getColor());
        return alignedHole;
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            super.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void setMaterial(int n, Material material) {
    }

    @Override
    public Material getMaterial(int n) {
        return null;
    }

    @Override
    protected IFace createFace(Wall wall, byte by, Material material) {
        return new BlockFace(wall, by, material);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        if (iDependedOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(iDependedOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        if (Material.class.isAssignableFrom(clazz)) {
            return;
        }
        super.getObjectsDependedOn(set, clazz);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(iDependedOn, object);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(iDependedOn, iDependedOn2);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(iDependedOn, string);
    }

    public static class BlockFace
    extends Wall.BlockFace
    implements Serializable {
        static final long serialVersionUID = 1L;

        public BlockFace(Wall wall, byte by, Material material) {
            super(wall, by, material);
        }

        @Override
        protected Color getDefaultColor() {
            return DEF_COLOR;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        }
    }
}

