/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class AlignedBlock
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;
    public static final byte MIN_X = 0;
    public static final byte MAX_X = 1;
    public static final byte MIN_Y = 2;
    public static final byte MAX_Y = 3;
    public static final byte MIN_Z = 4;
    public static final byte MAX_Z = 5;
    public static final int NUM_FACES = 6;
    private static final String[] FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private static final int NUM_ROT_AXES = 3;
    private static final byte[][] FACE_INDEX_ROT_LU;

    public AlignedBlock(Material material) {
        this(null, null, material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, Material material) {
        this(unitPoint3D, unitPoint3D2, "Obstruction", material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Material material) {
        this(unitPoint3D, unitPoint3D2, string, null, material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Color color, Material material) {
        super(string);
        this.d_minPoint = unitPoint3D;
        this.d_maxPoint = unitPoint3D2;
        this.d_faces = new Vector(6);
        for (byte by = 0; by <= 5; by = (byte)(by + 1)) {
            this.d_faces.add(new AlignedBlockFace(this, by, material));
        }
        this.setColor(color);
    }

    @Override
    public Object clone() {
        AlignedBlock alignedBlock = (AlignedBlock)super.clone();
        return alignedBlock;
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof AlignedBlock)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        AlignedBlock alignedBlock = (AlignedBlock)object;
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            ((AlignedBlockFace)iterator.next()).d_block = this;
        }
        this.d_minPoint = (UnitPoint3D)alignedBlock.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)alignedBlock.d_maxPoint.clone();
        this.d_thicken = alignedBlock.d_thicken;
        this.d_permitHole = alignedBlock.d_permitHole;
        this.d_sawtooth = alignedBlock.d_sawtooth;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AlignedBlock alignedBlock = (AlignedBlock)object;
        return (this.d_minPoint == null && alignedBlock.d_minPoint == null || this.d_minPoint != null && this.d_minPoint.equals(alignedBlock.d_minPoint)) && (this.d_maxPoint == null && alignedBlock.d_maxPoint == null || this.d_maxPoint != null && this.d_maxPoint.equals(alignedBlock.d_maxPoint)) && this.d_thicken == alignedBlock.d_thicken && this.d_permitHole == alignedBlock.d_permitHole && this.d_sawtooth == alignedBlock.d_sawtooth;
    }

    @Override
    public String getPropertyHashString() {
        BaseUnit baseUnit = SI.METER;
        String string = super.getPropertyHashString();
        if (this.d_minPoint != null) {
            string = string + this.d_minPoint.x(baseUnit) + "," + this.d_minPoint.y(baseUnit) + "," + this.d_minPoint.z(baseUnit) + ";";
        }
        if (this.d_maxPoint != null) {
            string = string + this.d_maxPoint.x(baseUnit) + "," + this.d_maxPoint.y(baseUnit) + "," + this.d_maxPoint.z(baseUnit) + ";";
        }
        string = string + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream pyroSimObjectInputStream = (PyroSimObjectInputStream)objectInputStream;
            if (pyroSimObjectInputStream.getVersion() < 15) {
                this.ensureKeyed();
                if (this.getName() == null) {
                    this.initDomainHelper();
                    System.out.print("Reading old Block object into AlignedBlock: ");
                    ObjectInputStream.GetField getField = objectInputStream.readFields();
                    String string = (String)getField.get("d_name", null);
                    this.taskSetName(string).run();
                    this.setVisible(true);
                    this.d_minPoint = (UnitPoint3D)getField.get("d_minPoint", null);
                    this.d_maxPoint = (UnitPoint3D)getField.get("d_maxPoint", null);
                    Material[] materialArray = (Material[])getField.get("d_materials", null);
                    this.d_faces = new Vector(6);
                    for (byte by = 0; by <= 5; by = (byte)(by + 1)) {
                        this.d_faces.add(new AlignedBlockFace(this, by, materialArray[by]));
                    }
                    this.initEvents();
                    this.d_permitHole = true;
                    this.d_sawtooth = true;
                } else {
                    objectInputStream.defaultReadObject();
                }
            } else {
                objectInputStream.defaultReadObject();
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    public void setMinPoint(UnitPoint3D unitPoint3D) {
        this.d_minPoint = unitPoint3D;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setMaxPoint(UnitPoint3D unitPoint3D) {
        this.d_maxPoint = unitPoint3D;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public String toString() {
        String string = "";
        String string2 = this.getName();
        if (string2 != null && !string2.equals("")) {
            string = string + " [" + string2 + "]";
        }
        return string;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public Material getMaterial(int n) {
        return ((IFace)this.d_faces.get(n)).getMaterial();
    }

    @Override
    public void setMaterial(int n, Material material) {
        ((IFace)this.d_faces.get(n)).setMaterial(material);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Material material = this.getMaterial(0);
        for (int i = 0; i < 6; ++i) {
            if (material == this.getMaterial(i)) continue;
            return null;
        }
        return material;
    }

    @Override
    public boolean isUniformMaterial() {
        return this.getMaterial() != null;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Serializable serializable;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("OBST");
        Vector<Double> vector = new Vector<Double>(6);
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        vector.add(new Double(this.d_minPoint.x(unit)));
        vector.add(new Double(this.d_maxPoint.x(unit)));
        vector.add(new Double(this.d_minPoint.y(unit)));
        vector.add(new Double(this.d_maxPoint.y(unit)));
        vector.add(new Double(this.d_minPoint.z(unit)));
        vector.add(new Double(this.d_maxPoint.z(unit)));
        fDSInputRecord.setValue("XB", vector);
        if (this.isUniformMaterial()) {
            fDSInputRecord.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            serializable = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            fDSInputRecord.setValue("SURF_IDS", serializable);
        } else {
            serializable = new Vector(6);
            for (int i = 0; i < 6; ++i) {
                ((Vector)serializable).add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            fDSInputRecord.setValue("SURF_ID6", serializable);
        }
        serializable = this.getColor();
        if (serializable != null) {
            float[] fArray = ((Color)serializable).getRGBComponents(null);
            Vector<Double> vector2 = new Vector<Double>(3);
            vector2.add(new Double(fArray[0]));
            vector2.add(new Double(fArray[1]));
            vector2.add(new Double(fArray[2]));
            fDSInputRecord.setValue("RGB", vector2);
        }
        fDSInputRecord.setValue("PERMIT_HOLE", new Boolean(this.d_permitHole));
        fDSInputRecord.setValue("SAWTOOTH", new Boolean(this.d_sawtooth));
        fDSInputRecord.setValue("THICKEN", new Boolean(this.d_thicken));
        fDSInputRecord.setComment(this.getName());
        Collection collection2 = this.getEventInputRecords(fDSInputRecord);
        if (collection2.size() != 0) {
            collection.addAll(collection2);
        } else {
            collection.add(fDSInputRecord);
        }
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean bl) {
        this.d_permitHole = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean bl) {
        this.d_sawtooth = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean bl) {
        this.d_thicken = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Aligned Block";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    static {
        byte[][] byArray = FACE_INDEX_ROT_LU = new byte[3][6];
        byArray[0][0] = 0;
        byArray[0][1] = 1;
        byArray[0][2] = 4;
        byArray[0][3] = 5;
        byArray[0][4] = 3;
        byArray[0][5] = 2;
        byArray[1][0] = 5;
        byArray[1][1] = 4;
        byArray[1][2] = 2;
        byArray[1][3] = 3;
        byArray[1][4] = 0;
        byArray[1][5] = 1;
        byArray[2][0] = 2;
        byArray[2][1] = 3;
        byArray[2][2] = 1;
        byArray[2][3] = 0;
        byArray[2][4] = 4;
        byArray[2][5] = 5;
    }

    public static class AlignedBlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AlignedBlock d_block;
        private byte d_index;

        public AlignedBlockFace() {
        }

        public AlignedBlockFace(AlignedBlock alignedBlock, byte by, Material material) {
            super(material);
            this.d_block = alignedBlock;
            this.d_index = by;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof AlignedBlockFace)) {
                return false;
            }
            AlignedBlockFace alignedBlockFace = (AlignedBlockFace)object;
            return this.d_index == alignedBlockFace.d_index;
        }

        @Override
        public void setMaterial(Material material) {
            super.setMaterial(material);
        }

        @Override
        public String getName() {
            return FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry geometry) {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            byte by;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.d_index = by = getField.get("d_index", (byte)0);
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }

    private abstract class ModifyGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private final Material[] d_mats;

        public abstract void modify();

        public ModifyGeomTask(int n, boolean bl) {
            super(n, bl);
            this.d_mats = new Material[6];
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AlignedBlock.this);
            AlignedBlock.this.setMinPoint(this.d_min);
            AlignedBlock.this.setMaxPoint(this.d_max);
            for (int i = 0; i < 6; ++i) {
                ((IFace)AlignedBlock.this.d_faces.get(i)).setMaterial(this.d_mats[i]);
            }
            ADomainObject.resumeUpdates(AlignedBlock.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)AlignedBlock.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)AlignedBlock.this.getMaxPoint().clone();
            for (int i = 0; i < 6; ++i) {
                this.d_mats[i] = ((IFace)AlignedBlock.this.d_faces.get(i)).getMaterial();
            }
            this.modify();
        }
    }
}

