/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v15;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public class Hole
extends AlignedBlock
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole() {
        this((UnitPoint3D)null, (UnitPoint3D)null);
    }

    public Hole(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        this(unitPoint3D, unitPoint3D2, "Hole");
    }

    public Hole(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string) {
        super(unitPoint3D, unitPoint3D2, string, null);
        this.setColor(null);
    }

    @Override
    public Object clone() {
        Hole hole = (Hole)super.clone();
        return hole;
    }

    @Override
    public void imprint(Object object) {
        if (!(object instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Hole hole = (Hole)object;
        this.setColor(hole.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Hole)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            super.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String toString() {
        String string = "";
        String string2 = this.getName();
        if (string2 != null && !string2.equals("")) {
            string = string + " [" + string2 + "]";
        }
        return string;
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Object object;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("HOLE");
        UnitPoint3D unitPoint3D = this.getMinPoint();
        UnitPoint3D unitPoint3D2 = this.getMaxPoint();
        Vector<Double> vector = new Vector<Double>(6);
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        vector.add(new Double(unitPoint3D.x(unit)));
        vector.add(new Double(unitPoint3D2.x(unit)));
        vector.add(new Double(unitPoint3D.y(unit)));
        vector.add(new Double(unitPoint3D2.y(unit)));
        vector.add(new Double(unitPoint3D.z(unit)));
        vector.add(new Double(unitPoint3D2.z(unit)));
        fDSInputRecord.setValue("XB", vector);
        fDSInputRecord.setComment(this.getName());
        if (this.getColor() != null) {
            object = this.getColor().getRGBComponents(null);
            Vector<Double> vector2 = new Vector<Double>(3);
            vector2.add(new Double((double)object[0]));
            vector2.add(new Double((double)object[1]));
            vector2.add(new Double((double)object[2]));
            fDSInputRecord.setValue("RGB", vector2);
        }
        if ((object = this.getEventInputRecords(fDSInputRecord)).size() != 0) {
            collection.addAll((Collection<FDSInputRecord>)object);
        } else {
            collection.add(fDSInputRecord);
        }
    }

    @Override
    public void setMaterial(int n, Material material) {
    }

    @Override
    public Material getMaterial(int n) {
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        if (iDependedOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(iDependedOn);
    }
}

