/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import pyrosim.legacy_2006_2.domain.Material;

public class MaterialList
extends Hashtable {
    static final long serialVersionUID = 1L;
    private MaterialList d_parent = null;
    private pyrosim.legacy_2006_2.domain.MaterialList d_newParent = null;

    public MaterialList() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = getField.get("d_parent", null);
        if (object != null && object instanceof MaterialList) {
            this.d_parent = (MaterialList)object;
        } else if (object != null && object instanceof pyrosim.legacy_2006_2.domain.MaterialList) {
            this.d_newParent = (pyrosim.legacy_2006_2.domain.MaterialList)object;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MaterialList)) {
            return false;
        }
        MaterialList materialList = (MaterialList)object;
        if (this.d_parent != null && !this.d_parent.equals(materialList.d_parent)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int size() {
        return this.getNumLeafMats();
    }

    public int getNumMats() {
        if (this.d_parent != null) {
            return this.d_parent.getNumMats() + this.getNumLeafMats();
        }
        return this.getNumLeafMats();
    }

    public int getNumLeafMats() {
        return super.size();
    }

    public MaterialList(MaterialList materialList) {
        this.setParent(materialList);
        if (materialList == null) {
            // empty if block
        }
    }

    public void addMaterial(Material material) {
        if (this.getMaterial(material.getName()) == null) {
            this.put(material.getName(), material);
        }
    }

    public Material getMaterial(String string) {
        if (this.containsKey(string)) {
            return (Material)this.get(string);
        }
        if (this.d_parent != null) {
            return this.d_parent.getMaterial(string);
        }
        return null;
    }

    public boolean remove(String string) {
        return super.remove(string) != null;
    }

    public Material[] getAllMaterials() {
        List list = this.getKeyListUnion();
        ArrayList<Material> arrayList = new ArrayList<Material>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.getMaterial((String)list.get(i)));
        }
        return arrayList.toArray(new Material[this.size()]);
    }

    public Material[] getLeafMaterials() {
        return this.values().toArray(new Material[this.size()]);
    }

    public boolean isLeafMat(String string) {
        return this.containsKey(string);
    }

    public List getKeyListUnion() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.keySet());
        MaterialList materialList = this.d_parent;
        while (materialList != null) {
            arrayList.addAll(materialList.keySet());
            materialList = materialList.d_parent;
        }
        return arrayList;
    }

    public MaterialList getParent() {
        return this.d_parent;
    }

    public pyrosim.legacy_2006_2.domain.MaterialList getNewParent() {
        return this.d_newParent;
    }

    public void setParent(MaterialList materialList) {
        if (materialList != null && materialList.d_parent != null && materialList.d_parent.d_parent != null) {
            throw new IllegalArgumentException("3-level parenting is max for MaterialList.");
        }
        this.d_parent = materialList;
    }

    @Override
    public Object clone() {
        MaterialList materialList = null;
        if (this.d_parent != null) {
            materialList = (MaterialList)this.d_parent.clone();
        }
        MaterialList materialList2 = new MaterialList(materialList);
        Material[] materialArray = this.getAllMaterials();
        for (int i = 0; i < materialArray.length; ++i) {
            Material material = (Material)materialArray[i].clone();
            materialList2.addMaterial(material);
        }
        return materialList2;
    }

    public List getAllNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        Material[] materialArray = this.getAllMaterials();
        for (int i = 0; i < materialArray.length; ++i) {
            arrayList.add(materialArray[i].getName());
        }
        return arrayList;
    }
}

