/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSColors;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

class VentProcessor
extends AFDSRecordProcessor {
    private int d_nextVentNum = 1;
    private Hashtable d_allVents = new Hashtable(243);

    public VentProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "VENT";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        if (!fDSInputRecord.getType().equals("VENT")) {
            return false;
        }
        try {
            UnitPoint3D[] unitPoint3DArray;
            int n;
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            String string = null;
            Vector<UnitPoint3D[]> vector = new Vector<UnitPoint3D[]>();
            Vector vector2 = (Vector)fDSInputRecord.getValue("XB");
            Vector<String> vector3 = new Vector<String>();
            string = (String)fDSInputRecord.getValue("CB");
            Double d = (Double)fDSInputRecord.getValue("PBX");
            Double d2 = (Double)fDSInputRecord.getValue("PBY");
            Double d3 = (Double)fDSInputRecord.getValue("PBZ");
            int n2 = 0;
            if (string != null) {
                ++n2;
            }
            if (vector2 != null) {
                ++n2;
            }
            if (d != null) {
                ++n2;
            }
            if (d2 != null) {
                ++n2;
            }
            if (d3 != null) {
                ++n2;
            }
            if (n2 != 1) {
                throw new FDSRecordFormatException(fDSInputRecord, "The geometry of the vent must be specified through only one of the following fields:\nXB, CB, PBX, PBY, or PBZ.");
            }
            if (string != null || d != null || d2 != null || d3 != null) {
                void var14_19;
                n = 0;
                Object var14_18 = null;
                for (PyroMod pyroMod : this.getSourceContainers()) {
                    if (pyroMod.getGridManager().isEmpty()) continue;
                    n = 1;
                    Grid grid = pyroMod.getGridManager().iterator().next();
                }
                if (n == 0) {
                    throw new FDSRecordFormatException(fDSInputRecord, "The use of CB, PBX, PBY, or PBZ requires at least one grid to be\ndefined, but no grids exist in the model.");
                }
                unitPoint3DArray = var14_19.getMinPoint();
                UnitPoint3D unitPoint3D = var14_19.getMaxPoint();
                double d4 = unitPoint3DArray.x(unit);
                double d5 = unitPoint3D.x(unit);
                double d6 = unitPoint3DArray.y(unit);
                double d7 = unitPoint3D.y(unit);
                double d8 = unitPoint3DArray.z(unit);
                double d9 = unitPoint3D.z(unit);
                for (PyroMod pyroMod : this.getSourceContainers()) {
                    for (Grid grid : pyroMod.getGridManager()) {
                        UnitPoint3D unitPoint3D2 = grid.getMinPoint();
                        UnitPoint3D unitPoint3D3 = grid.getMaxPoint();
                        double d10 = unitPoint3D2.x(unit);
                        double d11 = unitPoint3D3.x(unit);
                        double d12 = unitPoint3D2.y(unit);
                        double d13 = unitPoint3D3.y(unit);
                        double d14 = unitPoint3D2.z(unit);
                        double d15 = unitPoint3D3.z(unit);
                        if (string != null) {
                            if (string.equals("XBAR0")) {
                                d11 = unitPoint3D2.x(unit);
                            } else if (string.equals("XBAR")) {
                                d10 = unitPoint3D3.x(unit);
                            } else if (string.equals("YBAR0")) {
                                d13 = unitPoint3D2.y(unit);
                            } else if (string.equals("YBAR")) {
                                d12 = unitPoint3D3.y(unit);
                            } else if (string.equals("ZBAR0")) {
                                d15 = unitPoint3D2.z(unit);
                            } else {
                                if (!string.equals("ZBAR")) throw new FDSRecordFormatException(fDSInputRecord, string + " is an invalid model boundary.");
                                d14 = unitPoint3D3.z(unit);
                            }
                            UnitPoint3D[] unitPoint3DArray2 = new UnitPoint3D[]{new UnitPoint3D(d10, d12, d14, unit), new UnitPoint3D(d11, d13, d15, unit)};
                            vector.add(unitPoint3DArray2);
                            String string2 = "Vent for " + grid.getName() + " " + string;
                            vector3.add(string2);
                            continue;
                        }
                        if (d10 < d4) {
                            d4 = d10;
                        }
                        if (d11 > d5) {
                            d5 = d11;
                        }
                        if (d12 < d6) {
                            d6 = d12;
                        }
                        if (d13 > d7) {
                            d7 = d13;
                        }
                        if (d14 < d8) {
                            d8 = d14;
                        }
                        if (!(d15 > d9)) continue;
                        d9 = d15;
                    }
                }
                if (string == null) {
                    UnitPoint3D[] unitPoint3DArray3 = new UnitPoint3D[2];
                    if (d != null) {
                        unitPoint3DArray3[0] = new UnitPoint3D(d, d6, d8, unit);
                        unitPoint3DArray3[1] = new UnitPoint3D(d, d7, d9, unit);
                    } else if (d2 != null) {
                        unitPoint3DArray3[0] = new UnitPoint3D(d4, d2, d8, unit);
                        unitPoint3DArray3[1] = new UnitPoint3D(d5, d2, d9, unit);
                    } else if (d3 != null) {
                        unitPoint3DArray3[0] = new UnitPoint3D(d4, d6, d3, unit);
                        unitPoint3DArray3[1] = new UnitPoint3D(d5, d7, d3, unit);
                    }
                    vector.add(unitPoint3DArray3);
                    String string3 = "Vent #" + this.d_nextVentNum++;
                    vector3.add(string3);
                }
            } else if (vector2 != null) {
                UnitPoint3D unitPoint3D = new UnitPoint3D((Double)vector2.get(0), (Double)vector2.get(2), (Double)vector2.get(4), unit);
                UnitPoint3D unitPoint3D4 = new UnitPoint3D((Double)vector2.get(1), (Double)vector2.get(3), (Double)vector2.get(5), unit);
                unitPoint3DArray = new UnitPoint3D[]{unitPoint3D, unitPoint3D4};
                vector.add(unitPoint3DArray);
            }
            for (n = 0; n < vector.size(); ++n) {
                Vent vent;
                Object object;
                UnitPoint3D[] unitPoint3DArray4 = (UnitPoint3D[])vector.get(n);
                unitPoint3DArray = unitPoint3DArray4[0];
                UnitPoint3D unitPoint3D = unitPoint3DArray4[1];
                String string4 = null;
                if (vector3.size() > 0) {
                    string4 = (String)vector3.get(n);
                }
                int n3 = 0;
                if (unitPoint3DArray.xu().equals(unitPoint3D.xu())) {
                    ++n3;
                }
                if (unitPoint3DArray.yu().equals(unitPoint3D.yu())) {
                    ++n3;
                }
                if (unitPoint3DArray.zu().equals(unitPoint3D.zu())) {
                    ++n3;
                }
                if (n3 != 1) {
                    throw new FDSRecordFormatException(fDSInputRecord, "Two of the six coordinates must be the same (i.e. xmin = xmax OR ymin = ymax OR zmin = zmax).");
                }
                Rectifier.rectify((UnitPoint3D)unitPoint3DArray, unitPoint3D);
                Vent vent2 = new Vent((UnitPoint3D)unitPoint3DArray, unitPoint3D, null, this.getParsingInfo().getDefaultMaterial());
                Object object2 = fDSInputRecord.getValue("SURF_ID");
                if (object2 != null) {
                    Material material = this.getResource(object2, Material.class);
                    if (material == null) throw new FDSRecordFormatException(fDSInputRecord, "The surface, \"" + object2 + ",\" does not exist.");
                    vent2.setMaterial(material);
                } else {
                    vent2.setMaterial(this.getParsingInfo().getDefaultMaterial());
                }
                Color color = this.parseColor(fDSInputRecord);
                if (color != null) {
                    vent2.setColor(color);
                } else {
                    object = (String)fDSInputRecord.getValue("COLOR");
                    if (object != null) {
                        if (((String)object).equalsIgnoreCase("INVISIBLE")) {
                            vent2.setVisible(false);
                        }
                        vent2.setColor(FDSColors.getColor((String)object));
                    }
                }
                object = (Double)fDSInputRecord.getValue("IOR");
                if (object != null) {
                    int n4 = ((Double)object).intValue();
                    if (!vent2.isFDSNormalValid(n4)) {
                        throw new FDSRecordFormatException(fDSInputRecord, "The specified VENT uses an incorrect value for IOR.  IOR must correspond with a value\nnormal to the plane in which the VENT lies, and it must be one of the following:\nIOR=-1 : the vent's normal is in the -x direction\nIOR=1  : the vent's normal is in the +x direction\nIOR=-2 : the vent's normal is in the -y direction\nIOR=2  : the vent's normal is in the +y direction\nIOR=-3 : the vent's normal is in the -z direction\nIOR=3  : the vent's normal is in the +z direction\n");
                    }
                    vent2.setFDSNormal(n4);
                }
                boolean bl2 = (vent = (Vent)EventParser.getCorrectObject(this.d_allVents, vent2)) != vent2;
                vent2 = vent;
                if (vent2.getName() == null) {
                    String string5 = fDSInputRecord.getComment();
                    if (string5.equals("")) {
                        string5 = string4 == null ? new String("Vent #" + this.d_nextVentNum++) : string4;
                    }
                    vent2.taskSetName(string5).run();
                }
                if (string4 != null) {
                    vent2.setVisible(false);
                }
                String[] stringArray = new String[]{"T_OPEN", "T_ACTIVATE"};
                String[] stringArray2 = new String[]{"T_CLOSE", "T_DEACTIVATE"};
                String string6 = "HEAT_ACTIVATE";
                String string7 = "HEAT_DEACTIVATE";
                EventParser.parseEvents(this, vent2, fDSInputRecord, stringArray, stringArray2, string6, string7, this.getContainer().getHeatDetectors());
                if (bl2) continue;
                this.getContainer().getObstructions().taskAdd(vent2).run();
                this.flagPyroTypeAffected(Vent.class);
                this.d_allVents.put(vent2.getPropertyHashString(), vent2);
            }
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        if (!bl) return true;
        if (fDSRecordFormatException == null) throw new FDSRecordFormatException(fDSInputRecord);
        throw fDSRecordFormatException;
    }

    @Override
    public void done() {
    }

    private UnitDouble makeDouble(Object object) {
        return new UnitDouble((Double)object, FdsSISystem.getInstance().getLengthUnit());
    }
}

