/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class TimeProcessor
extends AFDSRecordProcessor {
    public TimeProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "TIME";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        if (!"TIME".equals(fDSInputRecord.getType())) {
            return false;
        }
        boolean bl = false;
        try {
            Unit unit = FdsSISystem.getInstance().getTimeUnit();
            PyroMod.TimeRecord timeRecord = this.getContainer().getTimeManager().getTimeRecord();
            UnitDouble unitDouble = fDSInputRecord.extractDouble("TWFIN", unit, timeRecord.getSimulationStopTime(), (UnitDoubleValueRange)PyroMod.TimeRecord.getValueRange("TWFIN"));
            timeRecord.setSimulationStopTime(unitDouble);
            UnitDouble unitDouble2 = fDSInputRecord.extractDouble("DT", unit, timeRecord.getInitialTimeStep(), (UnitDoubleValueRange)PyroMod.TimeRecord.getValueRange("DT"));
            timeRecord.setInitialTimeStep(unitDouble2);
            this.flagPyroTypeAffected(PyroMod.TimeRecord.class);
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        if (bl) {
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }
}

