/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

class ThcpProcessor
extends AFDSRecordProcessor {
    public ThcpProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "THCP";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        FDSRecordFormatException fDSRecordFormatException;
        boolean bl;
        block17: {
            bl = false;
            fDSRecordFormatException = null;
            try {
                if (fDSInputRecord.getType() == null) {
                    throw new Exception();
                }
                if (!"THCP".equals(fDSInputRecord.getType())) {
                    return false;
                }
                boolean bl2 = this.containsUnsupportedRecords(fDSInputRecord);
                Vector vector = (Vector)fDSInputRecord.getValue("XYZ");
                String string = (String)fDSInputRecord.getValue("QUANTITY");
                String string2 = (String)fDSInputRecord.getValue("LABEL");
                FdsSISystem fdsSISystem = FdsSISystem.getInstance();
                Unit unit = fdsSISystem.getLengthUnit();
                FdsSISystem fdsSISystem2 = FdsSISystem.getInstance();
                UnitDouble unitDouble = fDSInputRecord.extractDouble("DTSAM", fdsSISystem2.getTimeUnit(), null, (UnitDoubleValueRange)ThcpRecord.getValueRange("DTSAM"));
                Vector vector2 = (Vector)fDSInputRecord.getValue("XB");
                UnitDouble unitDouble2 = fDSInputRecord.extractDouble("DEPTH", fdsSISystem2.getLengthUnit(), null, null, true);
                UnitDouble unitDouble3 = fDSInputRecord.extractDouble("DIAMETER", fdsSISystem2.getLengthUnit(), null, null, true);
                UnitDouble unitDouble4 = fDSInputRecord.extractDouble("EMISSIVITY", fdsSISystem2.getUnitlessUnit(), null, null, true);
                int n = fDSInputRecord.extractInt("IOR", Integer.MIN_VALUE, null);
                int n2 = fDSInputRecord.extractInt("K_HIGH", Integer.MIN_VALUE, null);
                int n3 = fDSInputRecord.extractInt("K_LOW", Integer.MIN_VALUE, null);
                ThcpRecord thcpRecord = new ThcpRecord();
                if (vector != null) {
                    thcpRecord.d_location = new UnitPoint3D((Double)vector.elementAt(0), (Double)vector.elementAt(1), (Double)vector.elementAt(2), unit);
                }
                thcpRecord.d_gasPhaseQuantity = string;
                if (string2 == null || string2.equals("")) {
                    string2 = "Thermocouple";
                }
                thcpRecord.d_label = string2;
                thcpRecord.d_dtsam = unitDouble;
                if (vector2 != null) {
                    thcpRecord.d_xb = new UnitBox3D((Double)vector2.get(0), (Double)vector2.get(2), (Double)vector2.get(4), (Double)vector2.get(1), (Double)vector2.get(3), (Double)vector2.get(5), fdsSISystem2.getLengthUnit());
                }
                thcpRecord.d_depth = unitDouble2;
                thcpRecord.d_diameter = unitDouble3;
                thcpRecord.d_emissivity = unitDouble4;
                thcpRecord.d_ior = n != Integer.MIN_VALUE ? Integer.valueOf(n) : null;
                thcpRecord.d_kHigh = n2 != Integer.MIN_VALUE ? Integer.valueOf(n2) : null;
                Integer n4 = thcpRecord.d_kLow = n3 != Integer.MIN_VALUE ? Integer.valueOf(n3) : null;
                if (!bl2 && vector != null && string != null) {
                    if (!this.getContainer().getThcpList().canMakeUnique(thcpRecord)) {
                        return true;
                    }
                    this.getContainer().getThcpList().taskMakeUnique(thcpRecord).run();
                    this.getContainer().getThcpList().taskAdd(thcpRecord).run();
                    this.flagPyroTypeAffected(ThcpRecord.class);
                    break block17;
                }
                if (bl2 && string != null) {
                    if (!(string.equalsIgnoreCase("VOLUME FLOW") || string.equalsIgnoreCase("MASS FLOW") || string.equalsIgnoreCase("HEAT FLOW") || string.equalsIgnoreCase("HRR"))) {
                        System.err.println("Unsupported integrated quantity in THCP.");
                        return false;
                    }
                    this.getContainer().getThcpList().taskMakeUnique(thcpRecord).run();
                    this.getContainer().getThcpList().taskAdd(thcpRecord).run();
                    this.flagPyroTypeAffected(ThcpRecord.class);
                    break block17;
                }
                throw new Exception();
            }
            catch (FDSRecordFormatException fDSRecordFormatException2) {
                bl = true;
                fDSRecordFormatException = fDSRecordFormatException2;
            }
            catch (NullPointerException nullPointerException) {
                bl = true;
            }
            catch (ClassCastException classCastException) {
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = true;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private boolean containsUnsupportedRecords(FDSInputRecord fDSInputRecord) {
        GasPhaseQuantitiesList gasPhaseQuantitiesList;
        String string = (String)fDSInputRecord.getValue("QUANTITY");
        if (string != null && !(gasPhaseQuantitiesList = new GasPhaseQuantitiesList()).contains(string)) {
            return true;
        }
        return fDSInputRecord.getValue("DEPTH") != null || fDSInputRecord.getValue("DIAMETER") != null || fDSInputRecord.getValue("EMISSIVITY") != null || fDSInputRecord.getValue("K_HIGH") != null || fDSInputRecord.getValue("K_LOW") != null || fDSInputRecord.getValue("XB") != null || fDSInputRecord.getValue("IOR") != null;
    }
}

