/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TCData {
    private List<String> d_labels;
    private List<String> d_quantities;
    private List<String> d_units;
    private List<Double>[] d_values;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_GENERIC = 1;
    public static final int ERROR_OPENING = 2;
    public static final int ERROR_NTC = 3;
    public static final int ERROR_LABELS = 4;
    public static final int ERROR_QUANTITIES = 5;
    public static final int ERROR_UNITS = 6;
    public static final int ERROR_VALUES_BASE = 10;
    private int d_err;

    public TCData(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.d_err = 2;
            return;
        }
        try {
            this.parseNTC(bufferedReader);
        }
        catch (Exception exception) {
            this.d_err = 3;
            this.close(bufferedReader);
            return;
        }
        try {
            this.d_labels = this.parseLabels(bufferedReader);
        }
        catch (Exception exception) {
            this.d_labels = new ArrayList<String>();
        }
        try {
            this.d_quantities = this.parseQuantities(bufferedReader);
        }
        catch (Exception exception) {
            this.d_quantities = new ArrayList<String>();
        }
        try {
            this.d_units = this.parseUnits(bufferedReader);
        }
        catch (Exception exception) {
            this.d_units = new ArrayList<String>();
        }
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        int n = 0;
        try {
            while (bufferedReader.ready()) {
                arrayList.add(this.parseValues(bufferedReader));
                ++n;
            }
        }
        catch (Exception exception) {
            this.d_err = 10 + n;
        }
        this.close(bufferedReader);
        this.d_values = new List[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.d_values[i] = (List)arrayList.get(i);
        }
        if (this.d_labels.size() != this.d_quantities.size() || this.d_quantities.size() != this.d_units.size()) {
            this.d_err = 1;
        }
    }

    private void close(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getError() {
        return this.d_err;
    }

    public String errStr() {
        switch (this.getError()) {
            case 1: {
                return "file format error";
            }
            case 4: {
                return "error reading labels";
            }
            case 0: {
                return "no errors";
            }
            case 3: {
                return "error reading number of timesteps";
            }
            case 2: {
                return "error opening file";
            }
            case 5: {
                return "error reading quantities";
            }
            case 6: {
                return "error reading units";
            }
            case 10: {
                return "The input file contains no data";
            }
        }
        return "WARNING: list of values is incomplete (" + (this.getError() - 10 + 1) + ")";
    }

    public List<String> getLabels() {
        return this.d_labels;
    }

    public List<String> getQuantities() {
        return this.d_quantities;
    }

    public List<String> getUnits() {
        return this.d_units;
    }

    public List<Double> getValues(int n) {
        return this.d_values[n];
    }

    public int getNumValues() {
        return this.d_values.length;
    }

    private int parseNTC(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        assert (string != null);
        return Integer.parseInt(string.replaceAll(" ", ""));
    }

    private List<String> parseLabels(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        if (string != null) {
            string = string.replaceAll(" ", "");
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    private List<String> parseQuantities(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        if (string != null) {
            string = string.replaceAll(" ", "");
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    private List<String> parseUnits(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        if (string != null) {
            string = string.replaceAll(" ", "");
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    private List<Double> parseValues(BufferedReader bufferedReader) throws IOException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string = bufferedReader.readLine();
        if (string != null) {
            string = string.replaceAll(" ", "");
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new Double(stringArray[i]));
            }
        }
        return arrayList;
    }
}

