/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Warning;

class SurfProcessor
extends AFDSRecordProcessor {
    private Map<String, Collection<UnitlessRampRecord>> d_allRampRecords = new TreeMap<String, Collection<UnitlessRampRecord>>();
    private Map<String, MaterialRecPair> d_tempMats = new TreeMap<String, MaterialRecPair>();

    public SurfProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
        for (Material material : this.getContainer().getMaterials()) {
            if (Material.isPredefinedMaterial(material.getName())) continue;
            this.d_tempMats.put(material.getName(), new MaterialRecPair(material, null));
        }
    }

    @Override
    public String getFDSTypeParsed() {
        return "SURF";
    }

    private BufferedImage getTexImage(String string) throws IOException {
        FilenameFilter filenameFilter;
        File file = super.getParsingInfo().getContainer().getDBDir();
        File file2 = file.listFiles(filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.equals("textures");
            }
        })[0];
        File file3 = new File(file2, string);
        if (file3.exists()) {
            return ImageIO.read(file3);
        }
        String string2 = super.getParsingInfo().getCurrentParsingFile();
        File file4 = new File(string2 = string2.substring(0, string2.lastIndexOf(System.getProperty("file.separator"))));
        File file5 = new File(file4, string);
        if (file5.exists()) {
            BufferedImage bufferedImage = ImageIO.read(file5);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, null, 0, 0);
            graphics2D.dispose();
            return bufferedImage2;
        }
        return null;
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        FDSParsingInfo fDSParsingInfo = this.getParsingInfo();
        boolean bl = false;
        try {
            if ("SURF".equals(fDSInputRecord.getType())) {
                PartRecord partRecord;
                Material material;
                Object object2;
                String string;
                String string2 = (String)fDSInputRecord.getValue("ID");
                if (string2 == null || string2.equals("")) {
                    throw new FDSRecordFormatException(fDSInputRecord, "Every SURF must have an ID.");
                }
                if (Material.isPredefinedMaterial(string2)) {
                    return true;
                }
                Color color = this.parseColor(fDSInputRecord);
                if (color == null) {
                    color = fDSParsingInfo.getDefaultMaterial().getColor();
                }
                if ((string = (String)fDSInputRecord.getValue("TEXTURE_MAP")) != null) {
                    object2 = this.getContainer().getTextureDB();
                    DoubleValueRange object3 = DoubleValueRange.createCheckedMin(0.0, true);
                    double d = fDSInputRecord.extractDouble("TEXTURE_WIDTH", 1.0, object3);
                    double d2 = fDSInputRecord.extractDouble("TEXTURE_HEIGHT", 1.0, object3);
                    TextureInfo textureInfo = null;
                    if (((TextureDB)object2).names().contains(string)) {
                        textureInfo = new TextureInfo(((TextureDB)object2).getDefaultInfo(string));
                    } else if (fDSParsingInfo.getCurrentParsingFile() != null) {
                        try {
                            File file = new File(fDSParsingInfo.getCurrentParsingFile());
                            File file2 = new File(file.getParentFile(), string);
                            textureInfo = ((TextureDB)object2).addToDB(file2);
                            if (textureInfo != null) {
                                textureInfo = new TextureInfo(textureInfo);
                                String string3 = textureInfo.getTexID();
                                TextureInfo textureInfo2 = ((TextureDB)object2).getDefaultInfo(string3);
                                if (fDSInputRecord.getValue("TEXTURE_WIDTH") != null) {
                                    textureInfo2.setWidth(new UnitDouble(d, SI.METER));
                                }
                                if (fDSInputRecord.getValue("TEXTURE_HEIGHT") != null) {
                                    textureInfo2.setHeight(new UnitDouble(d2, SI.METER));
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            this.addWarning(fDSInputRecord, "Unable to create texture: " + string, "Texture Removed");
                            throwable.printStackTrace();
                            textureInfo = null;
                        }
                    }
                    if (textureInfo != null) {
                        if (fDSInputRecord.getValue("TEXTURE_WIDTH") != null) {
                            textureInfo.setWidth(new UnitDouble(d, SI.METER));
                        }
                        if (fDSInputRecord.getValue("TEXTURE_HEIGHT") != null) {
                            textureInfo.setHeight(new UnitDouble(d2, SI.METER));
                        }
                        material = new Material(string2, color, textureInfo);
                    } else {
                        material = new Material(string2, color);
                    }
                } else {
                    material = new Material(string2, color);
                }
                for (String string4 : Material.getValueNames()) {
                    Object object = fDSInputRecord.getValue(string4);
                    if (object == null) continue;
                    if (Material.getRampInfo(string4) != null) {
                        material.setValue(string4, object);
                        continue;
                    }
                    Material.ValueInfo<?, ?> valueInfo = Material.getValueInfo(string4);
                    if (!valueInfo.d_fdsParsingDataType.isInstance(object)) {
                        throw new ClassCastException();
                    }
                    object = valueInfo.convertFDSValueToPyroValue(object);
                    material.setValue(string4, object);
                }
                object2 = (String)material.getValue("PART_ID");
                if (object2 != null && (partRecord = this.getResource(object2, PartRecord.class)) == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "No particle with the id (PART_ID), \"" + (String)object2 + ",\" could be found in the model.");
                }
                if (material.getValue("PHASE") == null) {
                    material.setValue("PHASE", "SOLID");
                }
                this.d_tempMats.put(material.getName(), new MaterialRecPair(material, fDSInputRecord));
                return true;
            }
            if ("RAMP".equals(fDSInputRecord.getType())) {
                String string = (String)fDSInputRecord.getValue("ID");
                Double d = (Double)fDSInputRecord.getValue("T");
                Double d3 = (Double)fDSInputRecord.getValue("F");
                if (string == null || d == null || d3 == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "RAMP records must specify an ID, RAMP_T, and RAMP_F.");
                }
                UnitlessRampRecord unitlessRampRecord = new UnitlessRampRecord(d, d3);
                Collection<UnitlessRampRecord> collection = this.d_allRampRecords.get(string);
                if (collection == null) {
                    collection = new Vector<UnitlessRampRecord>();
                    this.d_allRampRecords.put(string, collection);
                }
                collection.add(unitlessRampRecord);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            if (this.getParsingInfo().getDebugLevel() == 0) {
                throw fDSRecordFormatException;
            }
            return false;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (this.getParsingInfo().getDebugLevel() == 0) {
                throw new FDSRecordFormatException(fDSInputRecord);
            }
            return false;
        }
        return true;
    }

    public Material makeMatValid(MaterialRecPair materialRecPair) {
        Collection<? extends Warning> collection = Material.validateMaterial(materialRecPair.d_mat);
        for (Warning warning : collection) {
            this.addWarning(materialRecPair.d_rec, warning.getWarning(), warning.getActionTaken());
        }
        return materialRecPair.d_mat;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (MaterialRecPair materialRecPair : this.d_tempMats.values()) {
            for (String string : Material.getRampTypes()) {
                String string2 = (String)materialRecPair.d_mat.getValue(string);
                if (string2 == null) continue;
                Collection<UnitlessRampRecord> collection = this.d_allRampRecords.get(string2);
                if (collection == null) {
                    if (this.getParsingInfo().getDebugLevel() == 0) {
                        if (materialRecPair.d_rec != null) {
                            throw new FDSRecordFormatException(materialRecPair.d_rec, "The RAMP, " + string2 + ", does not exist in the model.");
                        }
                        throw new FDSRecordFormatException("The RAMP, " + string2 + ", does not exist in the model.");
                    }
                    materialRecPair.d_mat.setValue(string, null);
                    continue;
                }
                Material.RampInfo rampInfo = Material.getRampInfo(string);
                Vector<RampRecord> vector = new Vector<RampRecord>(collection.size());
                for (UnitlessRampRecord unitlessRampRecord : collection) {
                    Unit unit = FdsSISystem.getInstance().getUnit(rampInfo.d_tUnit);
                    Unit unit2 = FdsSISystem.getInstance().getUnit(rampInfo.d_fUnit);
                    vector.add(new RampRecord(string2, new UnitDouble(unitlessRampRecord.d_k, unit), new UnitDouble(unitlessRampRecord.d_v, unit2), rampInfo.d_tUnit, rampInfo.d_fUnit));
                }
                Ramp ramp = new Ramp(string2, vector);
                materialRecPair.d_mat.setValue(string, ramp);
            }
            materialRecPair.d_mat.recalcProfilePath();
            materialRecPair.d_mat = this.makeMatValid(materialRecPair);
            Material material = this.getContainer().getMaterials().get(materialRecPair.d_mat.getName());
            if (material != null) {
                this.getContainer().getMaterials().taskRemove(material, materialRecPair.d_mat).run();
            } else {
                this.getContainer().getMaterials().taskAdd(materialRecPair.d_mat).run();
            }
            this.flagPyroTypeAffected(Material.class);
        }
    }

    private static class UnitlessRampRecord {
        private double d_k;
        private double d_v;

        public UnitlessRampRecord(double d, double d2) {
            this.d_k = d;
            this.d_v = d2;
        }
    }

    private static class MaterialRecPair {
        Material d_mat;
        FDSInputRecord d_rec;

        public MaterialRecPair(Material material, FDSInputRecord fDSInputRecord) {
            this.d_mat = material;
            this.d_rec = fDSInputRecord;
        }
    }
}

