/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public class SprkProcessor
extends AFDSRecordProcessor {
    private Hashtable d_allSprks = new Hashtable();

    public SprkProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "SPRK";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        FDSRecordFormatException fDSRecordFormatException;
        boolean bl;
        block19: {
            bl = false;
            fDSRecordFormatException = null;
            if (!fDSInputRecord.getType().equals("SPRK")) {
                return false;
            }
            try {
                String string = null;
                string = (String)fDSInputRecord.getValue("LABEL");
                String string2 = null;
                string2 = (String)fDSInputRecord.getValue("MAKE");
                String string3 = (String)fDSInputRecord.getValue("PART_ID");
                Vector vector = (Vector)fDSInputRecord.getValue("ORIENTATION");
                Double d = (Double)fDSInputRecord.getValue("ROTATION");
                Vector vector2 = (Vector)fDSInputRecord.getValue("XYZ");
                if (string2 != null && vector2 != null) {
                    ADomainObject aDomainObject;
                    Unit unit = FdsSISystem.getInstance().getAngleUnit();
                    Unit unit2 = FdsSISystem.getInstance().getLengthUnit();
                    if (string == null || string.equals("")) {
                        string = "Sprinkler";
                    } else if (this.getContainer().getSprkList().contains(string)) {
                        throw new FDSRecordFormatException(fDSInputRecord, "The sprinkler, \"" + string + ",\" already exists in the model.");
                    }
                    ADomainObject aDomainObject2 = new SprkRecord(string);
                    ((SprkRecord)aDomainObject2).setMake(string2);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (!string3.equals("")) {
                        aDomainObject = this.getResource(string3, PartRecord.class);
                        if (aDomainObject != null) {
                            ((SprkRecord)aDomainObject2).getSetParticleTask(string3).run();
                        } else {
                            throw new FDSRecordFormatException(fDSInputRecord, "The particle '" + string3 + "' specified in the SPRK record(s) does not exist in the file.");
                        }
                    }
                    if (vector != null) {
                        ((SprkRecord)aDomainObject2).setOrientation((Double)vector.elementAt(0), (Double)vector.elementAt(1), (Double)vector.elementAt(2));
                    }
                    if (d != null) {
                        ((SprkRecord)aDomainObject2).setRotation(d, unit);
                    }
                    ((SprkRecord)aDomainObject2).setXYZ((Double)vector2.elementAt(0), (Double)vector2.elementAt(1), (Double)vector2.elementAt(2), unit2);
                    aDomainObject = (SprkRecord)EventParser.getCorrectObject(this.d_allSprks, (Activatable)((Object)aDomainObject2));
                    boolean bl2 = aDomainObject != aDomainObject2;
                    aDomainObject2 = aDomainObject;
                    String[] stringArray = new String[]{"T_ACTIVATE"};
                    String[] stringArray2 = new String[]{"T_DEACTIVATE"};
                    EventParser.parseEvents(this, (Activatable)((Object)aDomainObject2), fDSInputRecord, stringArray, stringArray2, null, null, null);
                    if (!bl2) {
                        this.getContainer().getSprkList().taskAdd(aDomainObject2).run();
                        this.flagPyroTypeAffected(SprkRecord.class);
                        this.d_allSprks.put(((SprkRecord)aDomainObject2).getPropertyHashString(), aDomainObject2);
                    }
                    break block19;
                }
                throw new FDSRecordFormatException(fDSInputRecord, "Sprinkler records must contain a label, make, and xyz coordinates, at a minimum.");
            }
            catch (FDSRecordFormatException fDSRecordFormatException2) {
                fDSRecordFormatException2.printStackTrace();
                fDSRecordFormatException = fDSRecordFormatException2;
                bl = true;
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

