/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class SmodProcessor
extends AFDSRecordProcessor {
    public SmodProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        Unit unit;
        if (!fDSInputRecord.getType().equals("SMOD")) {
            return false;
        }
        SmodList smodList = this.getContainer().getSmokeDetectors();
        SmodRecord smodRecord = new SmodRecord(smodList);
        String string = (String)fDSInputRecord.getValue("LABEL");
        Vector vector = (Vector)fDSInputRecord.getValue("XYZ");
        Double d = (Double)fDSInputRecord.getValue("LENGTH");
        Double d2 = (Double)fDSInputRecord.getValue("ALPHA_C");
        Double d3 = (Double)fDSInputRecord.getValue("BETA_C");
        Double d4 = (Double)fDSInputRecord.getValue("ALPHA_E");
        Double d5 = (Double)fDSInputRecord.getValue("BETA_E");
        Double d6 = (Double)fDSInputRecord.getValue("ACTIVATION_OBSCURATION");
        if (string != null && !smodList.contains(string)) {
            smodRecord.setLabel(string);
        }
        if (vector != null) {
            try {
                unit = FdsSISystem.getInstance().getLengthUnit();
                double d7 = (Double)vector.get(0);
                double d8 = (Double)vector.get(1);
                double d9 = (Double)vector.get(2);
                UnitPoint3D unitPoint3D = new UnitPoint3D(d7, d8, d9, unit);
                smodRecord.setLocation(unitPoint3D);
            }
            catch (Exception exception) {
                throw new FDSRecordFormatException(fDSInputRecord);
            }
        }
        if (d != null) {
            unit = FdsSISystem.getInstance().getLengthUnit();
            UnitDouble unitDouble = new UnitDouble(d, unit);
            smodRecord.setHLength(unitDouble);
        }
        if (d2 != null) {
            unit = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble unitDouble = new UnitDouble(d2, unit);
            smodRecord.setCAlphaC(unitDouble);
        }
        if (d3 != null) {
            unit = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble unitDouble = new UnitDouble(d3, unit);
            smodRecord.setCBetaC(unitDouble);
        }
        if (d4 != null) {
            unit = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble unitDouble = new UnitDouble(d4, unit);
            smodRecord.setCAlphaE(unitDouble);
        }
        if (d5 != null) {
            unit = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble unitDouble = new UnitDouble(d5, unit);
            smodRecord.setCBetaE(unitDouble);
        }
        if (d6 != null) {
            unit = FdsSISystem.getInstance().getObscurationUnit();
            UnitDouble unitDouble = new UnitDouble(d6, unit);
            smodRecord.setObscuration(unitDouble);
        }
        if (d2 != null && d3 != null && d4 != null && d5 != null) {
            smodRecord.setType(1);
        } else {
            smodRecord.setType(0);
        }
        smodList.taskAdd(smodRecord).run();
        this.flagPyroTypeAffected(SmodRecord.class);
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    @Override
    public String getFDSTypeParsed() {
        return "SMOD";
    }
}

