/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class SlcfProcessor
extends AFDSRecordProcessor {
    public SlcfProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "SLCF";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        try {
            if (fDSInputRecord.getType() == null) {
                throw new Exception();
            }
            if (!"SLCF".equals(fDSInputRecord.getType())) {
                return false;
            }
            if (this.containsUnsupportedRecords(fDSInputRecord)) {
                return false;
            }
            String string = "";
            String[] stringArray = fDSInputRecord.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].startsWith("PB")) continue;
                string = stringArray[i];
                break;
            }
            if (string.equals("")) {
                throw new FDSRecordFormatException(fDSInputRecord, "Currently, geometry must be specified with a PBX, PBY, or PBZ field in SLCF records.");
            }
            boolean bl2 = false;
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            UnitDouble unitDouble = fDSInputRecord.extractDouble("DTSAM", fdsSISystem.getTimeUnit(), null, (UnitDoubleValueRange)SlcfRecord.getValueRange("DTSAM"));
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("VECTOR") || !((Boolean)fDSInputRecord.getValue("VECTOR")).booleanValue()) continue;
                bl2 = true;
            }
            double d = (Double)fDSInputRecord.getValue(string);
            String string2 = (String)fDSInputRecord.getValue("QUANTITY");
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            if (string2 == null) {
                throw new FDSRecordFormatException(fDSInputRecord, "QUANTITY must be specified.");
            }
            SlcfRecord slcfRecord = new SlcfRecord(string, new UnitDouble(d, unit), string2, bl2, unitDouble);
            this.getContainer().getSlcfList().taskAdd(slcfRecord).run();
            this.flagPyroTypeAffected(SlcfRecord.class);
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            bl = true;
            fDSRecordFormatException = fDSRecordFormatException2;
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private boolean containsUnsupportedRecords(FDSInputRecord fDSInputRecord) {
        GasPhaseQuantitiesList gasPhaseQuantitiesList;
        if (fDSInputRecord.getValue("CB") != null || fDSInputRecord.getValue("K_HIGH") != null || fDSInputRecord.getValue("K_LOW") != null || fDSInputRecord.getValue("MESH_NUMBER") != null || fDSInputRecord.getValue("WRITE_XYZ") != null || fDSInputRecord.getValue("XB") != null) {
            return true;
        }
        String string = (String)fDSInputRecord.getValue("QUANTITY");
        return string != null && !(gasPhaseQuantitiesList = new GasPhaseQuantitiesList()).contains(string);
    }
}

