/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class ReacProcessor
extends AFDSRecordProcessor {
    public static Reaction last = null;

    public ReacProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "REAC";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        PyroMod pyroMod = this.getContainer();
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        if (!"REAC".equals(fDSInputRecord.getType())) {
            return false;
        }
        try {
            Object object;
            String string = (String)fDSInputRecord.getValue("ID");
            Reaction reaction = new Reaction(string);
            String[] stringArray = Reaction.getOptionalKeys();
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            for (int i = 0; i < stringArray.length; ++i) {
                object = fDSInputRecord.getValue(stringArray[i]);
                if (object == null) continue;
                Reaction.ValueInfo valueInfo = Reaction.getValueInfo(stringArray[i]);
                if (!valueInfo.d_fdsParsingDataType.isInstance(object)) {
                    throw new FDSRecordFormatException(fDSInputRecord, stringArray[i] + " is of the wrong data type.");
                }
                if (object instanceof Double) {
                    Unit unit = fdsSISystem.getUnit(valueInfo.d_unitType);
                    if (!valueInfo.d_valueRange.checkValue((UnitDouble)(object = new UnitDouble((Double)object, unit)))) {
                        throw new FDSRecordFormatException(fDSInputRecord, stringArray[i] + " must be " + valueInfo.d_valueRange.describeRange() + ".");
                    }
                }
                reaction.setValue(stringArray[i], object);
            }
            ReactionList reactionList = pyroMod.getReactions();
            object = reactionList.get(string);
            if (object != null) {
                reactionList.taskRemove(object, reaction);
            } else {
                reactionList.taskAdd(reaction).run();
            }
            this.flagPyroTypeAffected(Reaction.class);
            last = reaction;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

