/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.HashSet;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RadiProcessor
extends AFDSRecordProcessor {
    private static final Set FIELDS = new HashSet(15);

    public RadiProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        if (!fDSInputRecord.getType().equalsIgnoreCase("RADI")) {
            return false;
        }
        boolean bl = false;
        try {
            RadiRecord radiRecord = this.getContainer().getRadiManager().get((RadiRecord)null);
            this.readInt(radiRecord, fDSInputRecord, "ANGLE_INCREMENT");
            this.readInt(radiRecord, fDSInputRecord, "NMIEANG");
            this.readInt(radiRecord, fDSInputRecord, "NUMBER_RADIATION_ANGLES");
            this.readInt(radiRecord, fDSInputRecord, "TIME_STEP_INCREMENT");
            this.readBool(radiRecord, fDSInputRecord, "CH4_BANDS");
            this.readBool(radiRecord, fDSInputRecord, "WIDE_BAND_MODEL");
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            this.readNumber(radiRecord, fDSInputRecord, "KAPPA0", fdsSISystem.getKappa0Unit());
            this.readNumber(radiRecord, fDSInputRecord, "PATH", fdsSISystem.getLengthUnit());
            this.readNumber(radiRecord, fDSInputRecord, "RADTMP", fdsSISystem.getTempUnit());
            this.flagPyroTypeAffected(RadiRecord.class);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            bl = true;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            bl = true;
        }
        return !bl;
    }

    private RadiRecord readInt(RadiRecord radiRecord, FDSInputRecord fDSInputRecord, String string) {
        Object object = fDSInputRecord.getValue(string);
        if (object != null) {
            radiRecord.set(string, (int)Double.parseDouble(object.toString()));
        }
        return radiRecord;
    }

    private RadiRecord readBool(RadiRecord radiRecord, FDSInputRecord fDSInputRecord, String string) {
        Object object = fDSInputRecord.getValue(string);
        if (object != null) {
            radiRecord.set(string, Boolean.parseBoolean(object.toString()));
        }
        return radiRecord;
    }

    private RadiRecord readNumber(RadiRecord radiRecord, FDSInputRecord fDSInputRecord, String string, Unit unit) {
        Object object = fDSInputRecord.getValue(string);
        if (object != null) {
            double d = Double.parseDouble(object.toString());
            radiRecord.set(string, new UnitDouble(d, unit));
        }
        return radiRecord;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    @Override
    public String getFDSTypeParsed() {
        return "RADI";
    }

    static {
        FIELDS.add("ANGLE_INCREMENT");
        FIELDS.add("CH4_BANDS");
        FIELDS.add("KAPPA0");
        FIELDS.add("NMIEANG");
        FIELDS.add("NUMBER_RADIATION_ANGLES");
        FIELDS.add("PATH");
        FIELDS.add("RADTMP");
        FIELDS.add("TIME_STEP_INCREMENT");
        FIELDS.add("WIDE_BAND_MODEL");
    }
}

