/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.PipeManager;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class PipeProcessor
extends AFDSRecordProcessor {
    private Unit d_timeUnit = FdsSISystem.getInstance().getTimeUnit();
    private Unit d_barUnit = FdsSISystem.getInstance().getPipePressureUnit();

    public PipeProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PIPE";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        if (!fDSInputRecord.getType().equals("PIPE")) {
            return false;
        }
        try {
            Object object = fDSInputRecord.getValue("DELAY");
            Object object2 = fDSInputRecord.getValue("PRESSURE");
            if (object == null && object2 == null) {
                throw new FDSRecordFormatException("You must enter DELAY and/or PRESSURE for the PIPE record.");
            }
            UnitDouble unitDouble = fDSInputRecord.extractDouble("DELAY", this.d_timeUnit, new UnitDouble(0.0, this.d_timeUnit), (UnitDoubleValueRange)PipeRecord.getValueRange("DELAY"));
            UnitDouble unitDouble2 = fDSInputRecord.extractDouble("PRESSURE", this.d_barUnit, null, (UnitDoubleValueRange)PipeRecord.getValueRange("PRESSURE"));
            PipeRecord pipeRecord = new PipeRecord(unitDouble, unitDouble2);
            PipeManager pipeManager = this.getContainer().getPipeManager();
            pipeManager.taskRemove(pipeManager.getPipeRecord(), pipeRecord).run();
            this.flagPyroTypeAffected(PipeRecord.class);
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

