/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class PartProcessor
extends AFDSRecordProcessor {
    private UnitSystem d_unitSystem = FdsSISystem.getInstance();
    private Unit d_densityUnit = this.d_unitSystem.getDensityUnit();
    private Unit d_tempUnit = this.d_unitSystem.getTempUnit();
    private Unit d_specHeatUnit = this.d_unitSystem.getSpecHeatUnit();
    private Unit d_specEnergyUnit = this.d_unitSystem.getSpecEnergyUnit();
    private Unit d_diameterUnit = this.d_unitSystem.getDiameterUnit();
    private Unit d_timeUnit = this.d_unitSystem.getTimeUnit();

    public PartProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PART";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        try {
            if (fDSInputRecord.getType() == null) {
                throw new Exception();
            }
            if (!"PART".equals(fDSInputRecord.getType())) {
                return false;
            }
            String string = (String)fDSInputRecord.getValue("ID");
            if (string == null || string.equals("")) {
                string = "Particle";
            } else if (this.getContainer().getPartList().contains(string)) {
                throw new FDSRecordFormatException(fDSInputRecord, "Several particles in the model have the same id, \"" + string + ".\" Each particle in a model must have a unique id.");
            }
            PartRecord partRecord = new PartRecord(string);
            String[] stringArray = fDSInputRecord.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("DENSITY")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("DENSITY", this.d_densityUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("DENSITY"));
                    partRecord.setDensity(unitDouble.getValue(this.d_densityUnit), this.d_densityUnit);
                    continue;
                }
                if (stringArray[i].equals("VAPORIZATION_TEMPERATURE")) {
                    double d = (Double)fDSInputRecord.getValue("VAPORIZATION_TEMPERATURE");
                    partRecord.setVapTemp(d, this.d_tempUnit);
                    continue;
                }
                if (stringArray[i].equals("MELTING_TEMPERATURE")) {
                    double d = (Double)fDSInputRecord.getValue("MELTING_TEMPERATURE");
                    partRecord.setMeltTemp(d, this.d_tempUnit);
                    continue;
                }
                if (stringArray[i].equals("SPECIFIC_HEAT")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("SPECIFIC_HEAT", this.d_specHeatUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("SPECIFIC_HEAT"));
                    partRecord.setSpecificHeat(unitDouble.getValue(this.d_specHeatUnit), this.d_specHeatUnit);
                    continue;
                }
                if (stringArray[i].equals("HEAT_OF_VAPORIZATION")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("HEAT_OF_VAPORIZATION", this.d_specEnergyUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("HEAT_OF_VAPORIZATION"));
                    partRecord.setHeatVap(unitDouble.getValue(this.d_specEnergyUnit), this.d_specEnergyUnit);
                    continue;
                }
                if (stringArray[i].equals("DIAMETER")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("DIAMETER", this.d_diameterUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("DIAMETER"));
                    partRecord.setDiameter(unitDouble.getValue(this.d_diameterUnit), this.d_diameterUnit);
                    continue;
                }
                if (stringArray[i].equals("GAMMA_D")) {
                    double d = (Double)fDSInputRecord.getValue("GAMMA_D");
                    partRecord.setGamma(d);
                    continue;
                }
                if (stringArray[i].equals("MASSLESS")) {
                    boolean bl2 = (Boolean)fDSInputRecord.getValue("MASSLESS");
                    partRecord.setMassless(bl2);
                    continue;
                }
                if (stringArray[i].equals("STATIC")) {
                    boolean bl3 = (Boolean)fDSInputRecord.getValue("STATIC");
                    partRecord.setStatic(bl3);
                    continue;
                }
                if (stringArray[i].equals("FUEL")) {
                    boolean bl4 = (Boolean)fDSInputRecord.getValue("FUEL");
                    partRecord.setFuel(bl4);
                    continue;
                }
                if (stringArray[i].equals("HEAT_OF_COMBUSTION")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("HEAT_OF_COMBUSTION", this.d_specEnergyUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("HEAT_OF_COMBUSTION"));
                    partRecord.setHeatCombust(unitDouble.getValue(this.d_specEnergyUnit), this.d_specEnergyUnit);
                    continue;
                }
                if (stringArray[i].equals("WATER")) {
                    boolean bl5 = (Boolean)fDSInputRecord.getValue("WATER");
                    partRecord.setWater(bl5);
                    continue;
                }
                if (stringArray[i].equals("SAMPLING_FACTOR")) {
                    int n = ((Double)fDSInputRecord.getValue("SAMPLING_FACTOR")).intValue();
                    partRecord.setSample(n);
                    continue;
                }
                if (stringArray[i].equals("QUANTITY")) {
                    String string2 = (String)fDSInputRecord.getValue("QUANTITY");
                    if (!string2.equals("none")) {
                        partRecord.setQuantity(string2);
                        continue;
                    }
                    partRecord.setQuantity("none");
                    continue;
                }
                if (stringArray[i].equals("NUMBER_INITIAL_DROPLETS")) {
                    int n = fDSInputRecord.extractInt("NUMBER_INITIAL_DROPLETS", 0, (IntValueRange)PartRecord.getValueRange("NUMBER_INITIAL_DROPLETS"));
                    partRecord.setInitDrop(n);
                    continue;
                }
                if (stringArray[i].equals("MASS_PER_VOLUME")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("MASS_PER_VOLUME", this.d_densityUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("MASS_PER_VOLUME"));
                    partRecord.setMassVol(unitDouble.getValue(this.d_densityUnit), this.d_densityUnit);
                    continue;
                }
                if (stringArray[i].equals("DROPLETS_PER_SECOND")) {
                    int n = fDSInputRecord.extractInt("DROPLETS_PER_SECOND", 0, (IntValueRange)PartRecord.getValueRange("DROPLETS_PER_SECOND"));
                    partRecord.setDropSec(n);
                    continue;
                }
                if (stringArray[i].equals("AGE")) {
                    UnitDouble unitDouble = fDSInputRecord.extractDouble("AGE", this.d_timeUnit, null, (UnitDoubleValueRange)PartRecord.getValueRange("AGE"));
                    partRecord.setAge(unitDouble.getValue(this.d_timeUnit), this.d_timeUnit);
                    continue;
                }
                if (!stringArray[i].equals("INITIAL_TEMPERATURE")) continue;
                Double d = (Double)fDSInputRecord.getValue("INITIAL_TEMPERATURE");
                if (d != null) {
                    partRecord.setInitTemp(d, this.d_tempUnit);
                    partRecord.setInitTempFDS(false);
                    continue;
                }
                partRecord.setInitTempFDS(true);
            }
            this.getContainer().getPartList().taskAdd(partRecord).run();
            this.flagPyroTypeAffected(PartRecord.class);
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            bl = true;
            fDSRecordFormatException = fDSRecordFormatException2;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

