/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.PL3DManager;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class PL3DProcessor
extends AFDSRecordProcessor {
    public PL3DProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PL3D";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        if (!"PL3D".equals(fDSInputRecord.getType())) {
            return false;
        }
        try {
            Object object;
            String string;
            int n;
            int n2;
            Vector<Object> vector;
            GasPhaseQuantitiesList gasPhaseQuantitiesList = new GasPhaseQuantitiesList();
            Object object2 = fDSInputRecord.getValue("QUANTITIES");
            if (object2 != null) {
                if (object2 instanceof Vector) {
                    vector = (Vector<Object>)object2;
                } else {
                    if (!(object2 instanceof String)) throw new FDSRecordFormatException(fDSInputRecord, "QUANTITIES must be a list containing only Strings.");
                    vector = new Vector<Object>();
                    vector.add(object2);
                }
            } else {
                vector = new Vector<Object>();
            }
            String[] stringArray = new String[5];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray[n2] = null;
            }
            for (n2 = 1; n2 <= 5; ++n2) {
                String string2 = (String)fDSInputRecord.getValue("QUANTITIES(" + n2 + ")");
                if (string2 == null) continue;
                if (!gasPhaseQuantitiesList.contains(string2)) throw new FDSRecordFormatException(fDSInputRecord, string2 + " is not a valid Gas Phase Quantity.");
                stringArray[n2 - 1] = string2;
            }
            assert (vector != null);
            String[] stringArray2 = new String[5];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n] = null;
            }
            for (n = 0; n < vector.size(); ++n) {
                string = (String)vector.get(n);
                if (!gasPhaseQuantitiesList.contains(string)) {
                    throw new FDSRecordFormatException(fDSInputRecord, string + " is not a valid Gas Phase Quantity.");
                }
                stringArray2[n] = string;
            }
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                if (string == null) continue;
                stringArray2[n] = string;
            }
            n = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                if (string3 == null) continue;
                ++n;
            }
            PL3DRecord pL3DRecord = new PL3DRecord(null);
            pL3DRecord.setEnabled(true);
            if (n > 0) {
                pL3DRecord.clearQuantities();
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = stringArray2[i];
                    if (object == null) continue;
                    pL3DRecord.addQuantity((String)object);
                }
            }
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            object = fDSInputRecord.extractDouble("DTSAM", fdsSISystem.getTimeUnit(), null, (UnitDoubleValueRange)PL3DRecord.getValueRange("DTSAM"));
            pL3DRecord.setDTSam((UnitDouble)object);
            Boolean bl2 = (Boolean)fDSInputRecord.getValue("WRITE_XYZ");
            if (bl2 != null) {
                pL3DRecord.setWriteXYZ(bl2);
            }
            PL3DManager pL3DManager = this.getContainer().getPL3DManager();
            pL3DManager.taskRemove(pL3DManager.getPL3DRecord(), pL3DRecord).run();
            this.flagPyroTypeAffected(PL3DRecord.class);
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) return true;
        if (fDSRecordFormatException == null) throw new FDSRecordFormatException(fDSInputRecord);
        throw fDSRecordFormatException;
    }

    @Override
    public void done() {
    }
}

