/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.FDSColors;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;

class ObstProcessor
extends AFDSRecordProcessor {
    private Map d_allObstructions = new TreeMap();
    private Hashtable d_compositesMap = new Hashtable();
    private int d_nextObstNum = 1;

    public ObstProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    private Material getMaterialSafe(FDSInputRecord fDSInputRecord, String string) throws FDSRecordFormatException {
        if (string == null) {
            return this.getParsingInfo().getDefaultMaterial();
        }
        Material material = this.getResource(string, Material.class);
        if (material == null) {
            throw new FDSRecordFormatException(fDSInputRecord, "The SURF, " + string + ", does not exist in the model.");
        }
        return material;
    }

    @Override
    public String getFDSTypeParsed() {
        return "OBST";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        if (!"OBST".equals(fDSInputRecord.getType())) {
            return false;
        }
        Vector vector = null;
        try {
            AlignedBlock alignedBlock;
            Serializable serializable;
            Serializable serializable2;
            Object object;
            Serializable serializable3;
            vector = (Vector)fDSInputRecord.getValue("XB");
            Point3d point3d = new Point3d((Double)vector.get(0), (Double)vector.get(2), (Double)vector.get(4));
            Point3d point3d2 = new Point3d((Double)vector.get(1), (Double)vector.get(3), (Double)vector.get(5));
            if (Rectifier.rectify(point3d, point3d2)) {
                // empty if block
            }
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            UnitPoint3D unitPoint3D = new UnitPoint3D(point3d, unit);
            UnitPoint3D unitPoint3D2 = new UnitPoint3D(point3d2, unit);
            String string = fDSInputRecord.getComment();
            if (string == null || string.equals("")) {
                string = new String("Obstruction #" + this.d_nextObstNum++);
            }
            AlignedBlock alignedBlock2 = new AlignedBlock(unitPoint3D, unitPoint3D2, string, this.getParsingInfo().getDefaultMaterial());
            Object object2 = fDSInputRecord.getValue("SURF_ID");
            if (object2 != null) {
                alignedBlock2.setMaterial(this.getMaterialSafe(fDSInputRecord, object2.toString()));
            } else {
                object2 = fDSInputRecord.getValue("SURF_IDS");
                if (object2 != null) {
                    serializable3 = (Vector)object2;
                    object = this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(0).toString());
                    serializable2 = this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(1).toString());
                    serializable = this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(2).toString());
                    alignedBlock2.setMaterial(5, (Material)object);
                    alignedBlock2.setMaterial(0, (Material)serializable2);
                    alignedBlock2.setMaterial(1, (Material)serializable2);
                    alignedBlock2.setMaterial(2, (Material)serializable2);
                    alignedBlock2.setMaterial(3, (Material)serializable2);
                    alignedBlock2.setMaterial(4, (Material)serializable);
                } else {
                    object2 = fDSInputRecord.getValue("SURF_ID6");
                    if (object2 != null) {
                        serializable3 = (Vector)object2;
                        alignedBlock2.setMaterial(0, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(0).toString()));
                        alignedBlock2.setMaterial(1, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(1).toString()));
                        alignedBlock2.setMaterial(2, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(2).toString()));
                        alignedBlock2.setMaterial(3, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(3).toString()));
                        alignedBlock2.setMaterial(4, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(4).toString()));
                        alignedBlock2.setMaterial(5, this.getMaterialSafe(fDSInputRecord, ((Vector)serializable3).elementAt(5).toString()));
                    } else {
                        alignedBlock2.setMaterial(this.getParsingInfo().getDefaultMaterial());
                    }
                }
            }
            serializable3 = this.parseColor(fDSInputRecord);
            if (serializable3 != null) {
                alignedBlock2.setColor((Color)serializable3);
            } else {
                object = (String)fDSInputRecord.getValue("COLOR");
                if (object != null) {
                    if (((String)object).equalsIgnoreCase("INVISIBLE")) {
                        alignedBlock2.setVisible(false);
                    }
                    alignedBlock2.setColor(FDSColors.getColor((String)object));
                }
            }
            object = (Boolean)fDSInputRecord.getValue("THICKEN");
            if (object != null) {
                alignedBlock2.setIsThickened((Boolean)object);
            }
            if ((serializable2 = (Boolean)fDSInputRecord.getValue("PERMIT_HOLE")) != null) {
                alignedBlock2.setPermitsHole((Boolean)serializable2);
            }
            if ((serializable = (Boolean)fDSInputRecord.getValue("SAWTOOTH")) != null) {
                alignedBlock2.setIsSawtoothed((Boolean)serializable);
            }
            boolean bl2 = (alignedBlock = (AlignedBlock)EventParser.getCorrectObject(this.d_allObstructions, alignedBlock2)) != alignedBlock2;
            alignedBlock2 = alignedBlock;
            String[] stringArray = new String[]{"T_CREATE"};
            String[] stringArray2 = new String[]{"T_REMOVE"};
            String string2 = "HEAT_CREATE";
            String string3 = "HEAT_REMOVE";
            EventParser.parseEvents(this, alignedBlock2, fDSInputRecord, stringArray, stringArray2, string2, string3, this.getContainer().getHeatDetectors());
            if (!bl2) {
                FDSObject fDSObject = (FDSObject)this.d_compositesMap.get(alignedBlock2.getName());
                if (fDSObject != null && fDSObject.getName().equals(alignedBlock2.getName())) {
                    if (fDSObject instanceof FDSComposite) {
                        ((FDSComposite)fDSObject).taskAdd(alignedBlock2).run();
                    } else {
                        int n;
                        for (n = 0; n < this.getContainer().getObstructions().size() && this.getContainer().getObstructions().get(n) != fDSObject; ++n) {
                        }
                        this.getContainer().getObstructions().taskRemove(n).run();
                        FDSComposite fDSComposite = new FDSComposite();
                        fDSComposite.taskSetName(fDSObject.getName()).run();
                        fDSComposite.taskAdd(fDSObject).run();
                        fDSComposite.taskAdd(alignedBlock2).run();
                        this.getContainer().getObstructions().taskAdd(fDSComposite, n).run();
                        this.d_compositesMap.put(fDSObject.getName(), fDSComposite);
                    }
                } else {
                    this.getContainer().getObstructions().taskAdd(alignedBlock2).run();
                    this.flagPyroTypeAffected(AlignedBlock.class);
                    if (!alignedBlock2.getName().equals("")) {
                        this.d_compositesMap.put(alignedBlock2.getName(), alignedBlock2);
                    }
                }
                this.d_allObstructions.put(alignedBlock2.getPropertyHashString(), alignedBlock2);
            }
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        if (bl) {
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

