/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class MiscProcessor
extends AFDSRecordProcessor {
    private static final HashSet<String> d_supportedFields;

    public MiscProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "MISC";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        if (!"MISC".equals(fDSInputRecord.getType())) {
            return false;
        }
        FDSRecordFormatException fDSRecordFormatException = null;
        boolean bl = false;
        try {
            Comparable comparable;
            Serializable serializable;
            Object object;
            PyroMod.MiscRecord miscRecord = this.getContainer().getMiscManager().getMiscRecord();
            String string = (String)fDSInputRecord.getValue("REACTION");
            if (string != null) {
                object = this.getResource(string, Reaction.class);
                if (object == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "The specified reaction, \"" + string + ",\" does not exist.");
                }
                miscRecord.taskSetReaction(string).run();
            }
            if ((object = (String)fDSInputRecord.getValue("SURF_DEFAULT")) != null) {
                serializable = this.getResource(object, Material.class);
                if (serializable == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "The specified default surface, \"" + (String)object + ",\" does not exist.");
                }
                this.getParsingInfo().setDefaultMaterial((Material)serializable);
            }
            serializable = FdsSISystem.getInstance().getTimeUnit();
            Unit unit = FdsSISystem.getInstance().getAtmGradUnit();
            Unit unit2 = FdsSISystem.getInstance().getTempUnit();
            Unit unit3 = FdsSISystem.getInstance().getAmbientPressureUnit();
            Unit unit4 = FdsSISystem.getInstance().getVelocityUnit();
            Unit unit5 = FdsSISystem.getInstance().getAccelUnit();
            miscRecord.setRestart(fDSInputRecord.extractBoolean("RESTART", miscRecord.getRestart()));
            miscRecord.setDtcore(fDSInputRecord.extractDouble("DTCORE", (Unit)serializable, miscRecord.getDtcore(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTCORE")));
            miscRecord.setAutoMFAdjust(fDSInputRecord.extractBoolean("AUTOMATIC_Z", miscRecord.getAutoMFAdjust()));
            miscRecord.setGPFSuppress(fDSInputRecord.extractBoolean("SUPPRESSION", miscRecord.getGPFSuppress()));
            miscRecord.setAtmTempLapse(fDSInputRecord.extractDouble("DT0DZ", unit, miscRecord.getAtmTempLapse(), null));
            miscRecord.setAmbientTemp(fDSInputRecord.extractDouble("TMPA", unit2, miscRecord.getAmbientTemp(), null));
            miscRecord.setAmbientPressure(fDSInputRecord.extractDouble("PINF", unit3, miscRecord.getAmbientPressure(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("PINF")));
            miscRecord.setOutsideTemp(fDSInputRecord.extractDouble("TMPO", unit2, miscRecord.getOutsideTemp(), null));
            if (fDSInputRecord.getValue("U0") != null || fDSInputRecord.getValue("V0") != null || fDSInputRecord.getValue("W0") != null) {
                UnitDouble unitDouble = fDSInputRecord.extractDouble("U0", unit4, miscRecord.getInitVel() != null ? miscRecord.getInitVel().xu() : FDSInputRecord.DEF_INIT_VEL.xu(), null);
                UnitDouble unitDouble2 = fDSInputRecord.extractDouble("V0", unit4, miscRecord.getInitVel() != null ? miscRecord.getInitVel().yu() : FDSInputRecord.DEF_INIT_VEL.yu(), null);
                comparable = fDSInputRecord.extractDouble("W0", unit4, miscRecord.getInitVel() != null ? miscRecord.getInitVel().zu() : FDSInputRecord.DEF_INIT_VEL.zu(), null);
                miscRecord.setInitVel(new UnitPoint3D(unitDouble.getValue(unit4), unitDouble2.getValue(unit4), comparable.getValue(unit4), unit4));
            }
            miscRecord.setNumFrames(fDSInputRecord.extractInt("NFRAMES", miscRecord.getNumFrames(), (IntValueRange)PyroMod.MiscRecord.getValueRange("NFRAMES")));
            miscRecord.setCharVel(fDSInputRecord.extractDouble("CHARACTERISTIC_VELOCITY", unit4, miscRecord.getCharVel(), null));
            miscRecord.setGaugeTemp(fDSInputRecord.extractDouble("GAUGE_TEMPERATURE", unit2, miscRecord.getGaugeTemp(), null));
            miscRecord.setPorousFloor(fDSInputRecord.extractBoolean("POROUS_FLOOR", miscRecord.getPorousFloor()));
            miscRecord.setSprkDtspar(fDSInputRecord.extractDouble("DTSPAR", (Unit)serializable, miscRecord.getSprkDtspar(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTSPAR")));
            miscRecord.setPartDtsam(fDSInputRecord.extractDouble("DTSAM_PART", (Unit)serializable, miscRecord.getPartDtsam(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTSAM_PART")));
            miscRecord.setPartDtpar(fDSInputRecord.extractDouble("DTPAR", (Unit)serializable, miscRecord.getPartDtpar(), (UnitDoubleValueRange)PyroMod.MiscRecord.getValueRange("DTPAR")));
            if (fDSInputRecord.getValue("NPPS") != null) {
                int n = fDSInputRecord.extractInt("NPPS", -1, (IntValueRange)PyroMod.MiscRecord.getValueRange("NPPS"));
                miscRecord.setPartNpps(new UnitDouble(n, (Unit)serializable));
            }
            miscRecord.setPartMaxDrop(fDSInputRecord.extractInt("MAXIMUM_DROPLETS", miscRecord.getPartMaxDrop(), (IntValueRange)PyroMod.MiscRecord.getValueRange("MAXIMUM_DROPLETS")));
            miscRecord.setSmag(fDSInputRecord.extractDouble("CSMAG", miscRecord.getSmag(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("CSMAG")));
            miscRecord.setSchmidt(fDSInputRecord.extractDouble("SC", miscRecord.getSchmidt(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("SC")));
            miscRecord.setPrandtl(fDSInputRecord.extractDouble("PR", miscRecord.getPrandtl(), (DoubleValueRange)PyroMod.MiscRecord.getValueRange("PR")));
            miscRecord.setIsothermal(fDSInputRecord.extractBoolean("ISOTHERMAL", miscRecord.getIsothermal()));
            boolean bl2 = miscRecord.getRadSolverOff();
            if (!miscRecord.getIsothermal()) {
                bl2 = !fDSInputRecord.extractBoolean("RADIATION", !miscRecord.getRadSolverOff());
            }
            miscRecord.setRadSolverOff(bl2);
            miscRecord.setIncompressible(fDSInputRecord.extractBoolean("INCOMPRESSIBLE", miscRecord.getIncompressible()));
            miscRecord.setSmokeOff(!fDSInputRecord.extractBoolean("SMOKE3D", !miscRecord.getSmokeOff()));
            int n = miscRecord.getSimulationType();
            comparable = (Boolean)fDSInputRecord.getValue("DNS");
            if (comparable != null) {
                n = 1;
            }
            miscRecord.setSimulationType(n);
            int n2 = miscRecord.getBaroclinic();
            comparable = (Boolean)fDSInputRecord.getValue("BAROCLINIC");
            if (comparable != null && comparable == Boolean.TRUE) {
                n2 = 1;
            }
            miscRecord.setBaroclinic(n2);
            Vector vector = (Vector)fDSInputRecord.getValue("GVEC");
            if (vector != null) {
                miscRecord.setGvec(new UnitPoint3D((Double)vector.elementAt(0), (Double)vector.elementAt(1), (Double)vector.elementAt(2), unit5));
            }
            this.flagPyroTypeAffected(PyroMod.MiscRecord.class);
            boolean bl3 = false;
            String[] stringArray = fDSInputRecord.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                if (d_supportedFields.contains(stringArray[i])) {
                    fDSInputRecord.removeValue(stringArray[i]);
                    continue;
                }
                bl3 = true;
            }
            return !bl3;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            bl = true;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException2.printStackTrace();
            bl = true;
            fDSRecordFormatException = fDSRecordFormatException2;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    static {
        String[] stringArray = new String[]{"DATABASE", "DATABASE_DIRECTORY", "RESTART", "DTCORE", "REACTION", "AUTOMATIC_Z", "SUPPRESSION", "DT0DZ", "TMPA", "PINF", "TMPO", "U0", "V0", "W0", "NFRAMES", "CHARACTERISTIC_VELOCITY", "GAUGE_TEMPERATURE", "POROUS_FLOOR", "DTSPAR", "DTSAM_PART", "DTPAR", "NPPS", "MAXIMUM_DROPLETS", "DNS", "ISOTHERMAL", "INCOMPRESSIBLE", "RADIATION", "CSMAG", "SC", "PR", "SMOKE3D", "BAROCLINIC", "GVEC", "SURF_DEFAULT", "RENDER_FILE"};
        d_supportedFields = new HashSet<String>(new VectorFromArray<String>(stringArray));
    }
}

