/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class IsofProcessor
extends AFDSRecordProcessor {
    public IsofProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "ISOF";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        try {
            Unit unit;
            if (fDSInputRecord.getType() == null) {
                throw new Exception();
            }
            if (!"ISOF".equals(fDSInputRecord.getType())) {
                return false;
            }
            String string = (String)fDSInputRecord.getValue("QUANTITY");
            UnitDouble unitDouble = null;
            Vector<UnitDouble> vector = new Vector<UnitDouble>();
            if (string.equals("TEMPERATURE")) {
                unit = FdsSISystem.getInstance().getTempUnit();
            } else if (string.equals("HRRPUV")) {
                unit = FdsSISystem.getInstance().getHRRPUVUnit();
            } else if (string.equals("DENSITY")) {
                unit = FdsSISystem.getInstance().getDensityUnit();
            } else if (string.equals("MIXTURE_FRACTION")) {
                unit = FdsSISystem.getInstance().getMixFracUnit();
            } else {
                throw new FDSRecordFormatException(fDSInputRecord, "Only the following gas phase quantities are allowed for ISOF records in FDS:\nDENSITY\nTEMPERATURE\nHRRPUV\nMIXTURE_FRACTION");
            }
            Vector<String> vector2 = new Vector<String>();
            String[] stringArray = fDSInputRecord.getKeys();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].startsWith("VALUE(")) {
                    vector2.add(stringArray[i]);
                }
                if (!stringArray[i].equals("DTSAM")) continue;
                double d = (Double)fDSInputRecord.getValue(stringArray[i]);
                Unit unit2 = FdsSISystem.getInstance().getTimeUnit();
                unitDouble = new UnitDouble(d, unit2);
            }
            UnitDouble unitDouble2 = null;
            if (vector2.size() == 0) {
                throw new Exception();
            }
            for (int i = 0; i < vector2.size(); ++i) {
                Double d = (Double)fDSInputRecord.getValue(vector2.elementAt(i).toString());
                unitDouble2 = new UnitDouble(d, unit);
                vector.add(unitDouble2);
            }
            IsofRecord isofRecord = new IsofRecord(vector, string, unitDouble);
            this.getContainer().getIsofList().taskAdd(isofRecord).run();
            this.flagPyroTypeAffected(IsofRecord.class);
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

