/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class HoleProcessor
extends AFDSRecordProcessor {
    private Hashtable d_allHoles = new Hashtable(243);
    private int d_nextHoleNum = 1;

    public HoleProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "HOLE";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        if (!"HOLE".equals(fDSInputRecord.getType())) {
            return false;
        }
        Vector vector = null;
        try {
            AlignedHole alignedHole;
            double d;
            vector = (Vector)fDSInputRecord.getValue("XB");
            double d2 = (Double)vector.get(0);
            double d3 = (Double)vector.get(2);
            double d4 = (Double)vector.get(4);
            double d5 = (Double)vector.get(1);
            double d6 = (Double)vector.get(3);
            double d7 = (Double)vector.get(5);
            if (d5 < d2) {
                d = d2;
                d2 = d5;
                d5 = d;
            }
            if (d6 < d3) {
                d = d3;
                d3 = d6;
                d6 = d;
            }
            if (d7 < d4) {
                d = d4;
                d4 = d7;
                d7 = d;
            }
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            UnitPoint3D unitPoint3D = new UnitPoint3D(d2, d3, d4, unit);
            UnitPoint3D unitPoint3D2 = new UnitPoint3D(d5, d6, d7, unit);
            String string = fDSInputRecord.getComment();
            if (string == null || string.equals("")) {
                string = new String("Hole #" + this.d_nextHoleNum++);
                while (this.d_allHoles.get(string) != null) {
                    string = new String("Hole #" + this.d_nextHoleNum++);
                }
            }
            AlignedHole alignedHole2 = new AlignedHole(unitPoint3D, unitPoint3D2, string);
            Color color = this.parseColor(fDSInputRecord);
            if (color != null) {
                alignedHole2.setColor(color);
            }
            boolean bl2 = (alignedHole = (AlignedHole)EventParser.getCorrectObject(this.d_allHoles, alignedHole2)) != alignedHole2;
            alignedHole2 = alignedHole;
            String[] stringArray = new String[]{"T_CREATE"};
            String[] stringArray2 = new String[]{"T_REMOVE"};
            String string2 = "HEAT_CREATE";
            String string3 = "HEAT_REMOVE";
            EventParser.parseEvents(this, alignedHole2, fDSInputRecord, stringArray, stringArray2, string2, string3, this.getContainer().getHeatDetectors());
            if (!bl2) {
                this.getContainer().getObstructions().taskAdd(alignedHole2).run();
                this.d_allHoles.put(alignedHole2.getPropertyHashString(), alignedHole2);
                this.flagPyroTypeAffected(AlignedHole.class);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            bl = true;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            bl = true;
        }
        if (bl) {
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private UnitDouble makeDouble(Object object) {
        return new UnitDouble((Double)object, FdsSISystem.getInstance().getLengthUnit());
    }
}

