/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class HeatProcessor
extends AFDSRecordProcessor {
    public HeatProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "HEAT";
    }

    private String getAutoName(HeatDetectorList heatDetectorList) {
        int n = 1;
        String string = "HD" + n;
        while (heatDetectorList.contains(string)) {
            string = "HD" + ++n;
        }
        return string;
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        HeatDetectorList heatDetectorList = this.getContainer().getHeatDetectors();
        FDSRecordFormatException fDSRecordFormatException = null;
        boolean bl = false;
        if (!"HEAT".equals(fDSInputRecord.getType())) {
            return false;
        }
        try {
            String string = (String)fDSInputRecord.getValue("LABEL");
            if (string == null || string.equals("")) {
                string = this.getAutoName(heatDetectorList);
            }
            if (string.equals("ALL")) {
                throw new FDSRecordFormatException(fDSInputRecord, "A heat detector cannot be named ALL since this name is reserved by FDS.");
            }
            if (this.getContainer().getHeatDetectors().contains(string)) {
                throw new FDSRecordFormatException(fDSInputRecord, "The heat detector, \"" + string + ",\" already exists in the model.");
            }
            Vector vector = (Vector)fDSInputRecord.getValue("XYZ");
            if (vector == null) {
                throw new FDSRecordFormatException(fDSInputRecord, "A HEAT record must specify a location (XYZ).");
            }
            Unit unit = FdsSISystem.getInstance().getLengthUnit();
            double d = (Double)vector.get(0);
            double d2 = (Double)vector.get(1);
            double d3 = (Double)vector.get(2);
            UnitPoint3D unitPoint3D = new UnitPoint3D(d, d2, d3, unit);
            Double d4 = (Double)fDSInputRecord.getValue("RTI");
            if (d4 == null) {
                throw new FDSRecordFormatException(fDSInputRecord, "A HEAT record must specify a response time index (RTI).");
            }
            UnitDouble unitDouble = new UnitDouble(d4, FdsSISystem.getInstance().getRtiUnit());
            Double d5 = (Double)fDSInputRecord.getValue("ACTIVATION_TEMPERATURE");
            if (d5 == null) {
                throw new FDSRecordFormatException(fDSInputRecord, "A HEAT record must specify an activation temperature (ACTIVATION_TEMPERATURE).");
            }
            UnitDouble unitDouble2 = new UnitDouble(d5, FdsSISystem.getInstance().getTempUnit());
            HeatDetector heatDetector = new HeatDetector(unitPoint3D, unitDouble, unitDouble2, string);
            this.getContainer().getHeatDetectors().taskAdd(heatDetector).run();
            this.flagPyroTypeAffected(HeatDetector.class);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            bl = true;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            bl = true;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            bl = true;
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException2.printStackTrace();
            bl = true;
            fDSRecordFormatException = fDSRecordFormatException2;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

