/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Arrays;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class GridProcessor
extends AFDSRecordProcessor {
    private int d_iNextGridNumber = 1;
    private Vector d_gridInfos = new Vector();
    private TempGridInfo d_currentGridInfo;
    private Vector d_trnx = new Vector();
    private Vector d_trny = new Vector();
    private Vector d_trnz = new Vector();
    private boolean d_trnWarningShown = false;
    private static final String s_defGridName = "Grid";

    public GridProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
        this.resetTempData();
    }

    @Override
    public String getFDSTypeParsed() {
        return "GRID";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl;
        block23: {
            bl = false;
            try {
                if ("PDIM".equals(fDSInputRecord.getType())) {
                    Double d;
                    String string;
                    if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
                        this.finishTempGridInfo();
                    }
                    if ((string = fDSInputRecord.getComment()) != null && !string.equals("")) {
                        this.d_currentGridInfo.d_gridName = string;
                    }
                    if ((d = (Double)fDSInputRecord.getValue("XBAR0")) != null) {
                        this.d_currentGridInfo.d_min.x = d;
                    }
                    if ((d = (Double)fDSInputRecord.getValue("YBAR0")) != null) {
                        this.d_currentGridInfo.d_min.y = d;
                    }
                    if ((d = (Double)fDSInputRecord.getValue("ZBAR0")) != null) {
                        this.d_currentGridInfo.d_min.z = d;
                    }
                    this.d_currentGridInfo.d_max.x = (Double)fDSInputRecord.getValue("XBAR");
                    this.d_currentGridInfo.d_max.y = (Double)fDSInputRecord.getValue("YBAR");
                    this.d_currentGridInfo.d_max.z = (Double)fDSInputRecord.getValue("ZBAR");
                    Rectifier.rectify(this.d_currentGridInfo.d_min, this.d_currentGridInfo.d_max);
                    this.d_currentGridInfo.d_haveBounds = true;
                    break block23;
                }
                if ("GRID".equals(fDSInputRecord.getType())) {
                    String string;
                    if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
                        this.finishTempGridInfo();
                    }
                    if ((string = fDSInputRecord.getComment()) != null && !string.equals("")) {
                        this.d_currentGridInfo.d_gridName = string;
                    }
                    this.d_currentGridInfo.d_xDiv = fDSInputRecord.extractInt("IBAR", 2, (IntValueRange)Grid.getValueRange("IBAR"), false);
                    this.d_currentGridInfo.d_yDiv = fDSInputRecord.extractInt("JBAR", 2, (IntValueRange)Grid.getValueRange("JBAR"), false);
                    this.d_currentGridInfo.d_zDiv = fDSInputRecord.extractInt("KBAR", 2, (IntValueRange)Grid.getValueRange("KBAR"), false);
                    this.d_currentGridInfo.d_haveNumDivisions = true;
                    break block23;
                }
                if ("TRNX".equals(fDSInputRecord.getType())) {
                    double d = (Double)fDSInputRecord.getValue("CC");
                    double d2 = (Double)fDSInputRecord.getValue("PC");
                    Double d3 = (Double)fDSInputRecord.getValue("MESH_NUMBER");
                    if (d3 == null) {
                        d3 = new Double(this.d_gridInfos.size() + 1);
                        fDSInputRecord.setValue("MESH_NUMBER", d3);
                    }
                    int n = d3.intValue();
                    Double d4 = (Double)fDSInputRecord.getValue("IDERIV");
                    if (d4 != null) {
                        return false;
                    }
                    this.d_trnx.add(new TRNCard(d, d2, n, fDSInputRecord));
                    break block23;
                }
                if ("TRNY".equals(fDSInputRecord.getType())) {
                    double d = (Double)fDSInputRecord.getValue("CC");
                    double d5 = (Double)fDSInputRecord.getValue("PC");
                    Double d6 = (Double)fDSInputRecord.getValue("MESH_NUMBER");
                    if (d6 == null) {
                        d6 = new Double(this.d_gridInfos.size() + 1);
                        fDSInputRecord.setValue("MESH_NUMBER", d6);
                    }
                    int n = d6.intValue();
                    Double d7 = (Double)fDSInputRecord.getValue("IDERIV");
                    if (d7 != null) {
                        return false;
                    }
                    this.d_trny.add(new TRNCard(d, d5, n, fDSInputRecord));
                    break block23;
                }
                if ("TRNZ".equals(fDSInputRecord.getType())) {
                    double d = (Double)fDSInputRecord.getValue("CC");
                    double d8 = (Double)fDSInputRecord.getValue("PC");
                    Double d9 = (Double)fDSInputRecord.getValue("MESH_NUMBER");
                    if (d9 == null) {
                        d9 = new Double(this.d_gridInfos.size() + 1);
                        fDSInputRecord.setValue("MESH_NUMBER", d9);
                    }
                    int n = d9.intValue();
                    Double d10 = (Double)fDSInputRecord.getValue("IDERIV");
                    if (d10 != null) {
                        return false;
                    }
                    this.d_trnz.add(new TRNCard(d, d8, n, fDSInputRecord));
                    break block23;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                bl = true;
            }
            catch (ClassCastException classCastException) {
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = true;
            }
        }
        if (bl) {
            throw new FDSRecordFormatException(fDSInputRecord);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
            this.finishTempGridInfo();
        }
        this.createGrids();
    }

    private void resetTempData() {
        this.d_currentGridInfo = new TempGridInfo();
    }

    private void finishTempGridInfo() {
        this.d_gridInfos.add(this.d_currentGridInfo);
        this.resetTempData();
    }

    private void checkTempGridInfoTRNCards() throws FDSRecordFormatException {
        for (int i = 0; i < this.d_gridInfos.size(); ++i) {
            int n;
            TRNCard tRNCard;
            int n2;
            double d;
            double d2;
            TempGridInfo tempGridInfo = (TempGridInfo)this.d_gridInfos.get(i);
            if (tempGridInfo.d_trnx.size() > 0) {
                d2 = ((TRNCard)tempGridInfo.d_trnx.get((int)0)).pc;
                d = ((TRNCard)tempGridInfo.d_trnx.get((int)0)).cc;
                for (n2 = 1; n2 < tempGridInfo.d_trnx.size(); ++n2) {
                    tRNCard = (TRNCard)tempGridInfo.d_trnx.get(n2);
                    n = tRNCard.d_gridIndex;
                    if (tRNCard.cc < d || tRNCard.pc < d2) {
                        throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNX records for grid number " + n + " are specified out of order. For each TRNX\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    if (tRNCard.cc == d || tRNCard.pc == d2) {
                        throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNX records for grid number " + n + " are specified incorrectly. For each TRNX\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    d2 = tRNCard.pc;
                    d = tRNCard.cc;
                }
            }
            if (tempGridInfo.d_trny.size() > 0) {
                d2 = ((TRNCard)tempGridInfo.d_trny.get((int)0)).pc;
                d = ((TRNCard)tempGridInfo.d_trny.get((int)0)).cc;
                for (n2 = 1; n2 < tempGridInfo.d_trny.size(); ++n2) {
                    tRNCard = (TRNCard)tempGridInfo.d_trny.get(n2);
                    n = tRNCard.d_gridIndex;
                    if (tRNCard.cc < d || tRNCard.pc < d2) {
                        throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNY records for grid number " + n + " are specified out of order. For each TRNY\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    if (tRNCard.cc == d || tRNCard.pc == d2) {
                        throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNY records for grid number " + n + " are specified incorrectly. For each TRNY\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    d2 = tRNCard.pc;
                    d = tRNCard.cc;
                }
            }
            if (tempGridInfo.d_trnz.size() <= 0) continue;
            d2 = ((TRNCard)tempGridInfo.d_trnz.get((int)0)).pc;
            d = ((TRNCard)tempGridInfo.d_trnz.get((int)0)).cc;
            for (n2 = 1; n2 < tempGridInfo.d_trnz.size(); ++n2) {
                tRNCard = (TRNCard)tempGridInfo.d_trnz.get(n2);
                n = tRNCard.d_gridIndex;
                if (tRNCard.cc < d || tRNCard.pc < d2) {
                    throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNZ records for grid number " + n + " are specified out of order. For each TRNZ\nrecord applied to the same grid, CC and PC must increase.");
                }
                if (tRNCard.cc == d || tRNCard.pc == d2) {
                    throw new FDSRecordFormatException(tRNCard.d_rec, "The TRNZ records for grid number " + n + " are specified incorrectly. For each TRNZ\nrecord applied to the same grid, CC and PC must increase.");
                }
                d2 = tRNCard.pc;
                d = tRNCard.cc;
            }
        }
    }

    private void applyTRNCards() throws FDSRecordFormatException {
        double d;
        double d2;
        TempGridInfo tempGridInfo;
        int n;
        TRNCard tRNCard;
        int n2;
        for (n2 = 0; n2 < this.d_trnx.size(); ++n2) {
            tRNCard = (TRNCard)this.d_trnx.get(n2);
            n = tRNCard.d_gridIndex;
            if (n > this.d_gridInfos.size() || n <= 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The grid number, " + n + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            tempGridInfo = (TempGridInfo)this.d_gridInfos.get(n - 1);
            d2 = tRNCard.cc;
            d = tRNCard.pc;
            if (d2 <= tempGridInfo.d_min.x || d2 >= tempGridInfo.d_max.x) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The computational coordinate (CC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.x + " and " + tempGridInfo.d_max.x + " (non-inclusive).");
            }
            if (d <= tempGridInfo.d_min.x || d >= tempGridInfo.d_max.x) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The physical coordinate (PC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.x + " and " + tempGridInfo.d_max.x + " (non-inclusive).");
            }
            tempGridInfo.d_trnx.add(tRNCard);
            tempGridInfo.d_nonUniform = true;
        }
        for (n2 = 0; n2 < this.d_trny.size(); ++n2) {
            tRNCard = (TRNCard)this.d_trny.get(n2);
            n = tRNCard.d_gridIndex;
            if (n > this.d_gridInfos.size() || n <= 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The grid number, " + n + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            tempGridInfo = (TempGridInfo)this.d_gridInfos.get(n - 1);
            d2 = tRNCard.cc;
            d = tRNCard.pc;
            if (d2 <= tempGridInfo.d_min.y || d2 >= tempGridInfo.d_max.y) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The computational coordinate (CC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.y + " and " + tempGridInfo.d_max.y + " (non-inclusive).");
            }
            if (d <= tempGridInfo.d_min.y || d >= tempGridInfo.d_max.y) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The physical coordinate (PC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.y + " and " + tempGridInfo.d_max.y + " (non-inclusive).");
            }
            tempGridInfo.d_trny.add(tRNCard);
            tempGridInfo.d_nonUniform = true;
        }
        for (n2 = 0; n2 < this.d_trnz.size(); ++n2) {
            tRNCard = (TRNCard)this.d_trnz.get(n2);
            n = tRNCard.d_gridIndex;
            if (n > this.d_gridInfos.size() || n <= 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The grid number, " + n + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            tempGridInfo = (TempGridInfo)this.d_gridInfos.get(n - 1);
            if (tempGridInfo.d_trnx.size() > 0 && tempGridInfo.d_trny.size() > 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "Grid scalings have been specified along all three axes for grid number " + n + ", but FDS4 only allows\nscaling along two axes.");
            }
            d2 = tRNCard.cc;
            d = tRNCard.pc;
            if (d2 <= tempGridInfo.d_min.z || d2 >= tempGridInfo.d_max.z) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The computational coordinate (CC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.z + " and " + tempGridInfo.d_max.z + " (non-inclusive).");
            }
            if (d <= tempGridInfo.d_min.z || d >= tempGridInfo.d_max.z) {
                throw new FDSRecordFormatException(tRNCard.d_rec, "The physical coordinate (PC) for scaling grid number " + n + " is invalid.  It must be between " + tempGridInfo.d_min.z + " and " + tempGridInfo.d_max.z + " (non-inclusive).");
            }
            tempGridInfo.d_trnz.add(tRNCard);
            tempGridInfo.d_nonUniform = true;
        }
        this.checkTempGridInfoTRNCards();
    }

    private void createGrids() throws FDSRecordFormatException {
        this.applyTRNCards();
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        for (int i = 0; i < this.d_gridInfos.size(); ++i) {
            TempGridInfo tempGridInfo = (TempGridInfo)this.d_gridInfos.get(i);
            Grid grid = null;
            UnitPoint3D unitPoint3D = new UnitPoint3D(tempGridInfo.d_min, unit);
            UnitPoint3D unitPoint3D2 = new UnitPoint3D(tempGridInfo.d_max, unit);
            if (tempGridInfo.d_nonUniform) {
                System.out.println("Creating a non-uniform grid...");
                UnitDouble[] unitDoubleArray = null;
                UnitDouble[] unitDoubleArray2 = null;
                UnitDouble[] unitDoubleArray3 = null;
                unitDoubleArray = tempGridInfo.d_trnx.size() != 0 ? this.makeNonUniformDivisions(tempGridInfo.d_trnx, unitPoint3D.x(unit), unitPoint3D2.x(unit), tempGridInfo.d_xDiv) : Grid.makeUniformDivisions(tempGridInfo.d_xDiv, unitPoint3D.xu(), unitPoint3D2.xu());
                unitDoubleArray2 = tempGridInfo.d_trny.size() != 0 ? this.makeNonUniformDivisions(tempGridInfo.d_trny, unitPoint3D.y(unit), unitPoint3D2.y(unit), tempGridInfo.d_yDiv) : Grid.makeUniformDivisions(tempGridInfo.d_yDiv, unitPoint3D.yu(), unitPoint3D2.yu());
                unitDoubleArray3 = tempGridInfo.d_trnz.size() != 0 ? this.makeNonUniformDivisions(tempGridInfo.d_trnz, unitPoint3D.z(unit), unitPoint3D2.z(unit), tempGridInfo.d_zDiv) : Grid.makeUniformDivisions(tempGridInfo.d_zDiv, unitPoint3D.zu(), unitPoint3D2.zu());
                grid = new Grid(unitPoint3D, unitPoint3D2, unitDoubleArray, unitDoubleArray2, unitDoubleArray3, tempGridInfo.d_gridName);
            } else {
                System.out.println("Creating a uniform grid...");
                grid = new Grid(unitPoint3D, unitPoint3D2, tempGridInfo.d_xDiv, tempGridInfo.d_yDiv, tempGridInfo.d_zDiv, tempGridInfo.d_gridName);
            }
            this.makeUnique(grid, Grid.class);
            this.getContainer().getGridManager().taskAdd(grid).run();
            this.flagPyroTypeAffected(Grid.class);
        }
        this.resetTempData();
    }

    private UnitDouble[] makeNonUniformDivisions(Vector vector, double d, double d2, int n) {
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        Object[] objectArray = new UnitDouble[n];
        int n2 = 0;
        double d3 = d;
        double d4 = d;
        double d5 = 0.0;
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            TRNCard tRNCard = (TRNCard)vector.get(i);
            n3 = (int)Math.round((tRNCard.cc - d4) / (d2 - d) * (double)n);
            d5 = (tRNCard.pc - d3) / (double)n3;
            Arrays.fill(objectArray, n2, n2 + n3, new UnitDouble(d5, unit));
            d3 = tRNCard.pc;
            d4 = tRNCard.cc;
            n2 += n3;
        }
        n3 = n - n2;
        d5 = (d2 - d3) / (double)n3;
        Arrays.fill(objectArray, n2, n2 + n3, new UnitDouble(d5, unit));
        return objectArray;
    }

    private class TRNCard {
        public final FDSInputRecord d_rec;
        public final double cc;
        public final double pc;
        public final int d_gridIndex;

        public TRNCard(double d, double d2, int n, FDSInputRecord fDSInputRecord) {
            this.cc = d;
            this.pc = d2;
            this.d_gridIndex = n;
            this.d_rec = fDSInputRecord;
        }
    }

    private static class TempGridInfo {
        public boolean d_haveBounds = false;
        public boolean d_haveNumDivisions = false;
        public boolean d_haveSpacing = false;
        public boolean d_nonUniform = false;
        public Point3d d_min = new Point3d(0.0, 0.0, 0.0);
        public Point3d d_max = new Point3d(0.0, 0.0, 0.0);
        public int d_xDiv = 1;
        public int d_yDiv = 1;
        public int d_zDiv = 1;
        public String d_gridName = "Grid";
        public Vector d_trnx = new Vector();
        public Vector d_trny = new Vector();
        public Vector d_trnz = new Vector();
    }
}

