/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Primitive;

public class GE1File {
    public static boolean writeFile(String string, PyroMod pyroMod) throws IOException {
        Geometry geometry = new Geometry();
        pyroMod.getObstructions().getGeometry(geometry);
        Map<Material, GE1Appearance> map = GE1File.collectFaceMats(pyroMod, geometry);
        if (map.isEmpty()) {
            return false;
        }
        GE1Appearance[] gE1AppearanceArray = map.values().toArray(new GE1Appearance[map.size()]);
        for (int i = 0; i < gE1AppearanceArray.length; ++i) {
            gE1AppearanceArray[i].d_index = i;
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        GE1File.writeAppearances(printWriter, gE1AppearanceArray);
        GE1File.writeFaces(printWriter, geometry, map);
        printWriter.close();
        return true;
    }

    private static Map<Material, GE1Appearance> collectFaceMats(PyroMod pyroMod, Geometry geometry) {
        HashMap<Material, GE1Appearance> hashMap = new HashMap<Material, GE1Appearance>(pyroMod.getMaterials().size());
        GE1File.collectPrimMats(geometry.getQuads(), hashMap);
        GE1File.collectPrimMats(geometry.getTriangles(), hashMap);
        return hashMap;
    }

    private static void collectPrimMats(Collection<? extends Primitive> collection, Map<Material, GE1Appearance> map) {
        for (Primitive primitive : collection) {
            Material material = primitive.getProps().getMaterial();
            if (material == null) continue;
            GE1Appearance gE1Appearance = new GE1Appearance(material);
            map.put(material, gE1Appearance);
        }
    }

    private static void writeAppearances(PrintWriter printWriter, GE1Appearance[] gE1AppearanceArray) {
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        printWriter.println("[APPEARANCE]");
        printWriter.println(gE1AppearanceArray.length);
        float[] fArray = new float[4];
        for (GE1Appearance gE1Appearance : gE1AppearanceArray) {
            String string;
            double d;
            double d2;
            Material material = gE1Appearance.d_mat;
            printWriter.println(material.getName());
            Color color = material.getColor();
            TextureInfo textureInfo = material.getTextureInfo();
            if (textureInfo != null) {
                d2 = textureInfo.getWidth().getValue(unit);
                d = textureInfo.getHeight().getValue(unit);
                string = textureInfo.getTexID();
            } else {
                d = 0.0;
                d2 = 0.0;
                string = "";
            }
            color.getComponents(fArray);
            printWriter.printf("%d %f %f %f %f %f\n", gE1Appearance.d_index, Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), d2, d);
            printWriter.println(string);
        }
    }

    private static void writeFaces(PrintWriter printWriter, Geometry geometry, Map<Material, GE1Appearance> map) {
        printWriter.println("[FACES]");
        printWriter.println(geometry.getQuads().size() + geometry.getTriangles().size());
        GE1File.writePrims(printWriter, geometry.getQuads(), map, 4);
        GE1File.writePrims(printWriter, geometry.getTriangles(), map, 3);
    }

    private static void writePrims(PrintWriter printWriter, Collection<? extends Primitive> collection, Map<Material, GE1Appearance> map, int n) {
        int n2 = 4 - n + 1;
        if (n2 <= 0) {
            return;
        }
        int n3 = n - 1;
        for (Primitive primitive : collection) {
            Object object;
            Material material = primitive.getProps().getMaterial();
            if (material == null) continue;
            Point3d[] point3dArray = primitive.getPoints();
            assert (point3dArray.length == n);
            for (int i = 0; i < n3; ++i) {
                object = point3dArray[i];
                printWriter.printf("%f %f %f ", ((Point3d)object).x, ((Point3d)object).y, ((Point3d)object).z);
            }
            Point3d point3d = point3dArray[n3];
            for (int i = 0; i < n2; ++i) {
                printWriter.printf("%f %f %f ", point3d.x, point3d.y, point3d.z);
            }
            object = map.get(material);
            assert (object != null);
            printWriter.println(((GE1Appearance)object).d_index);
        }
    }

    private static class GE1Appearance {
        private final Material d_mat;
        private int d_index;

        public GE1Appearance(Material material) {
            assert (material != null);
            this.d_mat = material;
        }
    }
}

