/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.io.BNDFProcessor;
import pyrosim.legacy_2006_2.io.DatabaseProcessor;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;
import pyrosim.legacy_2006_2.io.GridProcessor;
import pyrosim.legacy_2006_2.io.HeadProcessor;
import pyrosim.legacy_2006_2.io.HeatProcessor;
import pyrosim.legacy_2006_2.io.HoleProcessor;
import pyrosim.legacy_2006_2.io.IsofProcessor;
import pyrosim.legacy_2006_2.io.MiscProcessor;
import pyrosim.legacy_2006_2.io.ObstProcessor;
import pyrosim.legacy_2006_2.io.PL3DProcessor;
import pyrosim.legacy_2006_2.io.PartProcessor;
import pyrosim.legacy_2006_2.io.PipeProcessor;
import pyrosim.legacy_2006_2.io.RadiProcessor;
import pyrosim.legacy_2006_2.io.ReacProcessor;
import pyrosim.legacy_2006_2.io.SlcfProcessor;
import pyrosim.legacy_2006_2.io.SmodProcessor;
import pyrosim.legacy_2006_2.io.SprkProcessor;
import pyrosim.legacy_2006_2.io.SurfProcessor;
import pyrosim.legacy_2006_2.io.ThcpProcessor;
import pyrosim.legacy_2006_2.io.TimeProcessor;
import pyrosim.legacy_2006_2.io.VentProcessor;

public class FDSRecordProcessorFactory {
    private static final Map<String, Set<String>> s_fdsTypesDependedOn = new TreeMap<String, Set<String>>();

    public static FDSRecordProcessor getProcessor(String string, FDSParsingInfo fDSParsingInfo) {
        if (string.equals("BNDF")) {
            return new BNDFProcessor(fDSParsingInfo);
        }
        if (string.equals("DATABASE_RECORD")) {
            return new DatabaseProcessor(fDSParsingInfo);
        }
        if (string.equals("GRID")) {
            return new GridProcessor(fDSParsingInfo);
        }
        if (string.equals("HEAD")) {
            return new HeadProcessor(fDSParsingInfo);
        }
        if (string.equals("HEAT")) {
            return new HeatProcessor(fDSParsingInfo);
        }
        if (string.equals("SMOD")) {
            return new SmodProcessor(fDSParsingInfo);
        }
        if (string.equals("HOLE")) {
            return new HoleProcessor(fDSParsingInfo);
        }
        if (string.equals("ISOF")) {
            return new IsofProcessor(fDSParsingInfo);
        }
        if (string.equals("MISC")) {
            return new MiscProcessor(fDSParsingInfo);
        }
        if (string.equals("RADI")) {
            return new RadiProcessor(fDSParsingInfo);
        }
        if (string.equals("OBST")) {
            return new ObstProcessor(fDSParsingInfo);
        }
        if (string.equals("PART")) {
            return new PartProcessor(fDSParsingInfo);
        }
        if (string.equals("PIPE")) {
            return new PipeProcessor(fDSParsingInfo);
        }
        if (string.equals("PL3D")) {
            return new PL3DProcessor(fDSParsingInfo);
        }
        if (string.equals("REAC")) {
            return new ReacProcessor(fDSParsingInfo);
        }
        if (string.equals("SLCF")) {
            return new SlcfProcessor(fDSParsingInfo);
        }
        if (string.equals("SPRK")) {
            return new SprkProcessor(fDSParsingInfo);
        }
        if (string.equals("SURF")) {
            return new SurfProcessor(fDSParsingInfo);
        }
        if (string.equals("THCP")) {
            return new ThcpProcessor(fDSParsingInfo);
        }
        if (string.equals("TIME")) {
            return new TimeProcessor(fDSParsingInfo);
        }
        if (string.equals("VENT")) {
            return new VentProcessor(fDSParsingInfo);
        }
        return null;
    }

    public static Set<String> getFDSTypesDependendedOn(String string) {
        Set<String> set = s_fdsTypesDependedOn.get(string);
        if (set == null) {
            return new TreeSet<String>();
        }
        return set;
    }

    public static boolean type1ProcessorDependsOnType2Processor(String string, String string2) {
        Set<String> set = FDSRecordProcessorFactory.getFDSTypesDependendedOn(string);
        for (String string3 : set) {
            if (string2.equals(string3)) {
                return true;
            }
            if (!FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(string3, string2)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getDependedOnByAll() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("DATABASE_RECORD");
        return treeSet;
    }

    private static Set<String> getDependedOnByBNDF() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("MISC");
        return set;
    }

    private static Set<String> getDependedOnByOBST() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("SURF");
        set.add("HEAT");
        set.add("MISC");
        return set;
    }

    private static Set<String> getDependedOnByVENT() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByOBST();
        set.add("GRID");
        return set;
    }

    private static Set<String> getDependedOnByHOLE() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("HEAT");
        return set;
    }

    private static Set<String> getDependedOnBySURF() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("PART");
        return set;
    }

    private static Set<String> getDependedOnBySPRK() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("PART");
        return set;
    }

    private static Set<String> getDependedOnByMISC() {
        Set<String> set = FDSRecordProcessorFactory.getDependedOnByAll();
        set.add("SURF");
        set.add("REAC");
        return set;
    }

    static {
        s_fdsTypesDependedOn.put("OBST", FDSRecordProcessorFactory.getDependedOnByOBST());
        s_fdsTypesDependedOn.put("VENT", FDSRecordProcessorFactory.getDependedOnByVENT());
        s_fdsTypesDependedOn.put("HOLE", FDSRecordProcessorFactory.getDependedOnByHOLE());
        s_fdsTypesDependedOn.put("SURF", FDSRecordProcessorFactory.getDependedOnBySURF());
        s_fdsTypesDependedOn.put("SPRK", FDSRecordProcessorFactory.getDependedOnBySPRK());
        s_fdsTypesDependedOn.put("MISC", FDSRecordProcessorFactory.getDependedOnByMISC());
        s_fdsTypesDependedOn.put("BNDF", FDSRecordProcessorFactory.getDependedOnByBNDF());
    }
}

