/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;

public class FDSRecordFormatException
extends Exception {
    private static final long serialVersionUID = -2463984113898547256L;
    String d_sErrorMessage = "";

    public FDSRecordFormatException(String string) {
        super("Invalid record format.");
        this.constructErrorMessage(null, string);
    }

    public FDSRecordFormatException(FDSInputRecord fDSInputRecord) {
        super("Invalid " + fDSInputRecord.getType() + " record format.");
        this.constructErrorMessage(fDSInputRecord, null);
    }

    public FDSRecordFormatException(FDSInputRecord fDSInputRecord, String string) {
        super("Invalid " + fDSInputRecord.getType() + " record format.");
        this.constructErrorMessage(fDSInputRecord, string);
    }

    private void constructErrorMessage(FDSInputRecord fDSInputRecord, String string) {
        String string2 = "";
        if (fDSInputRecord != null) {
            string2 = "Invalid " + fDSInputRecord.getType() + " record specified";
            FDSInputRecordDebugInfo fDSInputRecordDebugInfo = fDSInputRecord.getDebugInfo();
            if (fDSInputRecordDebugInfo != null) {
                int n = fDSInputRecordDebugInfo.getBeginLineNum();
                int n2 = fDSInputRecordDebugInfo.getEndLineNum();
                if (n > 0 && n2 > 0) {
                    string2 = n == n2 ? string2 + " on line " + n : string2 + " on lines " + n + " through " + n2;
                }
            }
            if (fDSInputRecordDebugInfo != null && fDSInputRecordDebugInfo.getFilename() != null) {
                string2 = string2 + " in the file,\n" + fDSInputRecordDebugInfo.getFilename();
            }
            string2 = string2 + ".";
            if (fDSInputRecordDebugInfo != null && fDSInputRecordDebugInfo.getOriginalText() != null) {
                string2 = string2 + "\n\n\"" + fDSInputRecordDebugInfo.getOriginalText() + "\"\n";
            }
            if (string != null) {
                string2 = string2 + "\n" + string;
            }
        } else {
            string2 = super.getMessage();
        }
        this.d_sErrorMessage = string2;
    }

    @Override
    public String getMessage() {
        return this.d_sErrorMessage;
    }
}

