/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.io.FDSParseWarning;
import pyrosim.legacy_2006_2.thunderheadeng.util.WarningReport;

public class FDSParsingInfo {
    public static final int DBL_FAIL_ON_ERROR = 0;
    public static final int DBL_CONTINUE_ON_ERROR = 1;
    public static final int DEFAULT_DEBUG_LEVEL = 0;
    private final PyroMod d_rwContainer;
    private final Collection<PyroMod> d_rContainers;
    private Material d_defaultMaterial;
    private Set<String> d_parsedFiles = new TreeSet<String>();
    private Stack<String> d_filenameStack = new Stack();
    private int d_debugLevel;
    private Set<Class> d_pyroObjectTypesAffected = new HashSet<Class>(PyroMod.getAllPyroObjectTypes().size());
    private boolean d_markAsUnprocessedOnlyIfTrulyUnprocessable = false;
    private final Set<String> d_parsingTypes;
    private final WarningReport<FDSParseWarning> d_warningReport;

    public FDSParsingInfo(Set<String> set, PyroMod pyroMod, Collection<PyroMod> collection) {
        this(set, pyroMod, collection, 0, false);
    }

    public FDSParsingInfo(Set<String> set, PyroMod pyroMod, Collection<PyroMod> collection, int n, boolean bl) {
        this(set, pyroMod, collection, new WarningReport<FDSParseWarning>(FDSParseWarning.class, FDSParseWarning.getWarningInfoTypes(), FDSParseWarning.getWarningInfoDescriptions(), 2), n, bl);
    }

    public FDSParsingInfo(Set<String> set, PyroMod pyroMod, Collection<PyroMod> collection, WarningReport<FDSParseWarning> warningReport, int n, boolean bl) {
        this.d_parsingTypes = set;
        this.d_rwContainer = pyroMod;
        this.d_rContainers = new Vector<PyroMod>(collection.size() + 1);
        this.d_rContainers.add(pyroMod);
        for (PyroMod pyroMod2 : collection) {
            this.d_rContainers.add(pyroMod2);
        }
        this.d_warningReport = warningReport;
        for (PyroMod pyroMod2 : this.d_rContainers) {
            Material material = pyroMod2.getDefaultMaterial();
            if (material == null) continue;
            this.d_defaultMaterial = material;
            break;
        }
        assert (this.d_defaultMaterial != null);
        this.d_debugLevel = n;
        this.d_markAsUnprocessedOnlyIfTrulyUnprocessable = bl;
    }

    public Set<String> getParsingTypes() {
        return this.d_parsingTypes;
    }

    public int getDebugLevel() {
        return this.d_debugLevel;
    }

    public boolean markRecsAsUnprocessedOnlyIfTrulyUnprocessable() {
        return this.d_markAsUnprocessedOnlyIfTrulyUnprocessable;
    }

    public void setDefaultMaterial(Material material) {
        this.d_defaultMaterial = material;
    }

    public Material getDefaultMaterial() {
        return this.d_defaultMaterial;
    }

    public boolean fileParsingStarted(String string) {
        if (this.d_parsedFiles.contains(string)) {
            return false;
        }
        this.d_parsedFiles.add(string);
        this.d_filenameStack.push(string);
        return true;
    }

    public String fileParsingFinished() {
        if (this.d_filenameStack.size() == 0) {
            return null;
        }
        return this.d_filenameStack.pop();
    }

    public String getCurrentParsingFile() {
        if (this.d_filenameStack.size() == 0) {
            return null;
        }
        return this.d_filenameStack.peek();
    }

    public boolean fileParsingHasStarted(String string) {
        if (this.d_filenameStack.size() == 0) {
            return false;
        }
        return this.d_parsedFiles.contains(string);
    }

    public Set<Class> getPyroObjectTypesAffected() {
        return this.d_pyroObjectTypesAffected;
    }

    public PyroMod getContainer() {
        return this.d_rwContainer;
    }

    public <K, V extends IPyroObject> boolean resourceExists(K k, Class<V> clazz) {
        return this.getResource(k, clazz) != null;
    }

    public <K, V extends IPyroObject> V getResource(K k, Class<V> clazz) {
        for (PyroMod pyroMod : this.d_rContainers) {
            IPyroManager<?, K> iPyroManager = pyroMod.getPyroSimManager(clazz);
            V v = iPyroManager.get(k);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_rContainers;
    }

    public <K, V extends IPyroObject> void makeUnique(V v, Class<V> clazz) {
        for (PyroMod pyroMod : this.d_rContainers) {
            IPyroManager<?, V> iPyroManager = pyroMod.getPyroSimManager(clazz);
            iPyroManager.taskMakeUnique(v).run();
        }
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_warningReport.addWarning(fDSParseWarning);
    }

    public WarningReport<FDSParseWarning> getWarningReport() {
        return this.d_warningReport;
    }
}

