/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class FDSInputRecord
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final String BNDF = "BNDF";
    public static final String BNDF_QUANTITY = "QUANTITY";
    public static final String BNDF_DTSAM = "DTSAM";
    public static final String PDIM = "PDIM";
    public static final String XBAR0 = "XBAR0";
    public static final String YBAR0 = "YBAR0";
    public static final String ZBAR0 = "ZBAR0";
    public static final String XBAR = "XBAR";
    public static final String YBAR = "YBAR";
    public static final String ZBAR = "ZBAR";
    public static final String GRID = "GRID";
    public static final String IBAR = "IBAR";
    public static final String JBAR = "JBAR";
    public static final String KBAR = "KBAR";
    public static final String TRNX = "TRNX";
    public static final String TRNY = "TRNY";
    public static final String TRNZ = "TRNZ";
    public static final String CC = "CC";
    public static final String PC = "PC";
    public static final String MESH_NUMBER = "MESH_NUMBER";
    public static final String IDERIV = "IDERIV";
    public static final String HEAD_CHID = "CHID";
    public static final String HEAD_TITLE = "TITLE";
    public static final String HEAD = "HEAD";
    public static final String HEAT = "HEAT";
    public static final String HEAT_XYZ = "XYZ";
    public static final String HEAT_RTI = "RTI";
    public static final String HEAT_ACTIVATION_TEMP = "ACTIVATION_TEMPERATURE";
    public static final String HEAT_LABEL = "LABEL";
    public static final String SMOD = "SMOD";
    public static final String SMOD_XYZ = "XYZ";
    public static final String SMOD_LENGTH = "LENGTH";
    public static final String SMOD_ALPHA_C = "ALPHA_C";
    public static final String SMOD_BETA_C = "BETA_C";
    public static final String SMOD_ALPHA_E = "ALPHA_E";
    public static final String SMOD_BETA_E = "BETA_E";
    public static final String SMOD_ACTIVATION_OBS = "ACTIVATION_OBSCURATION";
    public static final String SMOD_LABEL = "LABEL";
    public static final String ISOF = "ISOF";
    public static final String ISOF_QUANTITY = "QUANTITY";
    public static final String ISOF_VALUE = "VALUE(";
    public static final String ISOF_DTSAM = "DTSAM";
    public static final String ALL = "ALL";
    public static final String DATABASE_RECORD = "DATABASE_RECORD";
    public static final String MISC = "MISC";
    public static final String DNS = "DNS";
    public static final String DB_FILE = "DATABASE";
    public static final String DB_DIR = "DATABASE_DIRECTORY";
    public static final String SURF_DEFAULT = "SURF_DEFAULT";
    public static final String REACTION = "REACTION";
    public static final String TEMP_AMBIENT = "TMPA";
    public static final String TEMP_OUTSIDE = "TMPO";
    public static final String INIT_VEL_X = "U0";
    public static final String INIT_VEL_Y = "V0";
    public static final String INIT_VEL_Z = "W0";
    public static final String NUM_FRAMES = "NFRAMES";
    public static final String AUTOMATIC_Z = "AUTOMATIC_Z";
    public static final String SUPPRESSION = "SUPPRESSION";
    public static final String CHARACTERISTIC_VELOCITY = "CHARACTERISTIC_VELOCITY";
    public static final String GAUGE_TEMPERATURE = "GAUGE_TEMPERATURE";
    public static final String BACKGROUND_SPECIES = "BACKGROUND_SPECIES";
    public static final String BAROCLINIC = "BAROCLINIC";
    public static final String CSMAG = "CSMAG";
    public static final String DENSITY = "DENSITY";
    public static final String DT0DZ = "DT0DZ";
    public static final String DTCORE = "DTCORE";
    public static final String DTSPAR = "DTSPAR";
    public static final String GVEC = "GVEC";
    public static final String ISOTHERMAL = "ISOTHERMAL";
    public static final String INCOMPRESSIBLE = "INCOMPRESSIBLE";
    public static final String PR = "PR";
    public static final String PINF = "PINF";
    public static final String POROUS_FLOOR = "POROUS_FLOOR";
    public static final String RADIATION = "RADIATION";
    public static final String RESTART = "RESTART";
    public static final String SC = "SC";
    public static final String SMOKE3D = "SMOKE3D";
    public static final String TEXTURE_ORIGIN = "TEXTURE_ORIGIN";
    public static final String LEAK_AREA = "LEAK_AREA";
    public static final String DTSAM_PART = "DTSAM_PART";
    public static final String DTPAR = "DTPAR";
    public static final String NPPS = "NPPS";
    public static final String MAXIMUM_DROPLETS = "MAXIMUM_DROPLETS";
    public static final String RENDER_FILE = "RENDER_FILE";
    public static final int SIMTYPE_LES = 0;
    public static final int SIMTYPE_DNS = 1;
    public static final int BAROCLINIC_NEGLECT = 0;
    public static final int BAROCLINIC_RESTORE = 1;
    public static final UnitDouble DEF_CHARACTERISTIC_VELOCITY = new UnitDouble(1.0, FdsSISystem.getInstance().getVelocityUnit());
    public static final UnitDouble DEF_GAUGE_TEMPERATURE = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_AMBIENT_TEMP = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_OUTSIDE_TEMP = new UnitDouble(20.0, FdsSISystem.getInstance().getTempUnit());
    public static final UnitDouble DEF_AMBIENT_PRESSURE = new UnitDouble(101325.0, FdsSISystem.getInstance().getAmbientPressureUnit());
    public static final UnitPoint3D DEF_INIT_VEL = new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getVelocityUnit());
    public static final int DEF_BAROCLINIC_LES = 0;
    public static final int DEF_BAROCLINIC_DNS = 1;
    public static final double DEF_CSMAG = 0.2;
    public static final UnitDouble DEF_DT0DZ = new UnitDouble(-0.0097, FdsSISystem.getInstance().getAtmGradUnit());
    public static final UnitDouble DEF_DTPAR = new UnitDouble(0.05, FdsSISystem.getInstance().getTimeUnit());
    public static final UnitDouble DEF_DTSPAR = new UnitDouble(0.05, FdsSISystem.getInstance().getTimeUnit());
    public static final UnitPoint3D DEF_GVEC = new UnitPoint3D(0.0, 0.0, -9.81, FdsSISystem.getInstance().getAccelUnit());
    public static final boolean DEF_ISOTHERMAL = false;
    public static final boolean DEF_RADSOLVEROFF = false;
    public static final boolean DEF_INCOMPRESSIBLE = false;
    public static final double DEF_PR = 0.5;
    public static final boolean DEF_POROUS_FLOOR = true;
    public static final boolean DEF_RADIATION = true;
    public static final boolean DEF_RESTART = false;
    public static final double DEF_SC = 0.5;
    public static final boolean DEF_SMOKE3D = true;
    public static final UnitDouble DEF_NPPS = new UnitDouble(100000.0, FdsSISystem.getInstance().getTimeUnit());
    public static final int DEF_MAXIMUM_DROPLETS = 500000;
    public static final int DEF_NUM_FRAMES = 1000;
    public static final boolean DEF_SUPPRESSION = true;
    public static final boolean DEF_AUTOMATIC_Z = true;
    public static final int DEF_SIMTYPE = 0;
    public static final String OBST = "OBST";
    public static final String HOLE = "HOLE";
    public static final String COORDS = "XB";
    public static final String SURF1 = "SURF_ID";
    public static final String SURF3 = "SURF_IDS";
    public static final String SURF6 = "SURF_ID6";
    public static final String GRID_WALL = "CB";
    public static final String PBX = "PBX";
    public static final String PBY = "PBY";
    public static final String PBZ = "PBZ";
    public static final String RGB = "RGB";
    public static final String COLOR = "COLOR";
    public static final String T_CREATE = "T_CREATE";
    public static final String T_REMOVE = "T_REMOVE";
    public static final String HEAT_CREATE = "HEAT_CREATE";
    public static final String HEAT_REMOVE = "HEAT_REMOVE";
    public static final String PERMIT_HOLE = "PERMIT_HOLE";
    public static final String SAWTOOTH = "SAWTOOTH";
    public static final String THICKEN = "THICKEN";
    public static final String INIVS_COLOR = "INVISIBLE";
    public static final String PART = "PART";
    public static final String PART_ID = "ID";
    public static final String PART_DENSITY = "DENSITY";
    public static final String PART_VAPTEMP = "VAPORIZATION_TEMPERATURE";
    public static final String PART_MELTTEMP = "MELTING_TEMPERATURE";
    public static final String PART_SPECIFICHEAT = "SPECIFIC_HEAT";
    public static final String PART_HEATVAP = "HEAT_OF_VAPORIZATION";
    public static final String PART_DIAMETER = "DIAMETER";
    public static final String PART_GAMMAD = "GAMMA_D";
    public static final String PART_MASSLESS = "MASSLESS";
    public static final String PART_STATIC = "STATIC";
    public static final String PART_FUEL = "FUEL";
    public static final String PART_HEATCOMBUST = "HEAT_OF_COMBUSTION";
    public static final String PART_WATER = "WATER";
    public static final String PART_SAMPLE = "SAMPLING_FACTOR";
    public static final String PART_QUANTITY = "QUANTITY";
    public static final String PART_INITDROP = "NUMBER_INITIAL_DROPLETS";
    public static final String PART_MASSVOL = "MASS_PER_VOLUME";
    public static final String PART_DROPSEC = "DROPLETS_PER_SECOND";
    public static final String PART_AGE = "AGE";
    public static final String PART_INITTEMP = "INITIAL_TEMPERATURE";
    public static final String PIPE = "PIPE";
    public static final String PIPE_DELAY = "DELAY";
    public static final String PIPE_PRESSURE = "PRESSURE";
    public static final String PL3D = "PL3D";
    public static final String PL3D_QUANTITIES = "QUANTITIES";
    public static final String PL3D_DTSAM = "DTSAM";
    public static final String PL3D_WRITE_XYZ = "WRITE_XYZ";
    public static final String RAMP = "RAMP";
    public static final String RAMP_ID = "ID";
    public static final String RAMP_T = "T";
    public static final String RAMP_F = "F";
    public static final String REAC = "REAC";
    public static final String REAC_ID = "ID";
    public static final String SLCF = "SLCF";
    public static final String SLCF_QUANTITY = "QUANTITY";
    public static final String SLCF_VECTOR = "VECTOR";
    public static final String SLCF_CB = "CB";
    public static final String SLCF_DTSAM = "DTSAM";
    public static final String SLCF_K_HIGH = "K_HIGH";
    public static final String SLCF_K_LOW = "K_LOW";
    public static final String SLCF_MESH_NUMBER = "MESH_NUMBER";
    public static final String SLCF_WRITE_XYZ = "WRITE_XYZ";
    public static final String SLCF_XB = "XB";
    public static final String SPRK = "SPRK";
    public static final String SPRK_LABEL = "LABEL";
    public static final String SPRK_MAKE = "MAKE";
    public static final String SPRK_ORIENTATION = "ORIENTATION";
    public static final String SPRK_PART_ID = "PART_ID";
    public static final String SPRK_ROTATION = "ROTATION";
    public static final String SPRK_T_ACTIVATE = "T_ACTIVATE";
    public static final String SPRK_T_DEACTIVATE = "T_DEACTIVATE";
    public static final String SPRK_XYZ = "XYZ";
    public static final String SURF = "SURF";
    public static final String THCP = "THCP";
    public static final String THCP_COORDS = "XYZ";
    public static final String THCP_QUANTITY = "QUANTITY";
    public static final String THCP_LABEL = "LABEL";
    public static final String THCP_DEPTH = "DEPTH";
    public static final String THCP_DIAMETER = "DIAMETER";
    public static final String THCP_DTSAM = "DTSAM";
    public static final String THCP_EMISSIVITY = "EMISSIVITY";
    public static final String THCP_K_HIGH = "K_HIGH";
    public static final String THCP_K_LOW = "K_LOW";
    public static final String THCP_XB = "XB";
    public static final String THCP_IOR = "IOR";
    public static final String TIME = "TIME";
    public static final String TWFIN = "TWFIN";
    public static final String DT = "DT";
    public static final String SYNCHRONIZE = "SYNCHRONIZE";
    public static final UnitDouble DEF_TWFIN = new UnitDouble(1.0, FdsSISystem.getInstance().getTimeUnit());
    public static final String VENT = "VENT";
    public static final String VENT_T_CLOSE = "T_CLOSE";
    public static final String VENT_T_OPEN = "T_OPEN";
    public static final String VENT_T_ACTIVATE = "T_ACTIVATE";
    public static final String VENT_T_DEACTIVATE = "T_DEACTIVATE";
    public static final String VENT_HEAT_ACTIVATE = "HEAT_ACTIVATE";
    public static final String VENT_HEAT_DEACTIVATE = "HEAT_DEACTIVATE";
    public static final String VENT_IOR = "IOR";
    public static final String RADI = "RADI";
    public static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    public static final String CH4_BANDS = "CH4_BANDS";
    public static final String KAPPA0 = "KAPPA0";
    public static final String NMIEANG = "NMIEANG";
    public static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    public static final String PATH = "PATH";
    public static final String RADTMP = "RADTMP";
    public static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    public static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    private String d_type;
    private String d_comment;
    private PropHash d_properties = new PropHash();
    private transient FDSInputRecordDebugInfo d_debugInfo = null;
    private int d_numDecimals;
    private PyroMod d_pyroMod;

    public FDSInputRecord() {
    }

    public FDSInputRecord(String string) throws FDSRecordFormatException {
        this(string, (String)null);
    }

    public FDSInputRecord(String string, FDSInputRecordDebugInfo fDSInputRecordDebugInfo) throws FDSRecordFormatException {
        this(string, null, fDSInputRecordDebugInfo);
    }

    public FDSInputRecord(String string, String string2) throws FDSRecordFormatException {
        this();
        this.d_comment = string2;
        this.parseRecord(string);
    }

    public FDSInputRecord(String string, String string2, FDSInputRecordDebugInfo fDSInputRecordDebugInfo) throws FDSRecordFormatException {
        this();
        this.d_comment = string2;
        this.d_debugInfo = fDSInputRecordDebugInfo;
        this.parseRecord(string);
    }

    public void setNumDecimals(int n) {
        this.d_numDecimals = n;
    }

    public int getNumDecimals() {
        return this.d_numDecimals;
    }

    private void parseRecord(String string) throws FDSRecordFormatException {
        String string2;
        CharSequence charSequence;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,=\n\r\t'", true);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("'")) {
                charSequence = new StringBuffer();
                while (true) {
                    string2 = "";
                    try {
                        string2 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (vector.size() > 0) {
                            this.d_type = (String)vector.get(0);
                        }
                        throw new FDSRecordFormatException(this, "Unterminated string constant");
                    }
                    if (string2.equals("'")) break;
                    ((StringBuffer)charSequence).append(string2);
                }
                vector.add('\'' + ((StringBuffer)charSequence).toString() + '\'');
                continue;
            }
            if (this.isDelimTok(string3)) continue;
            vector.add(string3);
        }
        if (vector.size() <= 3 || !vector.get(2).toString().equals("=")) {
            return;
        }
        this.d_type = (String)vector.get(0);
        string3 = null;
        charSequence = null;
        string2 = null;
        for (int i = 1; i < vector.size() - 1; ++i) {
            string3 = (String)vector.get(i);
            charSequence = (String)vector.get(i + 1);
            if (string3.equals("=")) continue;
            if (((String)charSequence).equals("=")) {
                string2 = string3;
                this.d_properties.put(string2);
                continue;
            }
            this.putValue(string2, string3);
        }
        this.putValue(string2, (String)charSequence);
    }

    private void putValue(String string, String string2) {
        if (string2.compareToIgnoreCase(".TRUE.") == 0) {
            this.d_properties.put(string, Boolean.TRUE);
        } else if (string2.compareToIgnoreCase(".FALSE.") == 0) {
            this.d_properties.put(string, Boolean.FALSE);
        } else if (string2.length() > 1 && string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
            this.d_properties.put(string, string2.substring(1, string2.length() - 1));
        } else {
            try {
                Double d = new Double(Double.parseDouble(string2));
                this.d_properties.put(string, d);
            }
            catch (NumberFormatException numberFormatException) {
                this.d_properties.put(string, string2);
            }
        }
    }

    private boolean isDelimTok(String string) {
        return string.equals(" ") || string.equals(",") || string.equals("\n") || string.equals("\r") || string.equals("\t");
    }

    public void setType(String string) {
        this.d_type = string;
    }

    public String getType() {
        return this.d_type;
    }

    public String[] getKeys() {
        return this.d_properties.keySet().toArray(new String[this.d_properties.size()]);
    }

    public Object[] getValues() {
        return this.d_properties.values().toArray();
    }

    public Object getValue(String string) {
        return this.d_properties.get(string);
    }

    public void setValue(String string, Object object) {
        this.d_properties.put(string, object);
    }

    public boolean removeValue(String string) {
        return this.d_properties.remove(string) != null;
    }

    public Object clone() {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setComment(this.getComment());
        fDSInputRecord.setType(this.getType());
        String[] stringArray = this.getKeys();
        Object[] objectArray = this.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            fDSInputRecord.setValue(stringArray[i], objectArray[i]);
        }
        return fDSInputRecord;
    }

    public String getComment() {
        return this.d_comment;
    }

    public void setComment(String string) {
        this.d_comment = string;
    }

    public FDSInputRecordDebugInfo getDebugInfo() {
        return this.d_debugInfo;
    }

    public boolean empty() {
        return this.d_properties.size() == 0;
    }

    public double extractDouble(String string, double d, DoubleValueRange doubleValueRange) throws ClassCastException, FDSRecordFormatException {
        return this.extractDouble(string, d, doubleValueRange, true);
    }

    public double extractDouble(String string, double d, DoubleValueRange doubleValueRange, boolean bl) throws ClassCastException, FDSRecordFormatException {
        Double d2 = (Double)this.getValue(string);
        double d3 = d;
        if (d2 != null) {
            if (doubleValueRange != null && !doubleValueRange.checkValue(d2)) {
                throw new FDSRecordFormatException(this, string + " must be " + doubleValueRange.describeRange() + ".");
            }
            d3 = d2;
        } else if (!bl) {
            throw new FDSRecordFormatException(this, string + " must be specified.");
        }
        return d3;
    }

    public UnitDouble extractDouble(String string, Unit unit, UnitDouble unitDouble, UnitDoubleValueRange unitDoubleValueRange) throws ClassCastException, FDSRecordFormatException {
        return this.extractDouble(string, unit, unitDouble, unitDoubleValueRange, true);
    }

    public UnitDouble extractDouble(String string, Unit unit, UnitDouble unitDouble, UnitDoubleValueRange unitDoubleValueRange, boolean bl) throws ClassCastException, FDSRecordFormatException {
        Double d = (Double)this.getValue(string);
        UnitDouble unitDouble2 = unitDouble;
        if (d != null) {
            unitDouble2 = new UnitDouble(d, unit);
            if (unitDoubleValueRange != null && !unitDoubleValueRange.checkValue(unitDouble2)) {
                throw new FDSRecordFormatException(this, string + " must be " + unitDoubleValueRange.describeRange() + ".");
            }
        } else if (!bl) {
            throw new FDSRecordFormatException(this, string + " must be specified.");
        }
        return unitDouble2;
    }

    public int extractInt(String string, int n, IntValueRange intValueRange) throws ClassCastException, FDSRecordFormatException {
        return this.extractInt(string, n, intValueRange, true);
    }

    public int extractInt(String string, int n, IntValueRange intValueRange, boolean bl) throws ClassCastException, FDSRecordFormatException {
        Double d = (Double)this.getValue(string);
        int n2 = n;
        if (d != null) {
            if (intValueRange != null && !intValueRange.checkValue(new Integer(d.intValue()))) {
                throw new FDSRecordFormatException(this, string + " must be " + intValueRange.describeRange() + ".");
            }
            n2 = d.intValue();
        } else if (!bl) {
            throw new FDSRecordFormatException(this, string + " must be specified.");
        }
        return n2;
    }

    public boolean extractBoolean(String string, boolean bl) throws ClassCastException {
        Boolean bl2 = (Boolean)this.getValue(string);
        boolean bl3 = bl;
        if (bl2 != null) {
            bl3 = bl2;
        }
        return bl3;
    }

    class PropHash
    extends LinkedHashMap
    implements Serializable {
        static final long serialVersionUID = 1L;

        PropHash() {
        }

        public void put(String string) {
            this.put(string, (Object)null);
        }

        @Override
        public void put(String string, Object object) {
            Object v = this.get(string);
            if (v == null) {
                super.put(string, object);
                return;
            }
            if (v instanceof Collection) {
                ((Collection)v).add(object);
                return;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.add(v);
            vector.add(object);
            super.put(string, vector);
        }
    }
}

