/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.Texture;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSRecordProcessorFactory;
import pyrosim.legacy_2006_2.io.GE1File;
import pyrosim.legacy_2006_2.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;
import thunderheadeng.io.CopyFile;

public class FDSInputFile {
    private static final String REC_END_CHAR = "/";
    private static final String REC_START_CHAR = "&";
    private static final String DECODER_NAME = "ISO-8859-15";
    private static Charset CHARSET = Charset.forName("ISO-8859-15");
    private static CharsetDecoder DECODER = CHARSET.newDecoder();
    private static DecimalFormat d_doubleFormat;
    private static boolean d_easyReadFormat;
    public static final Set<Class> WRITE_RECS;

    public void setEasyReadFormat(boolean bl) {
        if (d_easyReadFormat != bl) {
            d_easyReadFormat = bl;
        }
    }

    public boolean getEasyReadFormat() {
        return d_easyReadFormat;
    }

    public static Set<String> collectAllKnownFDSRecordTypes() {
        String[] stringArray = new String[]{"BNDF", "GRID", "HEAD", "HEAT", "HOLE", "ISOF", "MISC", "RADI", "OBST", "PART", "PDIM", "PIPE", "PL3D", "RAMP", "REAC", "SLCF", "SPRK", "SURF", "THCP", "TIME", "TRNX", "TRNY", "TRNZ", "VENT", "SMOD"};
        return new HashSet<String>(new VectorFromArray<String>(stringArray));
    }

    public Set<Class> parseFile(String string, PyroMod pyroMod) throws IOException, FDSRecordFormatException {
        return this.parseFile(string, FDSInputFile.collectAllKnownFDSRecordTypes(), pyroMod);
    }

    private Set<Class> parseFile(String string, Set<String> set, PyroMod pyroMod) throws IOException, FDSRecordFormatException {
        FDSParsingInfo fDSParsingInfo = new FDSParsingInfo(set, pyroMod, new LinkedList<PyroMod>());
        Set<Class> set2 = this.parseFile(string, fDSParsingInfo);
        String string2 = fDSParsingInfo.getWarningReport().prepareReport();
        System.err.println(string2);
        return set2;
    }

    public Set<Class> parseFile(String string, FDSParsingInfo fDSParsingInfo) throws IOException, FDSRecordFormatException {
        CharSequence charSequence = this.getBufferFromFile(string);
        return this.parseRecords(charSequence, string, fDSParsingInfo);
    }

    private CharSequence getBufferFromFile(String string) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));){
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(System.getProperty("line.separator"));
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
    }

    public Set<Class> parseRecords(CharSequence charSequence, String string, PyroMod pyroMod, Collection<PyroMod> collection) throws IOException, FDSRecordFormatException {
        FDSParsingInfo fDSParsingInfo = new FDSParsingInfo(FDSInputFile.collectAllKnownFDSRecordTypes(), pyroMod, collection);
        Set<Class> set = this.parseRecords(charSequence, string, fDSParsingInfo);
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Class> parseRecords(CharSequence charSequence, String string, FDSParsingInfo fDSParsingInfo) throws IOException, FDSRecordFormatException {
        fDSParsingInfo.getContainer().pauseUpdates(false);
        FDSInputRecord[] fDSInputRecordArray = FDSInputFile.parse(charSequence, string);
        HashSet<FDSInputRecord> hashSet = new HashSet<FDSInputRecord>(fDSInputRecordArray.length);
        for (int i = 0; i < fDSInputRecordArray.length; ++i) {
            hashSet.add(fDSInputRecordArray[i]);
        }
        fDSParsingInfo.fileParsingStarted(string);
        Queue<FDSRecordProcessor> queue = this.queueNecessaryProcessors(fDSParsingInfo);
        for (FDSRecordProcessor linkedList : queue) {
            this.process(fDSInputRecordArray, linkedList, hashSet);
        }
        if (hashSet.size() > 0) {
            void var8_12;
            Object object;
            if (!fDSParsingInfo.markRecsAsUnprocessedOnlyIfTrulyUnprocessable()) {
                HashSet<FDSInputRecord> hashSet2 = hashSet;
            } else {
                LinkedList<FDSInputRecord> linkedList = new LinkedList<FDSInputRecord>();
                object = FDSInputFile.collectAllKnownFDSRecordTypes();
                for (FDSInputRecord fDSInputRecord : hashSet) {
                    if (object.contains(fDSInputRecord.getType()) && !fDSParsingInfo.getParsingTypes().contains(fDSInputRecord.getType())) continue;
                    linkedList.add(fDSInputRecord);
                }
            }
            if (!var8_12.isEmpty()) {
                object = fDSParsingInfo.getContainer().getUnprocessedRecords();
                String string2 = System.getProperty("line.separator");
                object = (String)object + FDSInputFile.renderRecords((Collection<FDSInputRecord>)var8_12) + (String)string2;
                fDSParsingInfo.getContainer().setUnprocessedRecords((String)object);
            }
        }
        fDSParsingInfo.fileParsingFinished();
        fDSParsingInfo.getContainer().resumeUpdates(PyroModDomainEvent.newOpenInstance());
        return fDSParsingInfo.getPyroObjectTypesAffected();
    }

    private Queue<FDSRecordProcessor> queueNecessaryProcessors(FDSParsingInfo fDSParsingInfo) {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.collectNeededFDSTypesForProcessingRecursive(fDSParsingInfo.getParsingTypes(), treeSet, fDSParsingInfo);
        String[] stringArray = treeSet.toArray(new String[treeSet.size()]);
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string.equals(string2)) {
                    return 0;
                }
                if (FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(string, string2)) {
                    return 1;
                }
                if (FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(string2, string)) {
                    return -1;
                }
                return Integer.compare(FDSRecordProcessorFactory.getFDSTypesDependendedOn(string).size(), FDSRecordProcessorFactory.getFDSTypesDependendedOn(string2).size());
            }
        });
        LinkedList<FDSRecordProcessor> linkedList = new LinkedList<FDSRecordProcessor>();
        for (int i = 0; i < stringArray.length; ++i) {
            FDSRecordProcessor fDSRecordProcessor = FDSRecordProcessorFactory.getProcessor(stringArray[i], fDSParsingInfo);
            if (fDSRecordProcessor == null) continue;
            linkedList.add(fDSRecordProcessor);
        }
        return linkedList;
    }

    private void collectNeededFDSTypesForProcessingRecursive(Set<String> set, Set<String> set2, FDSParsingInfo fDSParsingInfo) {
        for (String string : set) {
            set2.add(string);
            Set<String> set3 = FDSRecordProcessorFactory.getFDSTypesDependendedOn(string);
            this.collectNeededFDSTypesForProcessingRecursive(set3, set2, fDSParsingInfo);
        }
    }

    private static FDSInputRecord[] parse(CharSequence charSequence, String string) throws FDSRecordFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Object> vector = new Vector<Object>();
        String string2 = new String("(?://|!)[^\\r\\n]*");
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(charSequence);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            n = matcher.start();
            stringBuffer.append(charSequence.subSequence(n2, n).toString());
            n2 = matcher.end();
        }
        stringBuffer.append(charSequence.subSequence(n2, charSequence.length()).toString());
        string2 = new String("&([^/]*)/([^&\\n]*)");
        Pattern pattern2 = Pattern.compile(string2);
        matcher = pattern2.matcher(stringBuffer.toString());
        int n3 = 0;
        String string3 = charSequence.toString();
        int n4 = 0;
        String string4 = System.getProperty("line.separator");
        while (matcher.find()) {
            Object object;
            String string5 = matcher.group(1);
            String string6 = matcher.group(2).trim();
            int n5 = n3;
            int n6 = -1;
            int n7 = -1;
            int n8 = string3.indexOf(string5, n3);
            if (n8 >= 0) {
                int n9;
                n3 = n8 + string5.length();
                object = string3.substring(n5, n8);
                int n10 = 0;
                int n11 = 0;
                while ((n9 = ((String)object).indexOf(string4, n11)) >= 0) {
                    ++n10;
                    n11 = n9 + 1;
                }
                n6 = (n4 += n10) + 1;
                n11 = 0;
                n10 = 0;
                while ((n9 = string5.indexOf(string4, n11)) >= 0) {
                    ++n10;
                    n11 = n9 + 1;
                }
                n7 = (n4 += n10) + 1;
            }
            if (((FDSInputRecord)(object = new FDSInputRecord(string5, string6, new FDSInputRecordDebugInfo(string, string5, n6, n7)))).getType() == null) continue;
            vector.add(object);
        }
        return vector.toArray(new FDSInputRecord[vector.size()]);
    }

    private void process(FDSInputRecord[] fDSInputRecordArray, FDSRecordProcessor fDSRecordProcessor, HashSet<FDSInputRecord> hashSet) throws FDSRecordFormatException {
        for (int i = 0; i < fDSInputRecordArray.length; ++i) {
            if (!fDSRecordProcessor.process(fDSInputRecordArray[i])) continue;
            hashSet.remove(fDSInputRecordArray[i]);
        }
        fDSRecordProcessor.done();
    }

    private static Collection<Collection<IFDSRenderable>> collectAllFDSRenderableObjectsByType(PyroMod pyroMod, String string, Set<Class> set) {
        pyroMod.getRasterizations().rasterizeObjects();
        Collection<FDSObject> collection = pyroMod.getRasterizations().getFrags(true);
        Vector<Collection<IFDSRenderable>> vector = new Vector<Collection<IFDSRenderable>>(set.size());
        for (Class clazz : set) {
            IPyroManager iPyroManager = pyroMod.getPyroSimManager(clazz);
            if (FDSObject.class.isAssignableFrom(iPyroManager.getVClass())) {
                FilteredCollection filteredCollection = new FilteredCollection(collection, clazz);
                ArrayList arrayList = new ArrayList(collection.size() + iPyroManager.toCollection().size());
                arrayList.addAll(filteredCollection);
                arrayList.addAll(iPyroManager.toCollection());
                vector.add(arrayList);
                continue;
            }
            if (!IFDSRenderable.class.isAssignableFrom(clazz)) continue;
            vector.add(iPyroManager.toCollection());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTextures(TextureDB textureDB, File file, MaterialList materialList) {
        String string;
        TextureInfo textureInfo;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Material object : materialList) {
            textureInfo = object.getTextureInfo();
            if (textureInfo == null) continue;
            string = textureInfo.getTexID();
            treeSet.add(string);
        }
        for (String string2 : treeSet) {
            assert (textureDB.names().contains(string2));
            textureInfo = textureDB.getDefaultInfo(string2);
            if (textureInfo == null) continue;
            string = textureInfo.getTexID();
            Texture texture = textureDB.getTexture(string);
            File file2 = new File(file, string);
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            String string3 = string.substring(string.lastIndexOf(46) + 1);
            FileImageOutputStream fileImageOutputStream = null;
            try {
                fileImageOutputStream = new FileImageOutputStream(file2);
                ImageIO.write((RenderedImage)texture.getImage(), string3, fileImageOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (fileImageOutputStream == null) continue;
                    fileImageOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void copySprinklers(File file, File file2, SprkList sprkList) {
        for (SprkRecord sprkRecord : sprkList) {
            String string = sprkRecord.getMake() + ".spk";
            FilenameFilter filenameFilter = FDSInputFile.createFilter(file, string);
            List<File> list = IOUtil.listFiles(file, filenameFilter);
            if (list.size() != 1) {
                System.err.println("unable to find sprinkler db file: " + string);
                continue;
            }
            File file3 = list.get(0);
            File file4 = new File(file2, string);
            try {
                if (!file4.exists() && !file4.createNewFile()) {
                    IOException iOException = new IOException("unable to create destination file" + string);
                    throw iOException;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            try {
                FDSInputFile.copyFile(file3, file4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static FilenameFilter createFilter(final File file, final String string) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string2) {
                return file2.equals(file) && string2.equalsIgnoreCase(string);
            }
        };
    }

    private static void copyFile(File file, File file2) throws IOException {
        CopyFile.copy(file, file2);
    }

    public static void writeFile(String string, PyroMod pyroMod) throws IOException {
        FDSInputFile.writeFile(string, pyroMod, FDSInputFile.collectAllFDSRenderableObjectsByType(pyroMod, string, WRITE_RECS));
    }

    public static void writeFile(String string, PyroMod pyroMod, Collection<Collection<IFDSRenderable>> collection) throws IOException {
        File file = new File(string);
        String string2 = HeadRecord.getProperCHID(string);
        String string3 = string2 + ".ge1";
        File file2 = new File(file.getParentFile(), string3);
        boolean bl = GE1File.writeFile(file2.getAbsolutePath(), pyroMod);
        String string4 = null;
        if (bl) {
            pyroMod.pauseUpdates(false);
            string4 = pyroMod.getMiscManager().getMiscRecord().getRenderFile();
            pyroMod.getMiscManager().getMiscRecord().setRenderFile(string3);
            pyroMod.resumeUpdates();
        }
        String string5 = string2 + ".ini";
        File file3 = new File(file.getParentFile(), string5);
        FDSInputFile.writeSmokeViewIni(file3, bl);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println(file.getName());
        printWriter.println("Generated by PyroSim (c) 2002-2006");
        printWriter.println(DateFormat.getDateTimeInstance().format(new Date()));
        printWriter.println();
        String string6 = pyroMod.getUnprocessedRecords();
        if (string6 != null && string6.length() > 0) {
            printWriter.println("-------------User Section (not generated by PyroSim)-------------");
            printWriter.println();
            printWriter.print(string6);
            printWriter.println();
            printWriter.println();
        }
        printWriter.println("--------------------PyroSim-generated Section--------------------");
        printWriter.println();
        printWriter.println(FDSInputFile.renderPyroRecords(pyroMod, string, collection));
        printWriter.println();
        printWriter.close();
        if (bl) {
            pyroMod.pauseUpdates(false);
            pyroMod.getMiscManager().getMiscRecord().setRenderFile(string4);
            pyroMod.resumeUpdates();
        }
    }

    private static void writeSmokeViewIni(File file, boolean bl) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        if (bl) {
            FDSInputFile.writeSVINIPref(printWriter, "BLOCKLOCATION", 5);
        }
        FDSInputFile.writeSVINIPref(printWriter, "SHOWNORMALWHENSMOOTH", 1);
        printWriter.close();
    }

    private static void writeSVINIPref(PrintWriter printWriter, String string, Object object) {
        printWriter.println(string);
        printWriter.println(object.toString());
    }

    private static void writeGE1File(String string, PyroMod pyroMod) throws IOException {
    }

    public static String renderAllPyroRecords(PyroMod pyroMod, String string) {
        return FDSInputFile.renderPyroRecords(pyroMod, string, FDSInputFile.collectAllFDSRenderableObjectsByType(pyroMod, string, WRITE_RECS));
    }

    public static String renderPyroRecords(PyroMod pyroMod, String string, Collection<Collection<IFDSRenderable>> collection) {
        Collection collection22;
        pyroMod.pauseUpdates(false);
        String string2 = pyroMod.getHeadManager().getHeadRecord().getCHID();
        pyroMod.getHeadManager().getHeadRecord().setCHID(string);
        pyroMod.resumeUpdates();
        Collection collection3 = pyroMod.getDependencyManager().collectObjects(collection);
        TreeMap<String, Vector<IFDSRenderable>> treeMap = new TreeMap<String, Vector<IFDSRenderable>>();
        for (Collection collection22 : collection3) {
            if (collection22.size() == 0) continue;
            IFDSRenderable iFDSRenderable = (IFDSRenderable)collection22.iterator().next();
            Vector<IFDSRenderable> vector = (Vector<IFDSRenderable>)treeMap.get(iFDSRenderable.getFDSType());
            if (vector == null) {
                vector = new Vector<IFDSRenderable>(collection22.size());
                treeMap.put(iFDSRenderable.getFDSType(), vector);
            }
            vector.addAll(collection22);
        }
        StringBuffer stringBuffer = new StringBuffer();
        collection22 = treeMap.keySet().iterator();
        for (Vector<IFDSRenderable> vector : treeMap.values()) {
            String string3 = (String)collection22.next();
            Vector<FDSInputRecord> vector2 = new Vector<FDSInputRecord>();
            FDSInputFile.collectInputRecords(vector, vector2);
            FDSInputFile.renderPyroRecords(vector2, string3, stringBuffer);
        }
        pyroMod.pauseUpdates(false);
        pyroMod.getHeadManager().getHeadRecord().setCHID(string2);
        pyroMod.resumeUpdates();
        return stringBuffer.toString();
    }

    private static void collectInputRecords(Collection<IFDSRenderable> collection, Collection<FDSInputRecord> collection2) {
        for (IFDSRenderable iFDSRenderable : collection) {
            iFDSRenderable.getInputRecords(collection2);
        }
    }

    private static void renderPyroRecords(Collection<FDSInputRecord> collection, String string, StringBuffer stringBuffer) {
        if (collection.isEmpty()) {
            return;
        }
        String string2 = System.getProperty("line.separator");
        for (FDSInputRecord fDSInputRecord : collection) {
            stringBuffer.append(FDSInputFile.renderRecord(fDSInputRecord));
        }
        stringBuffer.append(string2);
    }

    public static String renderRecord(FDSInputRecord fDSInputRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fDSInputRecord.getValue("DISABLED") != null) {
            stringBuffer.append("//");
        }
        stringBuffer.append(REC_START_CHAR);
        stringBuffer.append(fDSInputRecord.getType());
        String[] stringArray = fDSInputRecord.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i] + "=");
            stringBuffer.append(FDSInputFile.renderValue(fDSInputRecord.getValue(stringArray[i])));
        }
        stringBuffer.append(REC_END_CHAR);
        String string = fDSInputRecord.getComment();
        if (string != null) {
            stringBuffer.append(" " + string);
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    private static String renderUnprocessedRecords(Collection<FDSInputRecord> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (FDSInputRecord fDSInputRecord : collection) {
            stringBuffer.append(FDSInputFile.renderUnprocRecord(fDSInputRecord));
        }
        return stringBuffer.toString();
    }

    private static String renderUnprocRecord(FDSInputRecord fDSInputRecord) {
        if (fDSInputRecord.getDebugInfo() == null) {
            return FDSInputFile.renderRecord(fDSInputRecord);
        }
        return REC_START_CHAR + fDSInputRecord.getDebugInfo().getOriginalText() + REC_END_CHAR + System.getProperty("line.separator");
    }

    public static String renderRecords(FDSInputRecord[] fDSInputRecordArray) {
        return FDSInputFile.renderRecords(Arrays.asList(fDSInputRecordArray));
    }

    public static String renderRecords(Collection<FDSInputRecord> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (FDSInputRecord fDSInputRecord : collection) {
            stringBuffer.append(FDSInputFile.renderRecord(fDSInputRecord));
        }
        return stringBuffer.toString();
    }

    private static String renderValue(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(FDSInputFile.renderValue(vector.get(i)));
            }
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                stringBuffer.append(".TRUE.");
            } else {
                stringBuffer.append(".FALSE.");
            }
        } else if (object instanceof String) {
            stringBuffer.append("'" + object.toString() + "'");
        } else if (object instanceof Double) {
            if (!d_easyReadFormat) {
                d_doubleFormat.applyPattern("0.000000E000");
            } else {
                double d = (Double)object;
                if (Math.abs(d) >= 0.01 && Math.abs(d) <= 0.4999) {
                    d_doubleFormat.applyPattern("0.0000");
                } else if (Math.abs(d) >= 0.5 && Math.abs(d) <= 999.0 || d == 0.0) {
                    d_doubleFormat.applyPattern("0.00");
                } else {
                    d_doubleFormat.applyPattern("0.000000E000");
                }
            }
            String string = d_doubleFormat.format((Double)object);
            stringBuffer.append(string);
        } else if (object instanceof Integer) {
            stringBuffer.append(object.toString());
        } else {
            throw new IllegalArgumentException("Unknown value type: " + object.getClass().getName());
        }
        return stringBuffer.toString();
    }

    static {
        d_easyReadFormat = false;
        d_doubleFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        d_doubleFormat.applyPattern("0.000000E000");
        WRITE_RECS = new HashSet<Class>();
        WRITE_RECS.add(FDSComposite.class);
        WRITE_RECS.add(AlignedBlock.class);
        WRITE_RECS.add(FDSConvexPoly.class);
        WRITE_RECS.add(Wall.class);
        WRITE_RECS.add(AlignedHole.class);
        WRITE_RECS.add(Hole.class);
        WRITE_RECS.add(Vent.class);
        WRITE_RECS.add(Slab.class);
        WRITE_RECS.add(BNDFRecord.class);
        WRITE_RECS.add(Grid.class);
        WRITE_RECS.add(HeadRecord.class);
        WRITE_RECS.add(IsofRecord.class);
        WRITE_RECS.add(PyroMod.MiscRecord.class);
        WRITE_RECS.add(RadiRecord.class);
        WRITE_RECS.add(PipeRecord.class);
        WRITE_RECS.add(PL3DRecord.class);
        WRITE_RECS.add(SlcfRecord.class);
        WRITE_RECS.add(SprkRecord.class);
        WRITE_RECS.add(ThcpRecord.class);
        WRITE_RECS.add(PyroMod.TimeRecord.class);
        WRITE_RECS.add(Floor.class);
        WRITE_RECS.add(SmodRecord.class);
        WRITE_RECS.add(HeatDetector.class);
    }
}

