/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class EventParser {
    public static Activatable getCorrectObject(Map map, Activatable activatable) {
        Activatable activatable2;
        Activatable activatable3 = activatable;
        if (map.size() > 0 && (activatable2 = (Activatable)map.get(activatable.getPropertyHashString())) != null) {
            activatable3 = activatable2;
        }
        return activatable3;
    }

    public static void parseEvents(AFDSRecordProcessor aFDSRecordProcessor, Activatable activatable, FDSInputRecord fDSInputRecord, String[] stringArray, String[] stringArray2, String string, String string2, HeatDetectorList heatDetectorList) throws FDSRecordFormatException, ClassCastException {
        HeatDetector heatDetector;
        int n;
        Object object;
        int n2;
        Unit unit = FdsSISystem.getInstance().getTimeUnit();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = (Double)fDSInputRecord.getValue(stringArray[n2]);
            if (object == null) continue;
            if ((Double)object >= 0.0) {
                activatable.addEvent(new TimeActivationEvent(new UnitDouble((Double)object, unit), 0));
                continue;
            }
            n = Math.abs(((Double)object).intValue()) - 1;
            heatDetector = heatDetectorList.getAt(n);
            if (heatDetector == null) {
                activatable.setCanBeTriggeredByAnyHeatDetector(true, 0);
                continue;
            }
            activatable.addEvent(new HeatActivationEvent(heatDetector, 0));
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            object = (Double)fDSInputRecord.getValue(stringArray2[n2]);
            if (object == null) continue;
            if ((Double)object >= 0.0) {
                activatable.addEvent(new TimeActivationEvent(new UnitDouble((Double)object, unit), 1));
                continue;
            }
            n = Math.abs(((Double)object).intValue()) - 1;
            heatDetector = heatDetectorList.getAt(n);
            if (heatDetector == null) {
                activatable.setCanBeTriggeredByAnyHeatDetector(true, 1);
                continue;
            }
            activatable.addEvent(new HeatActivationEvent(heatDetector, 1));
        }
        String string3 = (String)fDSInputRecord.getValue(string);
        if (string3 != null) {
            if (string3.equals("ALL")) {
                activatable.setCanBeTriggeredByAnyHeatDetector(true, 0);
            } else {
                object = aFDSRecordProcessor.getResource(string3, HeatDetector.class);
                if (object == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "The heat detector, \"" + string3 + ",\" does not exist in the model.");
                }
                activatable.addEvent(new HeatActivationEvent((HeatDetector)object, 0));
            }
        }
        if ((object = (String)fDSInputRecord.getValue(string2)) != null) {
            if (((String)object).equals("ALL")) {
                activatable.setCanBeTriggeredByAnyHeatDetector(true, 1);
            } else {
                HeatDetector heatDetector2 = aFDSRecordProcessor.getResource(object, HeatDetector.class);
                if (heatDetector2 == null) {
                    throw new FDSRecordFormatException(fDSInputRecord, "The heat detector, \"" + (String)object + ",\" does not exist in the model.");
                }
                activatable.addEvent(new HeatActivationEvent(heatDetector2, 1));
            }
        }
    }
}

