/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.TreeSet;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantity;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantityParam;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class BNDFProcessor
extends AFDSRecordProcessor {
    private TreeSet<UnitDouble> d_sortedDTSams = new TreeSet();

    public BNDFProcessor(FDSParsingInfo fDSParsingInfo) {
        super(fDSParsingInfo);
        for (PyroMod pyroMod : this.getSourceContainers()) {
            for (BNDFRecord bNDFRecord : pyroMod.getBNDFList()) {
                if (bNDFRecord.getDTSam() == null) continue;
                this.d_sortedDTSams.add(bNDFRecord.getDTSam());
            }
        }
    }

    @Override
    public String getFDSTypeParsed() {
        return "BNDF";
    }

    @Override
    public boolean process(FDSInputRecord fDSInputRecord) throws FDSRecordFormatException {
        boolean bl = false;
        FDSRecordFormatException fDSRecordFormatException = null;
        if (!"BNDF".equals(fDSInputRecord.getType())) {
            return false;
        }
        try {
            Object object;
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            UnitDouble unitDouble = fDSInputRecord.extractDouble("DTSAM", fdsSISystem.getTimeUnit(), null, (UnitDoubleValueRange)BNDFRecord.getValueRange("DTSAM"));
            if (unitDouble != null) {
                this.d_sortedDTSams.add(unitDouble);
            }
            if ((object = fDSInputRecord.getValue("QUANTITY")) == null) {
                throw new FDSRecordFormatException(fDSInputRecord, "The BNDF record requires that a quantity be specified.");
            }
            if (!(object instanceof String)) {
                throw new FDSRecordFormatException(fDSInputRecord, "QUANTITY must be a String.");
            }
            SolidPhaseQuantitiesList solidPhaseQuantitiesList = new SolidPhaseQuantitiesList();
            String string = (String)object;
            if (!solidPhaseQuantitiesList.contains(string) || string.equals(SolidPhaseQuantitiesList.INSIDE_WALL_TEMPERATURE.getName())) {
                throw new FDSRecordFormatException(fDSInputRecord, string + " is not a valid BNDF quantity.");
            }
            BNDFRecord bNDFRecord = new BNDFRecord(null, string);
            SolidPhaseQuantity[] solidPhaseQuantityArray = solidPhaseQuantitiesList.getAllQuantities();
            for (int i = 0; i < solidPhaseQuantityArray.length; ++i) {
                String string2 = solidPhaseQuantityArray[i].getName();
                if (!string.equals(string2)) continue;
                SolidPhaseQuantityParam[] solidPhaseQuantityParamArray = solidPhaseQuantityArray[i].getParams();
                for (int j = 0; j < solidPhaseQuantityParamArray.length; ++j) {
                    Object object2 = fDSInputRecord.getValue(solidPhaseQuantityParamArray[j].getName());
                    if (object2 == null) continue;
                    if (!(object2 instanceof Double)) {
                        throw new FDSRecordFormatException(fDSInputRecord, solidPhaseQuantityParamArray[j].getName() + " must a Real number.");
                    }
                    Double d = (Double)object2;
                    bNDFRecord.setExtraParam(solidPhaseQuantityParamArray[j].getName(), new UnitDouble(d, fdsSISystem.getUnit(solidPhaseQuantityParamArray[j].getUnitType())), solidPhaseQuantityParamArray[j].getUnitType());
                }
                break;
            }
            this.getContainer().getBNDFList().taskAdd(bNDFRecord).run();
            this.getContainer().getBNDFList().setOutputEnabled(true);
            this.flagPyroTypeAffected(BNDFRecord.class);
        }
        catch (FDSRecordFormatException fDSRecordFormatException2) {
            fDSRecordFormatException = fDSRecordFormatException2;
            bl = true;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (fDSRecordFormatException != null) {
                throw fDSRecordFormatException;
            }
            throw new FDSRecordFormatException(fDSInputRecord, "An unknown error occured.");
        }
        return true;
    }

    @Override
    public void done() {
        UnitDouble unitDouble;
        Cloneable cloneable;
        BNDFList bNDFList = this.getContainer().getBNDFList();
        BNDFRecord bNDFRecord = bNDFList.get(SolidPhaseQuantitiesList.PRESSURE_COEFFICIENT.getName());
        if (bNDFRecord != null) {
            cloneable = this.getContainer().getMiscManager().getMiscRecord().getCharVel();
            bNDFRecord.setExtraParam("CHARACTERISTIC_VELOCITY", (UnitDouble)cloneable, 8);
        }
        if ((cloneable = bNDFList.get(SolidPhaseQuantitiesList.GAUGE_HEAT_FLUX.getName())) != null) {
            unitDouble = this.getContainer().getMiscManager().getMiscRecord().getGaugeTemp();
            ((BNDFRecord)cloneable).setExtraParam("GAUGE_TEMPERATURE", unitDouble, 1);
        }
        if (this.d_sortedDTSams.size() > 0) {
            unitDouble = this.d_sortedDTSams.first();
            for (BNDFRecord bNDFRecord2 : bNDFList) {
                bNDFRecord2.setDTSam(unitDouble);
            }
        }
    }
}

