/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import pyrosim.Intl;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParseWarning;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;

public abstract class AFDSRecordProcessor
implements FDSRecordProcessor {
    private FDSParsingInfo d_parsingInfo;

    public AFDSRecordProcessor(FDSParsingInfo fDSParsingInfo) {
        this.d_parsingInfo = fDSParsingInfo;
    }

    @Override
    public PyroMod getContainer() {
        return this.d_parsingInfo.getContainer();
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_parsingInfo.getSourceContainers();
    }

    @Override
    public FDSParsingInfo getParsingInfo() {
        return this.d_parsingInfo;
    }

    public void flagPyroTypeAffected(Class clazz) {
        this.d_parsingInfo.getPyroObjectTypesAffected().add(clazz);
    }

    public <K, V extends IPyroObject> V getResource(K k, Class<V> clazz) {
        return this.d_parsingInfo.getResource(k, clazz);
    }

    public <K, V extends IPyroObject> boolean resourceExists(K k, Class<V> clazz) {
        return this.d_parsingInfo.resourceExists(k, clazz);
    }

    public <K, V extends IPyroObject> void makeUnique(V v, Class<V> clazz) {
        this.d_parsingInfo.makeUnique(v, clazz);
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_parsingInfo.addWarning(fDSParseWarning);
    }

    public void addWarning(FDSInputRecord fDSInputRecord, String string, String string2) {
        int n = 0;
        String string3 = "";
        if (fDSInputRecord != null) {
            n = fDSInputRecord.getDebugInfo().getBeginLineNum();
            string3 = fDSInputRecord.getDebugInfo().getOriginalText();
        }
        this.d_parsingInfo.addWarning(new FDSParseWarning(n, string, string2, string3));
    }

    private float clamp(FDSInputRecord fDSInputRecord, float f) {
        if (f < 0.0f || f > 1.0f) {
            this.addWarning(fDSInputRecord, String.format(Intl.intl("Color component out of range: %f"), Float.valueOf(f)), Intl.intl("Clamping component to 0-1"));
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    protected Color parseColor(FDSInputRecord fDSInputRecord) {
        Vector vector = (Vector)fDSInputRecord.getValue("RGB");
        if (vector != null) {
            float f = this.clamp(fDSInputRecord, ((Double)vector.get(0)).floatValue());
            float f2 = this.clamp(fDSInputRecord, ((Double)vector.get(1)).floatValue());
            float f3 = this.clamp(fDSInputRecord, ((Double)vector.get(2)).floatValue());
            return new Color(f, f2, f3);
        }
        return null;
    }
}

