/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;

public class Triangle
implements Primitive,
Serializable {
    static final long serialVersionUID = 1L;
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props;

    public Triangle(Point3d[] point3dArray, Vector3d vector3d, PrimProps primProps) {
        assert (point3dArray.length == 3);
        this.d_points = point3dArray;
        this.d_props = primProps;
        this.d_normal = vector3d == null ? Geometry.calcNormal(point3dArray[0], point3dArray[1], point3dArray[2]) : vector3d;
    }

    public Triangle(Point3d[] point3dArray, PrimProps primProps) {
        this(point3dArray, null, primProps);
    }

    public Triangle(Point3d point3d, Point3d point3d2, Point3d point3d3, PrimProps primProps) {
        this(point3d, point3d2, point3d3, null, primProps);
    }

    public Triangle(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, PrimProps primProps) {
        this(new Point3d[]{point3d, point3d2, point3d3}, vector3d, primProps);
    }

    public int getNumPoints() {
        return 3;
    }

    public Point3d getPoint(int n) {
        assert (n < 3 && n >= 0);
        return this.d_points[n];
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps primProps) {
        this.d_props = primProps;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }
}

