/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class Quad
implements Serializable,
Cloneable,
Primitive {
    static final long serialVersionUID = 1L;
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props = new PrimProps();

    public Quad(double[] dArray, PrimProps primProps) {
        this(dArray, null, primProps);
    }

    public Quad(double[] dArray, Vector3d vector3d, PrimProps primProps) {
        if (dArray.length != 12) {
            throw new IllegalArgumentException("This Quad construction requires 12 coordinates (p0.x, p0.y, p0.z, p1.x, ..., p3.z).");
        }
        this.init(new Point3d[]{new Point3d(dArray[0], dArray[1], dArray[2]), new Point3d(dArray[3], dArray[4], dArray[5]), new Point3d(dArray[6], dArray[7], dArray[8]), new Point3d(dArray[9], dArray[10], dArray[11])}, vector3d, primProps);
    }

    public Quad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, PrimProps primProps) {
        this.init(new Point3d[]{point3d, point3d2, point3d3, point3d4}, null, primProps);
    }

    public Quad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Vector3d vector3d, PrimProps primProps) {
        this.init(new Point3d[]{point3d, point3d2, point3d3, point3d4}, vector3d, primProps);
    }

    public Quad(Point3d[] point3dArray, PrimProps primProps) {
        this.init(point3dArray, null, primProps);
    }

    public Quad(Point3d[] point3dArray, Vector3d vector3d, PrimProps primProps) {
        this.init(point3dArray, vector3d, primProps);
    }

    private void init(Point3d[] point3dArray, Vector3d vector3d, PrimProps primProps) {
        if (point3dArray.length != 4) {
            throw new IllegalArgumentException("Quad must have 4 points.");
        }
        this.d_points = point3dArray;
        this.d_normal = vector3d != null ? vector3d : Geometry.calcNormal(point3dArray[0], point3dArray[1], point3dArray[2]);
        this.d_props = primProps;
    }

    public static Quad fromLegacy(pyrosim.legacy_2006_2.legacy.v17.Quad quad) {
        Point3d[] point3dArray = new Point3d[4];
        for (int i = 0; i < 4; ++i) {
            Point3D point3D = quad.getPoint(i);
            point3dArray[i] = new Point3d(point3D.x, point3D.y, point3D.z);
        }
        Quad quad2 = new Quad(point3dArray, new PrimProps(null, quad.getColor()));
        return quad2;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)object;
        Point3d point3d = this.getPoint(0);
        for (n = 0; n < 4 && !point3d.equals(quad.getPoint(n)); ++n) {
        }
        if (n >= 4) {
            return false;
        }
        int n2 = n;
        for (n = 1; n < 4; ++n) {
            if (this.getPoint(n).equals(quad.getPoint((n + n2) % 4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }

    public boolean isParallelZ() {
        return this.getPoint((int)0).z == this.getPoint((int)1).z && this.getPoint((int)0).z == this.getPoint((int)2).z && this.getPoint((int)0).z == this.getPoint((int)3).z;
    }

    public boolean isParallelX() {
        return this.getPoint((int)0).x == this.getPoint((int)1).x && this.getPoint((int)0).x == this.getPoint((int)2).x && this.getPoint((int)0).x == this.getPoint((int)3).x;
    }

    public boolean isParallelY() {
        return this.getPoint((int)0).y == this.getPoint((int)1).y && this.getPoint((int)0).y == this.getPoint((int)2).y && this.getPoint((int)0).y == this.getPoint((int)3).y;
    }

    public Point3d getPoint(int n) {
        return this.d_points[n];
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    public void setPoints(Point3d[] point3dArray) {
        this.d_points = point3dArray;
        this.d_normal = Geometry.calcNormal(point3dArray[0], point3dArray[1], point3dArray[2]);
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps primProps) {
        this.d_props = primProps;
    }

    public void translate(double d, double d2, double d3) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += d;
            this.d_points[i].y += d2;
            this.d_points[i].z += d3;
        }
    }

    public void flipNormal() {
        Point3d point3d = this.d_points[1];
        this.d_points[1] = this.d_points[3];
        this.d_points[3] = point3d;
    }

    public Prism extrudeAlongNormal(double d) {
        double d2 = d * 0.5;
        double d3 = this.d_points[0].x;
        double d4 = this.d_points[2].x;
        double d5 = this.d_points[0].y;
        double d6 = this.d_points[2].y;
        double d7 = this.d_points[0].z;
        double d8 = this.d_points[2].z;
        if (this.isParallelX()) {
            d3 -= d2;
            d4 += d2;
        } else if (this.isParallelY()) {
            d5 -= d2;
            d6 += d2;
        } else if (this.isParallelZ()) {
            d7 -= d2;
            d8 += d2;
        }
        return new Prism(d3, d4, d5, d6, d7, d8);
    }

    public Object clone() {
        try {
            Quad quad = (Quad)super.clone();
            quad.d_points = new Point3d[]{new Point3d(this.d_points[0].x, this.d_points[0].y, this.d_points[0].z), new Point3d(this.d_points[1].x, this.d_points[1].y, this.d_points[1].z), new Point3d(this.d_points[2].x, this.d_points[2].y, this.d_points[2].z), new Point3d(this.d_points[3].x, this.d_points[3].y, this.d_points[3].z)};
            quad.d_normal = (Vector3d)this.d_normal.clone();
            quad.d_props = this.d_props != null ? (PrimProps)this.d_props.clone() : null;
            return quad;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }
}

