/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.BoundingBox3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Prism
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    boolean d_axisAligned;
    private Point3d[] d_points;
    private Material[] d_materials;
    private Color d_color;

    private Prism() {
        this.d_points = new Point3d[8];
    }

    public Prism(double d, double d2, double d3, double d4, double d5, double d6) {
        this.d_points = new Point3d[8];
        this.d_points[0] = new Point3d(d, d3, d5);
        this.d_points[1] = new Point3d(d2, d3, d5);
        this.d_points[2] = new Point3d(d2, d4, d5);
        this.d_points[3] = new Point3d(d, d4, d5);
        this.d_points[4] = new Point3d(d, d3, d6);
        this.d_points[5] = new Point3d(d2, d3, d6);
        this.d_points[6] = new Point3d(d2, d4, d6);
        this.d_points[7] = new Point3d(d, d4, d6);
        this.d_axisAligned = true;
    }

    public Prism(Point3d[] point3dArray) {
        if (point3dArray.length != 8) {
            throw new IllegalArgumentException("Array must have 8 points.");
        }
        this.d_points = point3dArray;
        this.d_axisAligned = false;
    }

    public Prism(Point3D point3D, Point3D point3D2) {
        this(point3D.x, point3D2.x, point3D.y, point3D2.y, point3D.z, point3D2.z);
    }

    public static Prism fromLegacy(pyrosim.legacy_2006_2.legacy.v17.Prism prism) {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        for (int i = 0; i < 8; ++i) {
            Point3D point3D = prism.getPoint(i);
            boundingBox3D.add(new Point3d(point3D.x, point3D.y, point3D.z));
        }
        return new Prism(boundingBox3D.getMin().x, boundingBox3D.getMin().y, boundingBox3D.getMin().z, boundingBox3D.getMax().x, boundingBox3D.getMax().y, boundingBox3D.getMax().z);
    }

    public Object clone() {
        Prism prism = new Prism();
        for (int i = 0; i < 8; ++i) {
            prism.d_points[i] = new Point3d(this.d_points[i].x, this.d_points[i].y, this.d_points[i].z);
        }
        if (this.d_materials != null) {
            prism.d_materials = new Material[this.d_materials.length];
            System.arraycopy(this.d_materials, 0, prism.d_materials, 0, this.d_materials.length);
        }
        return prism;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Prism)) {
            return false;
        }
        return Arrays.equals(this.d_points, ((Prism)object).d_points) && Arrays.equals(this.d_materials, ((Prism)object).d_materials);
    }

    public void translate(double d, double d2, double d3) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += d;
            this.d_points[i].y += d2;
            this.d_points[i].z += d3;
        }
    }

    public void mirror(int n, UnitDouble unitDouble) {
    }

    public Point3d getPoint(int n) {
        return this.d_points[n];
    }

    public Material getMaterial(int n) {
        return this.d_materials[n];
    }

    public void setMaterial(Material material) {
        this.setMaterials(new Material[]{material, material, material, material, material, material});
    }

    public void setMaterials(Material[] materialArray) {
        if (materialArray.length != 6) {
            throw new IllegalArgumentException();
        }
        this.d_materials = materialArray;
    }

    public void setColor(Color color) {
        this.d_color = color;
    }

    public Color getColor() {
        return this.d_color;
    }

    public Quad getFace(int n) {
        PrimProps primProps = new PrimProps();
        if (this.d_materials != null) {
            primProps.setMaterial(this.d_materials[n]);
        }
        primProps.setColor(this.getColor());
        Vector3d vector3d = Prism.getNormal(this.d_axisAligned, n);
        Quad quad = null;
        switch (n) {
            case 0: {
                quad = new Quad(this.getPoint(3), this.getPoint(0), this.getPoint(4), this.getPoint(7), vector3d, primProps);
                break;
            }
            case 1: {
                quad = new Quad(this.getPoint(1), this.getPoint(2), this.getPoint(6), this.getPoint(5), vector3d, primProps);
                break;
            }
            case 2: {
                quad = new Quad(this.getPoint(0), this.getPoint(1), this.getPoint(5), this.getPoint(4), vector3d, primProps);
                break;
            }
            case 3: {
                quad = new Quad(this.getPoint(2), this.getPoint(3), this.getPoint(7), this.getPoint(6), vector3d, primProps);
                break;
            }
            case 4: {
                quad = new Quad(this.getPoint(3), this.getPoint(2), this.getPoint(1), this.getPoint(0), vector3d, primProps);
                break;
            }
            case 5: {
                quad = new Quad(this.getPoint(4), this.getPoint(5), this.getPoint(6), this.getPoint(7), vector3d, primProps);
                break;
            }
            default: {
                return null;
            }
        }
        return quad;
    }

    public static Quad getFaceForBox(Point3D point3D, Point3D point3D2, int n, PrimProps primProps) {
        Vector3d vector3d = Prism.getNormal(true, n);
        Quad quad = null;
        switch (n) {
            case 0: {
                quad = new Quad(new Point3d(point3D.x, point3D2.y, point3D.z), new Point3d(point3D.x, point3D.y, point3D.z), new Point3d(point3D.x, point3D.y, point3D2.z), new Point3d(point3D.x, point3D2.y, point3D2.z), vector3d, primProps);
                break;
            }
            case 1: {
                quad = new Quad(new Point3d(point3D2.x, point3D.y, point3D.z), new Point3d(point3D2.x, point3D2.y, point3D.z), new Point3d(point3D2.x, point3D2.y, point3D2.z), new Point3d(point3D2.x, point3D.y, point3D2.z), vector3d, primProps);
                break;
            }
            case 2: {
                quad = new Quad(new Point3d(point3D.x, point3D.y, point3D.z), new Point3d(point3D2.x, point3D.y, point3D.z), new Point3d(point3D2.x, point3D.y, point3D2.z), new Point3d(point3D.x, point3D.y, point3D2.z), vector3d, primProps);
                break;
            }
            case 3: {
                quad = new Quad(new Point3d(point3D2.x, point3D2.y, point3D.z), new Point3d(point3D.x, point3D2.y, point3D.z), new Point3d(point3D.x, point3D2.y, point3D2.z), new Point3d(point3D2.x, point3D2.y, point3D2.z), vector3d, primProps);
                break;
            }
            case 4: {
                quad = new Quad(new Point3d(point3D.x, point3D2.y, point3D.z), new Point3d(point3D2.x, point3D2.y, point3D.z), new Point3d(point3D2.x, point3D.y, point3D.z), new Point3d(point3D.x, point3D.y, point3D.z), vector3d, primProps);
                break;
            }
            case 5: {
                quad = new Quad(new Point3d(point3D.x, point3D.y, point3D2.z), new Point3d(point3D2.x, point3D.y, point3D2.z), new Point3d(point3D2.x, point3D2.y, point3D2.z), new Point3d(point3D.x, point3D2.y, point3D2.z), vector3d, primProps);
                break;
            }
            default: {
                return null;
            }
        }
        return quad;
    }

    private static Vector3d getNormal(boolean bl, int n) {
        if (!bl) {
            return null;
        }
        switch (n) {
            case 0: {
                return Geometry.VEC3D_XNEG;
            }
            case 1: {
                return Geometry.VEC3D_XPOS;
            }
            case 2: {
                return Geometry.VEC3D_YNEG;
            }
            case 3: {
                return Geometry.VEC3D_YPOS;
            }
            case 4: {
                return Geometry.VEC3D_ZNEG;
            }
            case 5: {
                return Geometry.VEC3D_ZPOS;
            }
        }
        return null;
    }
}

