/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;

public class Polygon
implements Primitive {
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props = new PrimProps();

    public Polygon(PrimProps primProps, Point3d ... point3dArray) {
        this.init(point3dArray, null, primProps);
    }

    public Polygon(Vector3d vector3d, PrimProps primProps, Point3d ... point3dArray) {
        this.init(point3dArray, vector3d, primProps);
    }

    private void init(Point3d[] point3dArray, Vector3d vector3d, PrimProps primProps) {
        assert (point3dArray.length >= 3);
        this.d_points = point3dArray;
        this.d_normal = vector3d != null ? vector3d : Geometry.calcNormal(point3dArray[0], point3dArray[1], point3dArray[2]);
        this.d_props = primProps;
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps primProps) {
        this.d_props = primProps;
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }
}

