/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.geom.Line;
import pyrosim.legacy_2006_2.geom.Point;
import pyrosim.legacy_2006_2.geom.Primitive;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.BoundingBox3D;

public class Geometry
implements Serializable {
    static final long serialVersionUID = 1L;
    private Collection<Quad> d_quads = new ArrayList<Quad>();
    private Collection<Triangle> d_tris = new ArrayList<Triangle>();
    private Collection<Line> d_lines = new ArrayList<Line>();
    private Collection<Point> d_points = new ArrayList<Point>();
    public static final Unit GEOM_LENGTH_UNIT = SI.METER;
    public static final Unit GEOM_ANGLE_UNIT = NonSI.DEGREE_ANGLE;
    public static final Tuple3d TUP3D_ZERO = new Point3d(0.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XPOS = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XNEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_YPOS = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d VEC3D_YNEG = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d VEC3D_ZPOS = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d VEC3D_ZNEG = new Vector3d(0.0, 0.0, -1.0);
    public static final Point3d PNT3D_XPOS = new Point3d(1.0, 0.0, 0.0);
    public static final Point3d PNT3D_XNEG = new Point3d(-1.0, 0.0, 0.0);
    public static final Point3d PNT3D_YPOS = new Point3d(0.0, 1.0, 0.0);
    public static final Point3d PNT3D_YNEG = new Point3d(0.0, -1.0, 0.0);
    public static final Point3d PNT3D_ZPOS = new Point3d(0.0, 0.0, 1.0);
    public static final Point3d PNT3D_ZNEG = new Point3d(0.0, 0.0, -1.0);

    public void addPrism(Prism prism) {
        this.addQuadsFromPrism(prism);
    }

    public void addPrisms(Collection<Prism> collection) {
        for (Prism prism : collection) {
            this.addPrism(prism);
        }
    }

    private void addQuadsFromPrism(Prism prism) {
        for (int i = 0; i < 6; ++i) {
            this.addQuad(prism.getFace(i));
        }
    }

    public void addQuad(Quad quad) {
        this.d_quads.add(quad);
    }

    public void addQuads(Collection<Quad> collection) {
        for (Quad quad : collection) {
            this.addQuad(quad);
        }
    }

    public void addTriangle(Triangle triangle) {
        this.d_tris.add(triangle);
    }

    public void addTriangles(Collection<Triangle> collection) {
        for (Triangle triangle : collection) {
            this.addTriangle(triangle);
        }
    }

    public void addLine(Line line) {
        this.d_lines.add(line);
    }

    public void addLines(Collection<Line> collection) {
        for (Line line : collection) {
            this.addLine(line);
        }
    }

    public void addPoint(Point point) {
        this.d_points.add(point);
    }

    public void addPoints(Collection<Point> collection) {
        this.d_points.addAll(collection);
    }

    public void addGeometry(Geometry geometry) {
        this.d_quads.addAll(geometry.getQuads());
        this.d_tris.addAll(geometry.getTriangles());
        this.d_lines.addAll(geometry.getLines());
        this.d_points.addAll(geometry.getPoints());
    }

    public void clear() {
        this.d_quads.clear();
        this.d_lines.clear();
        this.d_tris.clear();
        this.d_points.clear();
    }

    public Collection<Quad> getQuads() {
        return this.d_quads;
    }

    public Collection<Triangle> getTriangles() {
        return this.d_tris;
    }

    public Collection<Line> getLines() {
        return this.d_lines;
    }

    public Collection<Point> getPoints() {
        return this.d_points;
    }

    public BoundingBox3D getBounds() {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        this.addPoints(boundingBox3D, this.d_quads);
        this.addPoints(boundingBox3D, this.d_tris);
        this.addPoints(boundingBox3D, this.d_lines);
        this.addPoints(boundingBox3D, this.d_points);
        return boundingBox3D;
    }

    private void addPoints(BoundingBox3D boundingBox3D, Collection<? extends Primitive> collection) {
        for (Primitive primitive : collection) {
            for (Point3d point3d : primitive.getPoints()) {
                boundingBox3D.add(point3d);
            }
        }
    }

    public Point3D getMinPoint() {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        this.addPointsForMin(boundingBox3D, this.d_quads);
        this.addPointsForMin(boundingBox3D, this.d_tris);
        this.addPointsForMin(boundingBox3D, this.d_lines);
        this.addPointsForMin(boundingBox3D, this.d_points);
        return new Point3D(boundingBox3D.getMin());
    }

    public Point3D getMaxPoint() {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        this.addPointsForMax(boundingBox3D, this.d_quads);
        this.addPointsForMax(boundingBox3D, this.d_tris);
        this.addPointsForMax(boundingBox3D, this.d_lines);
        this.addPointsForMax(boundingBox3D, this.d_points);
        return new Point3D(boundingBox3D.getMax());
    }

    private void addPointsForMin(BoundingBox3D boundingBox3D, Collection<? extends Primitive> collection) {
        for (Primitive primitive : collection) {
            for (Point3d point3d : primitive.getPoints()) {
                boundingBox3D.addForMin(point3d);
            }
        }
    }

    private void addPointsForMax(BoundingBox3D boundingBox3D, Collection<? extends Primitive> collection) {
        for (Primitive primitive : collection) {
            for (Point3d point3d : primitive.getPoints()) {
                boundingBox3D.addForMax(point3d);
            }
        }
    }

    public static Vector3d calcNormal(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d, point3d2);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d, point3d3);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        return vector3d3;
    }
}

