/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.awt.geom.Line2D;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class BoundsFunctions {
    public static final int BOUNDS_INTERSECT = 0;
    public static final int BOUNDS_DONT_INTERSECT = 1;
    public static final int BOUNDS1_CONTAINS_BOUNDS2 = 2;
    public static final int BOUNDS2_CONTAINS_BOUNDS1 = 3;

    public static int categorizeBoundaries(Bounds3D bounds3D, Bounds3D bounds3D2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 8; ++n) {
            Point3D point3D;
            Point3D point3D2 = bounds3D.d_points[n];
            if (bounds3D2.isPointInsideOrOnEdge(point3D2)) {
                ++n2;
            }
            if (!bounds3D.isPointInsideOrOnEdge(point3D = bounds3D2.d_points[n])) continue;
            ++n3;
        }
        if (n2 == 8) {
            return 3;
        }
        if (n3 == 8) {
            return 2;
        }
        for (n = 0; n < 6; ++n) {
            if (!BoundsFunctions.faceIntersectsBoundary(bounds3D.d_faces[n], bounds3D2)) continue;
            return 0;
        }
        return 1;
    }

    public static void divideBoundaries(Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Bounds3D bounds3D, Bounds3D bounds3D2) {
        Face face;
        Face face2;
        int n;
        for (n = 0; n < vector5.size(); ++n) {
            face2 = new Face();
            face = (Face)vector5.get(n);
            BoundsFunctions.splitFaceWithBoundary(vector3, face2, face, bounds3D2);
            vector.add(face2);
        }
        for (n = 0; n < vector6.size(); ++n) {
            face2 = new Face();
            face = (Face)vector6.get(n);
            BoundsFunctions.splitFaceWithBoundary(vector4, face2, face, bounds3D);
            vector2.add(face2);
        }
    }

    public static boolean splitFaceWithBoundary(Vector vector, Face face, Face face2, Bounds3D bounds3D) {
        if (BoundsFunctions.faceLiesWithinBoundary(face2, bounds3D)) {
            return false;
        }
        boolean bl = false;
        if (BoundsFunctions.faceIntersectsBoundary(face2, bounds3D)) {
            for (int i = 0; i < 6; ++i) {
                boolean bl2;
                Face face3;
                Face face4 = bounds3D.d_faces[i];
                int n = BoundsFunctions.facesTouch(face2, face4);
                if (n == 1) {
                    vector.add(face2);
                    continue;
                }
                if (n == -1) {
                    face3 = new Face();
                    Face face5 = bounds3D.d_faces[(i + 2) % 6];
                    boolean bl3 = BoundsFunctions.splitFaceWithBoundsFace(face3, face, face2, face5);
                    if (!bl3) continue;
                    bl = true;
                    vector.add(face3);
                    BoundsFunctions.splitFaceWithBoundary(vector, face, (Face)face.clone(), bounds3D);
                    continue;
                }
                if (!BoundsFunctions.faceIntersectsBoundaryFace(face2, face4) || !(bl2 = BoundsFunctions.splitFaceWithBoundsFace(face3 = new Face(), face, face2, face4))) continue;
                bl = true;
                vector.add(face3);
                BoundsFunctions.splitFaceWithBoundary(vector, face, (Face)face.clone(), bounds3D);
            }
        }
        if (!bl) {
            vector.add(face2);
        }
        return bl;
    }

    public static int facesTouch(Face face, Face face2) {
        int n = 0;
        if (face2.d_perpAxis == face.d_perpAxis && face2.d_planeValue == face.d_planeValue) {
            n = face2.d_planeOrientation == -face.d_planeOrientation ? -1 : 1;
        } else {
            return 0;
        }
        if (face.isPointWithinInfiniteFaceBox(face2.d_points[0]) && face.isPointWithinInfiniteFaceBox(face2.d_points[1]) && face.isPointWithinInfiniteFaceBox(face2.d_points[2]) && face.isPointWithinInfiniteFaceBox(face2.d_points[3]) || face2.isPointWithinInfiniteFaceBox(face.d_points[0]) && face2.isPointWithinInfiniteFaceBox(face.d_points[1]) && face2.isPointWithinInfiniteFaceBox(face.d_points[2]) && face2.isPointWithinInfiniteFaceBox(face.d_points[3])) {
            return n;
        }
        for (int i = 0; i < 4; ++i) {
            Point3D point3D = face.d_points[i];
            Point3D point3D2 = face.d_points[(i + 1) % 4];
            Line2D.Double double_ = face.d_perpAxis == 0 ? new Line2D.Double(point3D.y, point3D.z, point3D2.y, point3D2.z) : (face.d_perpAxis == 1 ? new Line2D.Double(point3D.x, point3D.z, point3D2.x, point3D2.z) : new Line2D.Double(point3D.x, point3D.y, point3D2.x, point3D2.y));
            for (int j = 0; j < 4; ++j) {
                Point3D point3D3 = face2.d_points[j];
                Point3D point3D4 = face2.d_points[(j + 1) % 4];
                Line2D.Double double_2 = face2.d_perpAxis == 0 ? new Line2D.Double(point3D3.y, point3D3.z, point3D4.y, point3D4.z) : (face2.d_perpAxis == 1 ? new Line2D.Double(point3D3.x, point3D3.z, point3D4.x, point3D4.z) : new Line2D.Double(point3D3.x, point3D3.y, point3D4.x, point3D4.y));
                if (!double_.intersectsLine(double_2)) continue;
                return n;
            }
        }
        return 0;
    }

    public static boolean faceLiesWithinBoundary(Face face, Bounds3D bounds3D) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!bounds3D.isPointInsideOrOnEdge(face.d_points[i])) continue;
            ++n;
        }
        return n == 4;
    }

    public static boolean faceIntersectsBoundary(Face face, Bounds3D bounds3D) {
        for (int i = 0; i < 6; ++i) {
            if (!BoundsFunctions.faceIntersectsBoundaryFace(face, bounds3D.d_faces[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean faceIntersectsBoundaryFace(Face face, Face face2) {
        if (BoundsFunctions.facesTouch(face, face2) != 0) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (!BoundsFunctions.edgeIntersectsFace(face.d_points[i], face.d_points[(i + 1) % 4], face2) && !BoundsFunctions.edgeIntersectsFace(face2.d_points[i], face2.d_points[(i + 1) % 4], face)) continue;
            return true;
        }
        return false;
    }

    public static boolean edgeIntersectsFace(Point3D point3D, Point3D point3D2, Face face) {
        if (face.isPointWithinInfiniteFaceBox(point3D)) {
            double d = face.d_plane.testPoint(point3D);
            double d2 = face.d_plane.testPoint(point3D2);
            if (d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static boolean splitFaceWithBoundsFace(Face face, Face face2, Face face3, Face face4) {
        for (int i = 0; i < 4; ++i) {
            Point3D point3D;
            Point3D point3D2;
            Point3D point3D3;
            Point3D point3D4;
            Plane plane = face3.d_plane;
            Point3D point3D5 = face3.d_points[i];
            Point3D point3D6 = face3.d_points[(i + 1) % 4];
            double d = face4.d_plane.testPoint(point3D5);
            double d2 = face4.d_plane.testPoint(point3D6);
            if (d > 0.0 && d2 < 0.0) {
                Point3D point3D7;
                Point3D point3D8;
                Point3D point3D9;
                Point3D point3D10;
                Point3D point3D11 = face3.d_points[(i + 2) % 4];
                Point3D point3D12 = face3.d_points[(i + 3) % 4];
                Point3D point3D13 = point3D5;
                Point3D point3D14 = point3D12;
                Point3D point3D15 = point3D6;
                Point3D point3D16 = point3D11;
                if (face4.d_perpAxis == 0) {
                    point3D10 = new Point3D(face4.d_xMin, point3D6.y, point3D6.z);
                    point3D9 = new Point3D(face4.d_xMin, point3D11.y, point3D11.z);
                    point3D8 = new Point3D(face4.d_xMin, point3D5.y, point3D5.z);
                    point3D7 = new Point3D(face4.d_xMin, point3D12.y, point3D12.z);
                } else if (face4.d_perpAxis == 1) {
                    point3D10 = new Point3D(point3D6.x, face4.d_yMin, point3D6.z);
                    point3D9 = new Point3D(point3D11.x, face4.d_yMin, point3D11.z);
                    point3D8 = new Point3D(point3D5.x, face4.d_yMin, point3D5.z);
                    point3D7 = new Point3D(point3D12.x, face4.d_yMin, point3D12.z);
                } else {
                    point3D10 = new Point3D(point3D6.x, point3D6.y, face4.d_zMin);
                    point3D9 = new Point3D(point3D11.x, point3D11.y, face4.d_zMin);
                    point3D8 = new Point3D(point3D5.x, point3D5.y, face4.d_zMin);
                    point3D7 = new Point3D(point3D12.x, point3D12.y, face4.d_zMin);
                }
                face.setPoints(point3D13, point3D10, point3D9, point3D14, plane);
                face2.setPoints(point3D8, point3D15, point3D16, point3D7, plane);
                return true;
            }
            if (!(d < 0.0) || !(d2 > 0.0)) continue;
            Point3D point3D17 = face3.d_points[(i + 2) % 4];
            Point3D point3D18 = face3.d_points[(i + 3) % 4];
            Point3D point3D19 = point3D5;
            Point3D point3D20 = point3D18;
            Point3D point3D21 = point3D6;
            Point3D point3D22 = point3D17;
            if (face4.d_perpAxis == 0) {
                point3D4 = new Point3D(face4.d_xMin, point3D6.y, point3D6.z);
                point3D3 = new Point3D(face4.d_xMin, point3D17.y, point3D17.z);
                point3D2 = new Point3D(face4.d_xMin, point3D5.y, point3D5.z);
                point3D = new Point3D(face4.d_xMin, point3D18.y, point3D18.z);
            } else if (face4.d_perpAxis == 1) {
                point3D4 = new Point3D(point3D6.x, face4.d_yMin, point3D6.z);
                point3D3 = new Point3D(point3D17.x, face4.d_yMin, point3D17.z);
                point3D2 = new Point3D(point3D5.x, face4.d_yMin, point3D5.z);
                point3D = new Point3D(point3D18.x, face4.d_yMin, point3D18.z);
            } else {
                point3D4 = new Point3D(point3D6.x, point3D6.y, face4.d_zMin);
                point3D3 = new Point3D(point3D17.x, point3D17.y, face4.d_zMin);
                point3D2 = new Point3D(point3D5.x, point3D5.y, face4.d_zMin);
                point3D = new Point3D(point3D18.x, point3D18.y, face4.d_zMin);
            }
            face.setPoints(point3D2, point3D21, point3D22, point3D, plane);
            face2.setPoints(point3D19, point3D4, point3D3, point3D20, plane);
            return true;
        }
        return false;
    }

    public static String printFace(Face face) {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            string = string + face.d_points[i].x + "," + face.d_points[i].y + "," + face.d_points[i].z + " : ";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Face face = new Face(new Point3D(4.0, 0.0, 0.0), new Point3D(4.0, 0.0, 10.0), new Point3D(4.0, 5.0, 10.0), new Point3D(4.0, 5.0, 0.0), new Plane(1.0, 0.0, 0.0, -4.0));
        Face face2 = new Face(new Point3D(4.0, 5.0, 2.0), new Point3D(4.0, 5.0, 12.0), new Point3D(4.0, 7.0, 12.0), new Point3D(4.0, 7.0, 2.0), new Plane(-1.0, 0.0, 0.0, 4.0));
        int n = BoundsFunctions.facesTouch(face, face2);
        System.out.println(n);
    }

    public static class Face {
        public Point3D[] d_points = new Point3D[4];
        public double d_xMin;
        public double d_xMax;
        public double d_yMin;
        public double d_yMax;
        public double d_zMin;
        public double d_zMax;
        public Plane d_plane;
        public int d_perpAxis;
        public double d_planeValue;
        public double d_planeOrientation;
        public static final int X_AXIS = 0;
        public static final int Y_AXIS = 1;
        public static final int Z_AXIS = 2;

        public Face() {
        }

        public Face(Point3D point3D, Point3D point3D2, Point3D point3D3, Point3D point3D4, Plane plane) {
            this.setPoints(point3D, point3D2, point3D3, point3D4, plane);
        }

        public void setPoints(Point3D point3D, Point3D point3D2, Point3D point3D3, Point3D point3D4, Plane plane) {
            this.d_points[0] = point3D;
            this.d_points[1] = point3D2;
            this.d_points[2] = point3D3;
            this.d_points[3] = point3D4;
            this.d_plane = plane;
            this.d_xMin = Math.min(point3D.x, point3D3.x);
            this.d_xMax = Math.max(point3D.x, point3D3.x);
            this.d_yMin = Math.min(point3D.y, point3D3.y);
            this.d_yMax = Math.max(point3D.y, point3D3.y);
            this.d_zMin = Math.min(point3D.z, point3D3.z);
            this.d_zMax = Math.max(point3D.z, point3D3.z);
            if (this.d_xMin == this.d_xMax) {
                this.d_perpAxis = 0;
                this.d_planeValue = this.d_xMin;
                this.d_planeOrientation = this.d_plane.d_x;
            } else if (this.d_yMin == this.d_yMax) {
                this.d_perpAxis = 1;
                this.d_planeValue = this.d_yMin;
                this.d_planeOrientation = this.d_plane.d_y;
            } else {
                this.d_perpAxis = 2;
                this.d_planeValue = this.d_zMin;
                this.d_planeOrientation = this.d_plane.d_z;
            }
        }

        public Object clone() {
            return new Face(this.d_points[0], this.d_points[1], this.d_points[2], this.d_points[3], this.d_plane);
        }

        public boolean isPointWithinInfiniteFaceBox(Point3D point3D) {
            if (this.d_perpAxis == 0) {
                return point3D.y <= this.d_yMax && point3D.y >= this.d_yMin && point3D.z <= this.d_zMax && point3D.z >= this.d_zMin;
            }
            if (this.d_perpAxis == 1) {
                return point3D.x <= this.d_xMax && point3D.x >= this.d_xMin && point3D.z <= this.d_zMax && point3D.z >= this.d_zMin;
            }
            return point3D.x <= this.d_xMax && point3D.x >= this.d_xMin && point3D.y <= this.d_yMax && point3D.y >= this.d_yMin;
        }

        public boolean isPointOnInfiniteFaceBox(Point3D point3D) {
            if (this.d_perpAxis == 0) {
                return !(point3D.y != this.d_yMax && point3D.y != this.d_yMin || point3D.z != this.d_zMax && point3D.z != this.d_zMin);
            }
            if (this.d_perpAxis == 1) {
                return !(point3D.x != this.d_xMax && point3D.x != this.d_xMin || point3D.z != this.d_zMax && point3D.z != this.d_zMin);
            }
            return !(point3D.x != this.d_xMax && point3D.x != this.d_xMin || point3D.y != this.d_yMax && point3D.y != this.d_yMin);
        }
    }

    public static class Plane {
        public double d_x;
        public double d_y;
        public double d_z;
        public double d_w;

        public Plane(double d, double d2, double d3, double d4) {
            this.d_x = d;
            this.d_y = d2;
            this.d_z = d3;
            this.d_w = d4;
        }

        public double testPoint(Point3D point3D) {
            return this.d_x * point3D.x + this.d_y * point3D.y + this.d_z * point3D.z + this.d_w;
        }
    }

    public static class Bounds3D {
        public double d_xMin;
        public double d_xMax;
        public double d_yMin;
        public double d_yMax;
        public double d_zMin;
        public double d_zMax;
        public Point3D d_mmm;
        public Point3D d_mmM;
        public Point3D d_mMm;
        public Point3D d_mMM;
        public Point3D d_Mmm;
        public Point3D d_MmM;
        public Point3D d_MMm;
        public Point3D d_MMM;
        public Face[] d_faces = new Face[6];
        public Point3D[] d_points = new Point3D[8];

        public Bounds3D(double d, double d2, double d3, double d4, double d5, double d6) {
            this.d_xMin = d;
            this.d_xMax = d2;
            this.d_yMin = d3;
            this.d_yMax = d4;
            this.d_zMin = d5;
            this.d_zMax = d6;
            this.d_mmm = new Point3D(d, d3, d5);
            this.d_mmM = new Point3D(d, d3, d6);
            this.d_mMm = new Point3D(d, d4, d5);
            this.d_mMM = new Point3D(d, d4, d6);
            this.d_Mmm = new Point3D(d2, d3, d5);
            this.d_MmM = new Point3D(d2, d3, d6);
            this.d_MMm = new Point3D(d2, d4, d5);
            this.d_MMM = new Point3D(d2, d4, d6);
            this.d_points[0] = this.d_mmm;
            this.d_points[1] = this.d_mmM;
            this.d_points[2] = this.d_mMm;
            this.d_points[3] = this.d_mMM;
            this.d_points[4] = this.d_Mmm;
            this.d_points[5] = this.d_MmM;
            this.d_points[6] = this.d_MMm;
            this.d_points[7] = this.d_MMM;
            this.d_faces[0] = new Face(this.d_MMM, this.d_MMm, this.d_Mmm, this.d_MmM, new Plane(1.0, 0.0, 0.0, -d2));
            this.d_faces[1] = new Face(this.d_mMM, this.d_mmM, this.d_mmm, this.d_mMm, new Plane(-1.0, 0.0, 0.0, d));
            this.d_faces[2] = new Face(this.d_MMM, this.d_mMM, this.d_mMm, this.d_MMm, new Plane(0.0, 1.0, 0.0, -d4));
            this.d_faces[3] = new Face(this.d_mmM, this.d_MmM, this.d_Mmm, this.d_mmm, new Plane(0.0, -1.0, 0.0, d3));
            this.d_faces[4] = new Face(this.d_mmM, this.d_mMM, this.d_MMM, this.d_MmM, new Plane(0.0, 0.0, 1.0, -d6));
            this.d_faces[5] = new Face(this.d_mmm, this.d_Mmm, this.d_MMm, this.d_mMm, new Plane(0.0, 0.0, -1.0, d5));
        }

        public boolean isPointInsideOrOnEdge(Point3D point3D) {
            return point3D.x <= this.d_xMax && point3D.x >= this.d_xMin && point3D.y <= this.d_yMax && point3D.y >= this.d_yMin && point3D.z <= this.d_zMax && point3D.z >= this.d_zMin;
        }

        public boolean isPointInside(Point3D point3D) {
            return point3D.x < this.d_xMax && point3D.x > this.d_xMin && point3D.y < this.d_yMax && point3D.y > this.d_yMin && point3D.z < this.d_zMax && point3D.z > this.d_zMin;
        }
    }
}

