/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class PyroDomainEvent<C, E>
extends ADomainEvent {
    public static final int SELECTION_CHANGED = 0;
    public static final int VISIBILITY_CHANGED = 1;
    public static final int OBJECT_ORDER_CHANGED = 2;
    public static final int OBJECT_ADDED = 3;
    public static final int OBJECT_REMOVED = 4;
    public static final int OBJECT_CHANGED = 5;
    protected static final String[] TYPE_DESC = new String[]{"Selection Changed", "Visibility Changed", "Object Order Changed", "Added", "Removed", "Modified"};
    private Set<E> d_objects = new HashSet();
    private Map<C, Set<E>> d_parentChildMap;
    private final int d_eventType;
    private final Class<E> d_objType;

    public PyroDomainEvent(E e, Class<E> clazz, int n) {
        this(new VectorFromArray<E>(e), clazz, n);
    }

    public PyroDomainEvent(E[] EArray, Class<E> clazz, int n) {
        this(new VectorFromArray<E>(EArray), clazz, n);
    }

    public PyroDomainEvent(Collection<? extends E> collection, Class<E> clazz, int n) {
        assert (n != 3 && n != 4);
        this.d_objects.addAll(collection);
        this.d_eventType = n;
        this.d_objType = clazz;
    }

    public PyroDomainEvent(C c, E e, Class<E> clazz, int n) {
        this(c, Arrays.asList(e), clazz, n);
    }

    public PyroDomainEvent(C c, Collection<? extends E> collection, Class<E> clazz, int n) {
        this.d_objType = clazz;
        this.d_eventType = n;
        this.d_parentChildMap = new HashMap<C, Set<E>>();
        this.d_parentChildMap.put(c, new HashSet<E>(collection));
        this.d_objects.addAll(collection);
    }

    private void mergeParentChildMapWithExisting(Map<C, Set<E>> map) {
        for (Map.Entry<C, Set<E>> entry : map.entrySet()) {
            C c = entry.getKey();
            Collection collection = entry.getValue();
            HashSet hashSet = this.d_parentChildMap.get(c);
            if (hashSet == null) {
                hashSet = (HashSet)((HashSet)collection).clone();
                this.d_parentChildMap.put(c, hashSet);
            } else {
                hashSet.addAll(collection);
            }
            this.d_objects.addAll(collection);
        }
    }

    private void removeParentChildMapWithExisting(Map<C, Set<E>> map) {
        for (Map.Entry<C, Set<E>> entry : map.entrySet()) {
            C c = entry.getKey();
            Collection collection = entry.getValue();
            Collection collection2 = this.d_parentChildMap.get(c);
            if (collection2 == null) continue;
            collection2.removeAll(collection);
            if (!collection2.isEmpty()) continue;
            this.d_parentChildMap.remove(c);
        }
        this.rebuildAffectedObjects();
    }

    private void cancelParentChildMapWithExisting(PyroDomainEvent<C, E> pyroDomainEvent) {
        boolean bl = false;
        for (Map.Entry<C, Set<E>> entry : pyroDomainEvent.d_parentChildMap.entrySet()) {
            C c = entry.getKey();
            Collection collection = entry.getValue();
            Collection collection2 = this.d_parentChildMap.get(c);
            if (collection2 == null) continue;
            ArrayList arrayList = new ArrayList(collection.size());
            for (Object e : collection) {
                if (!collection2.remove(e)) continue;
                arrayList.add(e);
                bl = true;
            }
            collection.removeAll(arrayList);
        }
        if (bl) {
            this.clearEmptyParents();
            super.clearEmptyParents();
        }
    }

    private void clearEmptyParents() {
        HashMap<C, Set<E>> hashMap = new HashMap<C, Set<E>>(this.d_parentChildMap.size());
        for (Map.Entry<C, Set<E>> entry : this.d_parentChildMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.d_parentChildMap = hashMap;
        this.rebuildAffectedObjects();
    }

    private void rebuildAffectedObjects() {
        HashSet hashSet = new HashSet(this.d_objects.size());
        for (Map.Entry<C, Set<E>> entry : this.d_parentChildMap.entrySet()) {
            hashSet.addAll(entry.getValue());
        }
        this.d_objects = hashSet;
    }

    @Override
    public IDomainEvent.MergeResult merge(IDomainEvent iDomainEvent) {
        PyroDomainEvent pyroDomainEvent;
        if (iDomainEvent instanceof PyroDomainEvent && this.d_objType.isAssignableFrom((pyroDomainEvent = (PyroDomainEvent)iDomainEvent).getObjectType())) {
            this.merge(pyroDomainEvent);
            if (this.d_objects.isEmpty() && pyroDomainEvent.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepNeither();
            }
            if (this.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepNext();
            }
            if (pyroDomainEvent.d_objects.isEmpty()) {
                return IDomainEvent.MergeResult.keepCurrent();
            }
        }
        return IDomainEvent.MergeResult.keepBoth();
    }

    private void merge(PyroDomainEvent<C, E> pyroDomainEvent) {
        block0 : switch (this.getEventType()) {
            case 3: {
                switch (pyroDomainEvent.getEventType()) {
                    case 0: 
                    case 1: 
                    case 5: {
                        pyroDomainEvent.d_objects.removeAll(this.d_objects);
                        break;
                    }
                    case 3: {
                        if (pyroDomainEvent.d_objects.size() <= this.d_objects.size()) {
                            this.mergeParentChildMapWithExisting(pyroDomainEvent.d_parentChildMap);
                            pyroDomainEvent.d_objects.clear();
                            pyroDomainEvent.d_parentChildMap.clear();
                            break;
                        }
                        super.mergeParentChildMapWithExisting(this.d_parentChildMap);
                        this.d_objects.clear();
                        this.d_parentChildMap.clear();
                        break;
                    }
                    case 4: {
                        this.cancelParentChildMapWithExisting(pyroDomainEvent);
                    }
                }
                break;
            }
            case 4: {
                switch (pyroDomainEvent.getEventType()) {
                    case 0: 
                    case 1: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        this.cancelParentChildMapWithExisting(pyroDomainEvent);
                        break;
                    }
                    case 4: {
                        if (pyroDomainEvent.d_objects.size() <= this.d_objects.size()) {
                            this.mergeParentChildMapWithExisting(pyroDomainEvent.d_parentChildMap);
                            pyroDomainEvent.d_objects.clear();
                            pyroDomainEvent.d_parentChildMap.clear();
                            break;
                        }
                        super.mergeParentChildMapWithExisting(this.d_parentChildMap);
                        this.d_objects.clear();
                        this.d_parentChildMap.clear();
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 5: {
                switch (pyroDomainEvent.getEventType()) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        this.d_objects.removeAll(pyroDomainEvent.d_objects);
                        break block0;
                    }
                }
                if (this.getEventType() != pyroDomainEvent.getEventType()) break;
                if (this.d_objects.size() > pyroDomainEvent.d_objects.size()) {
                    this.d_objects.addAll(pyroDomainEvent.d_objects);
                    pyroDomainEvent.d_objects.clear();
                    break;
                }
                pyroDomainEvent.d_objects.addAll(this.d_objects);
                this.d_objects.clear();
                break;
            }
            default: {
                if (this.getEventType() != pyroDomainEvent.getEventType()) break;
                if (this.d_objects.size() > pyroDomainEvent.d_objects.size()) {
                    this.d_objects.addAll(pyroDomainEvent.d_objects);
                    pyroDomainEvent.d_objects.clear();
                    break;
                }
                pyroDomainEvent.d_objects.addAll(this.d_objects);
                this.d_objects.clear();
            }
        }
    }

    public int getEventType() {
        return this.d_eventType;
    }

    public Class<E> getObjectType() {
        return this.d_objType;
    }

    public Collection<E> getObjects() {
        return this.d_objects;
    }

    public Map<C, Set<E>> getParentChildMap() {
        return this.d_parentChildMap;
    }

    public String toString() {
        return this.d_objType.getSimpleName() + "DomainEvent: " + TYPE_DESC[this.getEventType()] + " (" + this.d_objects.size() + " objects)";
    }
}

