/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;

public class FDSRasterDomainEvent
extends ADomainEvent {
    public static final byte CHANGE_GENERAL = 1;
    public static final byte CHANGE_SELECTION = 2;
    public static final byte CHANGE_VISIBILITY = 4;
    private final Set<FDSObjectRasterization> d_objs = new HashSet<FDSObjectRasterization>();
    private final Set<FDSObjectRasterization> d_objsAdded = new HashSet<FDSObjectRasterization>();
    private final Set<FDSObjectRasterization> d_objsRemoved = new HashSet<FDSObjectRasterization>();
    private final Map<FDSObjectRasterization, Change> d_changes = new HashMap<FDSObjectRasterization, Change>();
    private boolean d_previewChanged = false;

    public boolean hasChanges() {
        return this.d_previewChanged || !this.d_objsAdded.isEmpty() || !this.d_objsRemoved.isEmpty() || !this.d_changes.isEmpty();
    }

    public static FDSRasterDomainEvent previewModeChangedEvent() {
        FDSRasterDomainEvent fDSRasterDomainEvent = new FDSRasterDomainEvent();
        fDSRasterDomainEvent.previewModeChanged();
        return fDSRasterDomainEvent;
    }

    public void previewModeChanged() {
        this.d_previewChanged = true;
    }

    public boolean isPreviewModeChanged() {
        return this.d_previewChanged;
    }

    public void objectsAdded(FDSObjectRasterization ... fDSObjectRasterizationArray) {
        for (FDSObjectRasterization fDSObjectRasterization : fDSObjectRasterizationArray) {
            this.objectAdded(fDSObjectRasterization);
        }
    }

    public void objectsAdded(Collection<? extends FDSObjectRasterization> collection) {
        for (FDSObjectRasterization fDSObjectRasterization : collection) {
            this.objectAdded(fDSObjectRasterization);
        }
    }

    public void objectAdded(FDSObjectRasterization fDSObjectRasterization) {
        if (this.d_objs.add(fDSObjectRasterization)) {
            if (!this.d_objsRemoved.remove(fDSObjectRasterization)) {
                this.d_objsAdded.add(fDSObjectRasterization);
            } else {
                this.objectChanged((byte)1, fDSObjectRasterization);
            }
        }
    }

    public Set<FDSObjectRasterization> getObjectsAdded() {
        return this.d_objsAdded;
    }

    public void objectsRemoved(FDSObjectRasterization ... fDSObjectRasterizationArray) {
        for (FDSObjectRasterization fDSObjectRasterization : fDSObjectRasterizationArray) {
            this.objectRemoved(fDSObjectRasterization);
        }
    }

    public void objectsRemoved(Collection<? extends FDSObjectRasterization> collection) {
        for (FDSObjectRasterization fDSObjectRasterization : collection) {
            this.objectRemoved(fDSObjectRasterization);
        }
    }

    public void objectRemoved(FDSObjectRasterization fDSObjectRasterization) {
        if (this.d_objs.remove(fDSObjectRasterization) && !this.d_objsAdded.remove(fDSObjectRasterization)) {
            this.d_changes.remove(fDSObjectRasterization);
            this.d_objsRemoved.add(fDSObjectRasterization);
        }
    }

    public Set<FDSObjectRasterization> getObjectsRemoved() {
        return this.d_objsRemoved;
    }

    public void objectsChanged(byte by, FDSObjectRasterization ... fDSObjectRasterizationArray) {
        for (FDSObjectRasterization fDSObjectRasterization : fDSObjectRasterizationArray) {
            this.objectChanged(by, fDSObjectRasterization);
        }
    }

    public void objectsChanged(byte by, Collection<? extends FDSObjectRasterization> collection) {
        for (FDSObjectRasterization fDSObjectRasterization : collection) {
            this.objectChanged(by, fDSObjectRasterization);
        }
    }

    public void objectChanged(byte by, FDSObjectRasterization fDSObjectRasterization) {
        if (this.d_objs.contains(fDSObjectRasterization) && !this.d_objsAdded.contains(fDSObjectRasterization)) {
            Change change = this.d_changes.get(fDSObjectRasterization);
            if (change == null) {
                change = new Change(fDSObjectRasterization);
                this.d_changes.put(fDSObjectRasterization, change);
            }
            change.addChange(by);
        }
    }

    public Collection<Change> getChanges() {
        return this.d_changes.values();
    }

    public void objectChanged(FDSObjectRasterization fDSObjectRasterization) {
        this.objectChanged((byte)1, fDSObjectRasterization);
    }

    public void objectVisibilityChanged(FDSObjectRasterization fDSObjectRasterization) {
        this.objectChanged((byte)4, fDSObjectRasterization);
    }

    public void objectSelectionChanged(FDSObjectRasterization fDSObjectRasterization) {
        this.objectChanged((byte)2, fDSObjectRasterization);
    }

    @Override
    public void eventDispatched() {
        this.d_objsAdded.clear();
        this.d_objsRemoved.clear();
        this.d_changes.clear();
        this.d_previewChanged = false;
    }

    @Override
    public IDomainEvent.MergeResult merge(IDomainEvent iDomainEvent) {
        if (!(iDomainEvent instanceof FDSRasterDomainEvent)) {
            return IDomainEvent.MergeResult.keepBoth();
        }
        FDSRasterDomainEvent fDSRasterDomainEvent = (FDSRasterDomainEvent)iDomainEvent;
        if (fDSRasterDomainEvent.isPreviewModeChanged()) {
            this.previewModeChanged();
            return IDomainEvent.MergeResult.keepCurrent();
        }
        if (this.isPreviewModeChanged()) {
            fDSRasterDomainEvent.previewModeChanged();
            return IDomainEvent.MergeResult.keepNext();
        }
        return IDomainEvent.MergeResult.keepBoth();
    }

    public String toString() {
        String string = "";
        if (!this.d_objsAdded.isEmpty()) {
            string = this.addMessage(string, this.d_objsAdded.size(), "Added");
        }
        if (!this.d_objsRemoved.isEmpty()) {
            string = this.addMessage(string, this.d_objsRemoved.size(), "Removed");
        }
        if (!this.d_changes.isEmpty()) {
            int n;
            int n2;
            int n3 = this.countChanges(1);
            if (n3 > 0) {
                string = this.addMessage(string, n3, "Changed");
            }
            if ((n2 = this.countChanges(4)) > 0) {
                string = this.addMessage(string, n2, "Visibility Changed");
            }
            if ((n = this.countChanges(2)) > 0) {
                string = this.addMessage(string, n, "Selection Changed");
            }
        }
        if (this.isPreviewModeChanged()) {
            string = this.addMessage(string, this.d_objs.size(), "Preview Mode Changed");
        }
        return string;
    }

    private String addMessage(String string, int n, String string2) {
        if (string.length() > 0) {
            string = string + System.getProperty("line.separator");
        }
        string = string + "FDSRasterDomainEvent: " + string2 + " (" + n + " objects)";
        return string;
    }

    private int countChanges(int n) {
        int n2 = 0;
        for (Change change : this.d_changes.values()) {
            if ((change.getChanges() & n) != n) continue;
            ++n2;
        }
        return n2;
    }

    public static class Change {
        private byte d_changes = 0;
        private final FDSObjectRasterization d_obj;

        private Change(FDSObjectRasterization fDSObjectRasterization) {
            this.d_obj = fDSObjectRasterization;
        }

        private void addChange(byte by) {
            this.d_changes = (byte)(this.d_changes | by);
        }

        public FDSObjectRasterization getObject() {
            return this.d_obj;
        }

        public int getChanges() {
            return this.d_changes;
        }

        public boolean isSelectionChanged() {
            return (this.d_changes & 2) == 2;
        }

        public boolean isVisbilityChanged() {
            return (this.d_changes & 4) == 4;
        }

        public boolean isChanged() {
            return (this.d_changes & 1) == 1;
        }
    }
}

