/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFDSProperties;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;

public class HoleFragGenerator
implements IFDSFragGenerator {
    private final IFDSProperties d_props;

    public HoleFragGenerator(IFDSProperties iFDSProperties) {
        this.d_props = iFDSProperties;
    }

    @Override
    public FDSObject generateFrag(double d, double d2, double d3, double d4, double d5, double d6) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Color color = this.d_props.getColor();
        AlignedHole alignedHole = new AlignedHole(new UnitPoint3D(d, d2, d3, unit), new UnitPoint3D(d4, d5, d6, unit), this.d_props.getName() + " [Segment]");
        alignedHole.setColor(color);
        alignedHole.setSelected(this.d_props.isSelected());
        alignedHole.setVisible(this.d_props.isVisible());
        Vector vector = alignedHole.getEventsSeparatedByType();
        Collection<ActivationEventList> collection = this.d_props.getEventsSeparatedByType();
        for (ActivationEventList activationEventList : collection) {
            vector.add((ActivationEventList)activationEventList.clone());
        }
        return alignedHole;
    }

    @Override
    public IFDSProperties getProps() {
        return this.d_props;
    }

    @Override
    public int getCellPriority() {
        return FDSRasterization.getCellPriority(true, false, false);
    }

    @Override
    public <T2> boolean canMerge(IFragGenerator<T2> iFragGenerator) {
        if (!(iFragGenerator instanceof HoleFragGenerator)) {
            return false;
        }
        HoleFragGenerator holeFragGenerator = (HoleFragGenerator)iFragGenerator;
        return this.getProps().equals(holeFragGenerator.getProps());
    }
}

