/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.events.FDSRasterDomainEvent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;
import pyrosim.legacy_2006_2.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypeFilter;

public class FDSRasterization {
    private final Map<Grid, Raster3D<FDSObject>> d_gridRasterMap = new HashMap<Grid, Raster3D<FDSObject>>();
    private final Map<FDSObject, FDSObjectRasterization> d_objRasters = new HashMap<FDSObject, FDSObjectRasterization>();
    private final Set<FDSObject> d_unrastObjs = new HashSet<FDSObject>();
    private final FDSRasterDomainEvent d_events = new FDSRasterDomainEvent();
    private final PyroMod d_mediator;

    public FDSRasterization() {
        this(null);
    }

    public FDSRasterization(PyroMod pyroMod) {
        this.d_mediator = pyroMod;
    }

    public static int getCellPriority(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            return 2;
        }
        if (!bl3) {
            if (bl2) {
                return 0;
            }
            return 1;
        }
        if (bl2) {
            return 3;
        }
        return 4;
    }

    public FDSRasterDomainEvent getEvents() {
        return this.d_events;
    }

    public void respondToEvents(IDomainEvent iDomainEvent) {
        if (iDomainEvent instanceof FDSObjectDomainEvent) {
            this.respondToEvent((FDSObjectDomainEvent)iDomainEvent);
        } else if (iDomainEvent instanceof GridDomainEvent) {
            this.respondToEvent((GridDomainEvent)iDomainEvent);
        } else if (iDomainEvent instanceof PyroModDomainEvent) {
            this.respondToEvent((PyroModDomainEvent)iDomainEvent);
        }
    }

    private void respondToEvent(PyroModDomainEvent pyroModDomainEvent) {
        if (pyroModDomainEvent.isModelChanged()) {
            this.reset();
        }
    }

    private void respondToEvent(GridDomainEvent gridDomainEvent) {
        switch (gridDomainEvent.getEventType()) {
            case 3: {
                this.addRasters(gridDomainEvent.getObjects());
                break;
            }
            case 4: {
                this.removeRasters(gridDomainEvent.getObjects());
                break;
            }
            case 5: {
                this.updateRasters(gridDomainEvent.getObjects());
            }
        }
    }

    private void respondToEvent(FDSObjectDomainEvent fDSObjectDomainEvent) {
        FilteredCollection<FDSObject> filteredCollection = new FilteredCollection<FDSObject>(fDSObjectDomainEvent.getObjects(), new TypeFilter<FDSObject>(FDSObject.class){

            @Override
            public boolean shouldFilter(Object object) {
                return object instanceof FDSComposite;
            }
        });
        switch (fDSObjectDomainEvent.getEventType()) {
            case 3: {
                this.addObjects(filteredCollection);
                break;
            }
            case 4: {
                this.removeObjects(filteredCollection);
                break;
            }
            case 5: {
                this.updateObjects(filteredCollection);
                break;
            }
            case 0: {
                this.getEvents().objectsChanged((byte)2, this.getRasterizations(filteredCollection));
                break;
            }
            case 1: {
                this.getEvents().objectsChanged((byte)4, this.getRasterizations(filteredCollection));
            }
        }
    }

    private void reset() {
        this.d_events.objectsRemoved(this.d_objRasters.values());
        this.d_gridRasterMap.clear();
        this.d_objRasters.clear();
        this.d_unrastObjs.clear();
        System.gc();
        if (this.d_mediator != null) {
            this.addRasters(this.d_mediator.getGridManager().toCollection());
            this.addObjects(this.d_mediator.getObstructions().toCollection(FDSObject.class, true));
        }
    }

    public void clearObjs() {
        this.getEvents().objectsRemoved(this.d_objRasters.values());
        this.d_objRasters.clear();
        for (Raster3D<FDSObject> raster3D : this.d_gridRasterMap.values()) {
            raster3D.clear();
        }
        this.d_unrastObjs.clear();
    }

    private void syncRasterizableObjects() {
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>(this.d_objRasters.keySet());
        for (FDSObject object2 : arrayList) {
            if (object2.isRasterizable()) continue;
            this.removeObject(object2);
            this.d_unrastObjs.add(object2);
        }
        ArrayList<FDSObject> arrayList2 = new ArrayList<FDSObject>(this.d_unrastObjs);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            FDSObject fDSObject = (FDSObject)iterator.next();
            if (!fDSObject.isRasterizable()) continue;
            this.d_unrastObjs.remove(fDSObject);
            this.addObject(fDSObject);
        }
    }

    public void addRasters(Collection<? extends Grid> collection) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        for (Grid grid : collection) {
            double[] dArray = Util.convertArray(grid.getXLinePositions(), unit);
            double[] dArray2 = Util.convertArray(grid.getYLinePositions(), unit);
            double[] dArray3 = Util.convertArray(grid.getZLinePositions(), unit);
            Raster3D<FDSObject> raster3D = new Raster3D<FDSObject>(FDSObject.class, dArray, dArray2, dArray3);
            this.d_gridRasterMap.put(grid, raster3D);
            for (FDSObjectRasterization fDSObjectRasterization : this.d_objRasters.values()) {
                fDSObjectRasterization.addGrid(grid, raster3D);
            }
        }
        this.syncRasterizableObjects();
    }

    public void removeRasters(Collection<? extends Grid> collection) {
        for (Grid grid : collection) {
            this.d_gridRasterMap.remove(grid);
            for (FDSObjectRasterization fDSObjectRasterization : this.d_objRasters.values()) {
                fDSObjectRasterization.removeGrid(grid);
            }
        }
        this.syncRasterizableObjects();
    }

    public void updateRasters(Collection<? extends Grid> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        for (Grid grid : collection) {
            Raster3D<FDSObject> raster3D = this.d_gridRasterMap.get(grid);
            assert (raster3D != null);
            double[] dArray = Util.convertArray(grid.getXLinePositions(), unit);
            double[] dArray2 = Util.convertArray(grid.getYLinePositions(), unit);
            double[] dArray3 = Util.convertArray(grid.getZLinePositions(), unit);
            raster3D.setDivisions(dArray, dArray2, dArray3);
            for (FDSObjectRasterization fDSObjectRasterization : this.d_objRasters.values()) {
                fDSObjectRasterization.gridChanged(grid);
            }
        }
        this.syncRasterizableObjects();
    }

    public void addObjects(Collection<? extends FDSObject> collection) {
        for (FDSObject fDSObject : collection) {
            this.addObject(fDSObject);
        }
    }

    public boolean addObject(FDSObject fDSObject) {
        if (!fDSObject.isRasterizable()) {
            this.d_unrastObjs.add(fDSObject);
            return false;
        }
        FDSObjectRasterization fDSObjectRasterization = new FDSObjectRasterization(fDSObject, this.d_gridRasterMap, this);
        this.d_objRasters.put(fDSObject, fDSObjectRasterization);
        this.d_events.objectAdded(fDSObjectRasterization);
        return true;
    }

    public void removeObjects(Collection<? extends FDSObject> collection) {
        for (FDSObject fDSObject : collection) {
            this.removeObject(fDSObject);
        }
    }

    public void removeObject(FDSObject fDSObject) {
        FDSObjectRasterization fDSObjectRasterization = this.d_objRasters.remove(fDSObject);
        if (fDSObjectRasterization != null) {
            fDSObjectRasterization.unrasterize();
            this.d_events.objectRemoved(fDSObjectRasterization);
        } else {
            this.d_unrastObjs.remove(fDSObject);
        }
    }

    public void updateObjects(Collection<? extends FDSObject> collection) {
        for (FDSObject fDSObject : collection) {
            FDSObjectRasterization fDSObjectRasterization = this.d_objRasters.get(fDSObject);
            if (fDSObjectRasterization == null) {
                if (!fDSObject.isRasterizable()) continue;
                this.d_unrastObjs.remove(fDSObject);
                this.addObject(fDSObject);
                continue;
            }
            if (fDSObject.isRasterizable()) {
                fDSObjectRasterization.objChanged();
                continue;
            }
            this.removeObject(fDSObject);
            this.d_unrastObjs.add(fDSObject);
        }
    }

    public FDSRasterDomainEvent rasterizeObjects() {
        for (FDSObjectRasterization fDSObjectRasterization : this.d_objRasters.values()) {
            fDSObjectRasterization.rasterize();
        }
        return this.d_events;
    }

    public FDSObject[] getFrags(Grid grid, boolean bl) {
        Raster3D<FDSObject> raster3D = this.d_gridRasterMap.get(grid);
        assert (raster3D != null);
        return raster3D.getFrags(bl);
    }

    public Collection<FDSObject> getFrags(boolean bl) {
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>();
        for (Grid grid : this.d_gridRasterMap.keySet()) {
            FDSObject[] fDSObjectArray = this.getFrags(grid, bl);
            arrayList.addAll(Arrays.asList(fDSObjectArray));
        }
        return arrayList;
    }

    public Collection<FDSObject> getFrags(Class clazz, boolean bl) {
        Collection<FDSObject> collection = this.getFrags(bl);
        return new FilteredCollection<FDSObject>(collection, clazz);
    }

    public Collection<Grid> getRasterGrids() {
        return this.d_gridRasterMap.keySet();
    }

    public Collection<FDSObject> getRasterObjects() {
        return this.d_objRasters.keySet();
    }

    public FDSObjectRasterization getRasterization(FDSObject fDSObject) {
        return this.d_objRasters.get(fDSObject);
    }

    public Collection<FDSObjectRasterization> getRasterizations(Collection<? extends FDSObject> collection) {
        ArrayList<FDSObjectRasterization> arrayList = new ArrayList<FDSObjectRasterization>(collection.size());
        for (FDSObject fDSObject : collection) {
            FDSObjectRasterization fDSObjectRasterization = this.d_objRasters.get(fDSObject);
            if (fDSObjectRasterization == null) continue;
            arrayList.add(fDSObjectRasterization);
        }
        return arrayList;
    }
}

