/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjGridRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;

public class FDSObjectRasterization {
    private final HashMap<Grid, FDSObjGridRasterization> d_gridRasts;
    private final FDSRasterization d_parentRast;
    private final FDSObject d_obj;

    public FDSObjectRasterization(FDSObject fDSObject, Map<Grid, Raster3D<FDSObject>> map, FDSRasterization fDSRasterization) {
        this.d_parentRast = fDSRasterization;
        this.d_gridRasts = new HashMap();
        this.d_obj = fDSObject;
        for (Map.Entry<Grid, Raster3D<FDSObject>> entry : map.entrySet()) {
            this.addGrid(entry.getKey(), entry.getValue());
        }
    }

    public FDSObject getObject() {
        return this.d_obj;
    }

    protected void addGrid(Grid grid, Raster3D<FDSObject> raster3D) {
        FDSObjGridRasterization fDSObjGridRasterization = new FDSObjGridRasterization(this.d_obj, grid, this, raster3D);
        this.d_gridRasts.put(grid, fDSObjGridRasterization);
    }

    protected void removeGrid(Grid grid) {
        this.d_gridRasts.remove(grid);
        this.fireChanged();
    }

    protected void gridChanged(Grid grid) {
        FDSObjGridRasterization fDSObjGridRasterization = this.d_gridRasts.get(grid);
        fDSObjGridRasterization.gridChanged();
    }

    protected void objChanged() {
        for (FDSObjGridRasterization fDSObjGridRasterization : this.d_gridRasts.values()) {
            fDSObjGridRasterization.objChanged();
        }
    }

    protected void fireChanged() {
        this.d_parentRast.getEvents().objectChanged(this);
    }

    protected void rasterize() {
        for (FDSObjGridRasterization fDSObjGridRasterization : this.d_gridRasts.values()) {
            fDSObjGridRasterization.rasterize();
        }
    }

    protected void unrasterize() {
        for (FDSObjGridRasterization fDSObjGridRasterization : this.d_gridRasts.values()) {
            fDSObjGridRasterization.unrasterize();
        }
    }

    public Map<Grid, FDSObjGridRasterization> getObjGridRasterizations() {
        return this.d_gridRasts;
    }

    public Collection<FDSObject> getFrags(Grid grid, boolean bl) {
        FDSObjGridRasterization fDSObjGridRasterization = this.d_gridRasts.get(grid);
        return fDSObjGridRasterization.getFrags(bl);
    }

    public Collection<FDSObject> getFrags(boolean bl) {
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>();
        for (Grid grid : this.d_gridRasts.keySet()) {
            arrayList.addAll(this.getFrags(grid, bl));
        }
        return arrayList;
    }
}

