/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.ARasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;

public class FDSObjGridRasterization {
    private final Grid d_grid;
    private final FDSObject d_obj;
    private final FDSObjectRasterization d_parentRast;
    private final Raster3D<FDSObject> d_raster;
    private ObjectRasterization d_interiorRasterization = null;
    private ObjectRasterization[] d_faceRasterizations = null;
    private boolean d_rasterDirty = true;
    private boolean d_updatesPaused = false;

    public FDSObjGridRasterization(FDSObject fDSObject, Grid grid, FDSObjectRasterization fDSObjectRasterization, Raster3D<FDSObject> raster3D) {
        this.d_parentRast = fDSObjectRasterization;
        this.d_grid = grid;
        this.d_raster = raster3D;
        this.d_obj = fDSObject;
    }

    protected void gridChanged() {
        this.d_rasterDirty = true;
        this.d_faceRasterizations = null;
        this.d_interiorRasterization = null;
    }

    protected void objChanged() {
        this.unrasterize();
        this.d_rasterDirty = true;
    }

    protected void rasterize() {
        if (this.d_rasterDirty) {
            Unit unit = Geometry.GEOM_LENGTH_UNIT;
            this.d_updatesPaused = true;
            this.d_faceRasterizations = new ObjectRasterization[this.d_obj.getNumFaces()];
            if (this.d_obj.isSolid()) {
                Point3d[][] point3dArray = new Point3d[this.d_obj.getNumFaces()][];
                for (int i = 0; i < this.d_obj.getNumFaces(); ++i) {
                    IFace iFace = this.d_obj.getFace(i);
                    this.d_faceRasterizations[i] = new ObjectRasterization(iFace.getFDSFragGenerator());
                    UnitPoint3D[] unitPoint3DArray = iFace.getVerts();
                    point3dArray[i] = Util.convertArray(unit, unitPoint3DArray);
                }
                this.d_interiorRasterization = new ObjectRasterization(this.d_obj.getInteriorFragGenerator());
                this.d_raster.rasterizeSolid(this.d_interiorRasterization, this.d_faceRasterizations, point3dArray);
            } else {
                for (int i = 0; i < this.d_obj.getNumFaces(); ++i) {
                    IFace iFace = this.d_obj.getFace(i);
                    this.d_faceRasterizations[i] = new ObjectRasterization(iFace.getFDSFragGenerator());
                    UnitPoint3D[] unitPoint3DArray = iFace.getVerts();
                    Point3d[] point3dArray = Util.convertArray(unit, unitPoint3DArray);
                    this.d_raster.rasterizeConvexPolygon(this.d_faceRasterizations[i], point3dArray);
                }
                this.d_interiorRasterization = null;
            }
            this.d_updatesPaused = false;
            this.d_rasterDirty = false;
            this.fireChanged();
        }
    }

    protected void unrasterize() {
        if (this.d_faceRasterizations == null) {
            return;
        }
        this.d_updatesPaused = true;
        for (ObjectRasterization objectRasterization : this.d_faceRasterizations) {
            this.d_raster.removeRasterization(objectRasterization);
        }
        if (this.d_interiorRasterization != null) {
            this.d_raster.removeRasterization(this.d_interiorRasterization);
        }
        this.d_faceRasterizations = null;
        this.d_interiorRasterization = null;
        this.d_updatesPaused = false;
    }

    public ObjectRasterization getInteriorRasterization() {
        return this.d_interiorRasterization;
    }

    public ObjectRasterization[] getFaceRasterizations() {
        if (this.d_faceRasterizations == null) {
            return new ObjectRasterization[0];
        }
        return this.d_faceRasterizations;
    }

    public Collection<FDSObject> getFrags(boolean bl) {
        ObjectRasterization[] objectRasterizationArray = this.getFaceRasterizations();
        ObjectRasterization objectRasterization = this.getInteriorRasterization();
        ArrayList<ObjectRasterization> arrayList = new ArrayList<ObjectRasterization>(Arrays.asList(objectRasterizationArray));
        if (objectRasterization != null) {
            arrayList.add(objectRasterization);
        }
        return Arrays.asList(this.d_raster.getFrags(arrayList, bl));
    }

    public int getNumCells() {
        int n = 0;
        for (ObjectRasterization objectRasterization : this.getFaceRasterizations()) {
            n += objectRasterization.getCells().size();
        }
        ObjectRasterization objectRasterization = this.getInteriorRasterization();
        if (objectRasterization != null) {
            n += objectRasterization.getCells().size();
        }
        return n;
    }

    private void fireChanged() {
        if (this.d_updatesPaused) {
            return;
        }
        this.d_parentRast.fireChanged();
    }

    public class ObjectRasterization
    extends ARasterization<FDSObject> {
        private final IFDSFragGenerator d_fragGenerator;

        public ObjectRasterization(IFDSFragGenerator iFDSFragGenerator) {
            this.d_fragGenerator = iFDSFragGenerator;
        }

        @Override
        public IFragGenerator<? extends FDSObject> getFragGenerator() {
            return this.d_fragGenerator;
        }

        public IFDSFragGenerator getFDSFragGenerator() {
            return this.d_fragGenerator;
        }

        @Override
        public void addCell(Point3i point3i) {
            super.addCell(point3i);
            FDSObjGridRasterization.this.fireChanged();
        }

        @Override
        public void removeCell(Point3i point3i) {
            super.removeCell(point3i);
            FDSObjGridRasterization.this.fireChanged();
        }

        @Override
        public void clear() {
            super.clear();
            FDSObjGridRasterization.this.fireChanged();
        }
    }
}

