/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFDSProperties;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;

public class BlockFragGenerator
implements IFDSFragGenerator {
    private final IFDSProperties d_props;
    private final int d_cellPriority;

    public BlockFragGenerator(IFDSProperties iFDSProperties, int n) {
        this.d_props = iFDSProperties;
        this.d_cellPriority = n;
    }

    @Override
    public FDSObject generateFrag(double d, double d2, double d3, double d4, double d5, double d6) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Color color = this.d_props.getColor();
        AlignedBlock alignedBlock = new AlignedBlock(new UnitPoint3D(d, d2, d3, unit), new UnitPoint3D(d4, d5, d6, unit), this.d_props.getName() + " [Segment]", color, this.d_props.getMaterial());
        alignedBlock.setSelected(this.d_props.isSelected());
        alignedBlock.setVisible(this.d_props.isVisible());
        alignedBlock.setPermitsHole(this.d_props.permitsHoles());
        alignedBlock.setIsThickened(this.d_props.isThickened());
        alignedBlock.setIsSawtoothed(this.d_props.isSawtoothed());
        Vector vector = alignedBlock.getEventsSeparatedByType();
        Collection<ActivationEventList> collection = this.d_props.getEventsSeparatedByType();
        for (ActivationEventList activationEventList : collection) {
            vector.add((ActivationEventList)activationEventList.clone());
        }
        return alignedBlock;
    }

    @Override
    public IFDSProperties getProps() {
        return this.d_props;
    }

    @Override
    public int getCellPriority() {
        return this.d_cellPriority;
    }

    @Override
    public <T2> boolean canMerge(IFragGenerator<T2> iFragGenerator) {
        if (!(iFragGenerator instanceof BlockFragGenerator)) {
            return false;
        }
        BlockFragGenerator blockFragGenerator = (BlockFragGenerator)iFragGenerator;
        return this.getProps().equals(blockFragGenerator.getProps());
    }
}

