/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Wall
extends AUnalignedFDSObject {
    static final long serialVersionUID = 1L;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;

    public Wall(Material material) {
        super(material);
    }

    public Wall(String string, Material material) {
        super(string, material);
    }

    public Wall(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, Material material) {
        super(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, "Obstruction", material);
    }

    public Wall(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, String string, Material material) {
        super(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, string, material);
    }

    public static Wall fromLegacy(pyrosim.legacy_2006_2.legacy.v16.Wall wall) {
        Wall wall2 = new Wall(wall.getMaterial());
        AUnalignedFDSObject.fromLegacy(wall, wall2);
        wall2.d_permitHole = wall.permitsHole();
        wall2.d_sawtooth = wall.isSawtoothed();
        wall2.d_thicken = wall.isThickened();
        return wall2;
    }

    protected IFace createFace(Wall wall, byte by, Material material) {
        return new AUnalignedFDSObject.BlockFace(wall, by, material);
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof Wall)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Wall wall = (Wall)object;
        this.d_thicken = wall.d_thicken;
        this.d_permitHole = wall.d_permitHole;
        this.d_sawtooth = wall.d_sawtooth;
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Wall wall = (Wall)object;
        boolean bl = this.d_thicken == wall.d_thicken && this.d_permitHole == wall.d_permitHole && this.d_sawtooth == wall.d_sawtooth;
        return bl;
    }

    @Override
    public String getPropertyHashString() {
        String string = super.getPropertyHashString();
        string = string + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return string;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    protected IFDSFragGenerator getFaceFragGenerator(IFace iFace) {
        return new BlockFragGenerator(new AFDSFaceProps(iFace){

            @Override
            public boolean isThickened() {
                return Wall.this.isThickened();
            }

            @Override
            public boolean permitsHoles() {
                return Wall.this.permitsHole();
            }

            @Override
            public boolean isSawtoothed() {
                return Wall.this.isSawtoothed();
            }
        }, FDSRasterization.getCellPriority(false, true, this.permitsHole()));
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord fDSInputRecord) {
        fDSInputRecord.setValue("PERMIT_HOLE", new Boolean(this.d_permitHole));
        fDSInputRecord.setValue("SAWTOOTH", new Boolean(this.d_sawtooth));
        fDSInputRecord.setValue("THICKEN", new Boolean(this.d_thicken));
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean bl) {
        this.d_permitHole = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean bl) {
        this.d_sawtooth = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean bl) {
        this.d_thicken = bl;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Wall";
    }
}

