/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Line;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Vent
extends AbstractFDSObject
implements IFace {
    static final long serialVersionUID = 1L;
    public static final int NORMAL_AUTO = 0;
    public static final int NORMAL_XPOS = 1;
    public static final int NORMAL_XNEG = -1;
    public static final int NORMAL_YPOS = 2;
    public static final int NORMAL_YNEG = -2;
    public static final int NORMAL_ZPOS = 3;
    public static final int NORMAL_ZNEG = -3;
    private Quad d_quad;
    private Material d_material;
    private transient boolean d_selected;
    private UnitPoint3D d_normal = null;
    public static final int NUM_FACES = 1;

    public Vent(Material material) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), null, material);
    }

    public Vent(String string, Material material) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), string, material);
    }

    public Vent(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Material material) {
        super(string);
        assert (unitPoint3D.xu().compareTo(unitPoint3D2.xu()) <= 0 && unitPoint3D.yu().compareTo(unitPoint3D2.yu()) <= 0 && unitPoint3D.zu().compareTo(unitPoint3D2.zu()) <= 0);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        if (unitPoint3D.xu().equals(unitPoint3D2.xu())) {
            this.d_quad = Prism.getFaceForBox(unitPoint3D.getValue(unit), unitPoint3D2.getValue(unit), 0, null);
        } else if (unitPoint3D.yu().equals(unitPoint3D2.yu())) {
            this.d_quad = Prism.getFaceForBox(unitPoint3D.getValue(unit), unitPoint3D2.getValue(unit), 2, null);
        } else if (unitPoint3D.zu().equals(unitPoint3D2.zu())) {
            this.d_quad = Prism.getFaceForBox(unitPoint3D.getValue(unit), unitPoint3D2.getValue(unit), 4, null);
        } else {
            throw new IllegalArgumentException("Vent must be flat (i.e minX=maxX or minY=maxY or minZ=maxZ");
        }
        this.d_material = material;
        this.d_faces = new Vector(1);
        this.d_faces.add(this);
    }

    public Vent(Quad quad, String string, Material material) {
        super(string);
        this.d_quad = quad;
        this.d_material = material;
        this.d_faces = new Vector(1);
        this.d_faces.add(this);
    }

    public void setActualGeometry(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        int n;
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        double d = unitPoint3D.x(unit);
        double d2 = unitPoint3D2.x(unit);
        double d3 = unitPoint3D.y(unit);
        double d4 = unitPoint3D2.y(unit);
        double d5 = unitPoint3D.z(unit);
        double d6 = unitPoint3D2.z(unit);
        assert (d <= d2 && d3 <= d4 && d5 <= d6) : "Vent mins and maxes must be correctly specified";
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        assert (d7 >= 0.0 && d8 >= 0.0 && d9 >= 0.0);
        double d10 = d7;
        if (d8 < d10) {
            d10 = d8;
        }
        if (d9 < d10) {
            d10 = d9;
        }
        if (d10 == d7) {
            d = d2 = (d2 + d) * 0.5;
            n = 0;
        } else if (d10 == d8) {
            d3 = d4 = (d4 + d3) * 0.5;
            n = 2;
        } else {
            d5 = d6 = (d6 + d5) * 0.5;
            n = 4;
        }
        this.d_quad = Prism.getFaceForBox(new Point3D(d, d3, d5), new Point3D(d2, d4, d6), n, null);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setNormal(UnitPoint3D unitPoint3D) {
        this.d_normal = unitPoint3D;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint3D getNormal() {
        return this.d_normal;
    }

    protected int[] getPossibleNormalValues() {
        UnitPoint3D unitPoint3D = this.getMinPoint();
        UnitPoint3D unitPoint3D2 = this.getMaxPoint();
        int[] nArray = new int[3];
        nArray[0] = 0;
        if (unitPoint3D.xu().equals(unitPoint3D2.xu())) {
            nArray[1] = -1;
            nArray[2] = 1;
        } else if (unitPoint3D.yu().equals(unitPoint3D2.yu())) {
            nArray[1] = -2;
            nArray[2] = 2;
        } else {
            nArray[1] = -3;
            nArray[2] = 3;
        }
        return nArray;
    }

    public boolean isFDSNormalValid(int n) {
        int[] nArray = this.getPossibleNormalValues();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public void setFDSNormal(int n) {
        assert (this.isFDSNormalValid(n));
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        switch (n) {
            case 0: {
                this.d_normal = null;
                break;
            }
            case -1: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_XNEG, unit);
                break;
            }
            case 1: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_XPOS, unit);
                break;
            }
            case -2: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_YNEG, unit);
                break;
            }
            case 2: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_YPOS, unit);
                break;
            }
            case -3: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_ZNEG, unit);
                break;
            }
            case 3: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_ZPOS, unit);
            }
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public int getFDSNormal() {
        if (this.d_normal == null) {
            return 0;
        }
        Vector3d vector3d = this.d_normal.getVector3dValue(Geometry.GEOM_LENGTH_UNIT);
        if ((vector3d = this.getClosestAxis(vector3d)).equals(Geometry.VEC3D_XNEG)) {
            return -1;
        }
        if (vector3d.equals(Geometry.VEC3D_XPOS)) {
            return 1;
        }
        if (vector3d.equals(Geometry.VEC3D_YNEG)) {
            return -2;
        }
        if (vector3d.equals(Geometry.VEC3D_YPOS)) {
            return 2;
        }
        if (vector3d.equals(Geometry.VEC3D_ZNEG)) {
            return -3;
        }
        if (vector3d.equals(Geometry.VEC3D_ZPOS)) {
            return 3;
        }
        return 0;
    }

    public double getNormalDistFromCenter() {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = this.getMinPoint().getPoint3dValue(unit);
        Point3d point3d2 = this.getMaxPoint().getPoint3dValue(unit);
        double d = Math.abs(point3d2.x - point3d.x);
        double d2 = Math.abs(point3d2.y - point3d.y);
        double d3 = Math.abs(point3d2.z - point3d.z);
        double d4 = Double.MIN_VALUE;
        if (d > d4) {
            d4 = d;
        }
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 > d4 && d3 > 0.0) {
            d4 = d3;
        }
        return d4 * 0.25;
    }

    @Override
    public Object clone() {
        Vent vent = null;
        vent = new Vent((Quad)this.d_quad.clone(), super.getName(), super.getMaterial());
        vent.imprint(this);
        return vent;
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof Vent)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        Vent vent = (Vent)object;
        this.d_quad = (Quad)vent.d_quad.clone();
        this.setMaterial(vent.getMaterial());
        this.setColor(vent.getColor());
        Vector vector = vent.getEventsSeparatedByType();
        Vector vector2 = this.getEventsSeparatedByType();
        vector2.clear();
        for (ActivationEventList activationEventList : vector) {
            vector2.add((ActivationEventList)activationEventList.clone());
        }
        this.setCanBeTriggeredByAnyHeatDetector(vent.getCanBeTriggeredByAnyHeatDetector(0), 0);
        this.setCanBeTriggeredByAnyHeatDetector(vent.getCanBeTriggeredByAnyHeatDetector(1), 1);
        this.d_normal = vent.d_normal != null ? (UnitPoint3D)vent.d_normal.clone() : null;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D unitPoint3D) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        this.d_quad.translate(unitPoint3D.x(unit), unitPoint3D.y(unit), unitPoint3D.z(unit));
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        assert (tuple3d.x >= 0.0 && tuple3d.y >= 0.0 && tuple3d.z >= 0.0);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Point3d point3d2 = this.getMinPoint().getPoint3dValue(unit);
        Point3d point3d3 = this.getMaxPoint().getPoint3dValue(unit);
        Vent.scalePoint(point3d2, point3d, tuple3d);
        Vent.scalePoint(point3d3, point3d, tuple3d);
        this.setActualGeometry(new UnitPoint3D(point3d2, unit), new UnitPoint3D(point3d3, unit));
    }

    @Override
    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Matrix3d matrix3d = Vent.getRotateMat(vector3d, unitDouble);
        Point3d point3d2 = this.getMinPoint().getPoint3dValue(unit);
        Point3d point3d3 = this.getMaxPoint().getPoint3dValue(unit);
        Vent.rotatePoint(point3d2, point3d, matrix3d);
        Vent.rotatePoint(point3d3, point3d, matrix3d);
        this.rectifyPoints(point3d2, point3d3);
        Vector3d vector3d2 = null;
        if (this.getNormal() != null) {
            vector3d2 = this.getNormal().getVector3dValue(unit);
            matrix3d.transform(vector3d2);
        }
        ADomainObject.pauseUpdates(this);
        this.setActualGeometry(new UnitPoint3D(point3d2, unit), new UnitPoint3D(point3d3, unit));
        if (vector3d2 != null) {
            this.setNormal(new UnitPoint3D(vector3d2, unit));
        }
        ADomainObject.resumeUpdates(this);
    }

    @Override
    protected void rectifyPoints(Point3d point3d, Point3d point3d2) {
        super.rectifyPoints(point3d, point3d2);
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = d;
        if (d2 < d4) {
            d4 = d2;
        }
        if (d3 < d4) {
            d4 = d3;
        }
        if (d4 == d) {
            point3d.x = point3d2.x;
        } else if (d4 == d2) {
            point3d.y = point3d2.y;
        } else if (d4 == d3) {
            point3d.z = point3d2.z;
        }
    }

    @Override
    protected void mirror(int n, UnitDouble unitDouble) {
        Point3d point3d;
        Point3d point3d2;
        Point3d point3d3;
        Point3d point3d4;
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Vector3d vector3d = this.d_quad.getNormal();
        if (n == 0) {
            point3d4 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)0).x ? new Point3d(unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)0).x), this.d_quad.getPoint((int)0).y, this.d_quad.getPoint((int)0).z) : new Point3d(unitDouble.getValue(unit) - (this.d_quad.getPoint((int)0).x - unitDouble.getValue(unit)), this.d_quad.getPoint((int)0).y, this.d_quad.getPoint((int)0).z);
            point3d3 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)1).x ? new Point3d(unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)1).x), this.d_quad.getPoint((int)1).y, this.d_quad.getPoint((int)1).z) : new Point3d(unitDouble.getValue(unit) - (this.d_quad.getPoint((int)1).x - unitDouble.getValue(unit)), this.d_quad.getPoint((int)1).y, this.d_quad.getPoint((int)1).z);
            point3d2 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)2).x ? new Point3d(unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)2).x), this.d_quad.getPoint((int)2).y, this.d_quad.getPoint((int)2).z) : new Point3d(unitDouble.getValue(unit) - (this.d_quad.getPoint((int)2).x - unitDouble.getValue(unit)), this.d_quad.getPoint((int)2).y, this.d_quad.getPoint((int)2).z);
            point3d = unitDouble.getValue(unit) > this.d_quad.getPoint((int)3).x ? new Point3d(unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)3).x), this.d_quad.getPoint((int)3).y, this.d_quad.getPoint((int)3).z) : new Point3d(unitDouble.getValue(unit) - (this.d_quad.getPoint((int)3).x - unitDouble.getValue(unit)), this.d_quad.getPoint((int)3).y, this.d_quad.getPoint((int)3).z);
            if (point3d4.x == point3d2.x) {
                vector3d.negate();
                if (this.d_normal != null) {
                    Vector3d vector3d2 = this.d_normal.getValue(unit).getV3d();
                    vector3d2.negate();
                    this.d_normal = new UnitPoint3D(vector3d2, unit);
                }
            }
        } else if (n == 1) {
            point3d4 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)0).y ? new Point3d(this.d_quad.getPoint((int)0).x, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)0).y), this.d_quad.getPoint((int)0).z) : new Point3d(this.d_quad.getPoint((int)0).x, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)0).y - unitDouble.getValue(unit)), this.d_quad.getPoint((int)0).z);
            point3d3 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)1).y ? new Point3d(this.d_quad.getPoint((int)1).x, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)1).y), this.d_quad.getPoint((int)1).z) : new Point3d(this.d_quad.getPoint((int)1).x, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)1).y - unitDouble.getValue(unit)), this.d_quad.getPoint((int)1).z);
            point3d2 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)2).y ? new Point3d(this.d_quad.getPoint((int)2).x, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)2).y), this.d_quad.getPoint((int)2).z) : new Point3d(this.d_quad.getPoint((int)2).x, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)2).y - unitDouble.getValue(unit)), this.d_quad.getPoint((int)2).z);
            point3d = unitDouble.getValue(unit) > this.d_quad.getPoint((int)3).y ? new Point3d(this.d_quad.getPoint((int)3).x, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)3).y), this.d_quad.getPoint((int)3).z) : new Point3d(this.d_quad.getPoint((int)3).x, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)3).y - unitDouble.getValue(unit)), this.d_quad.getPoint((int)3).z);
            if (point3d4.y == point3d2.y) {
                vector3d.negate();
                if (this.d_normal != null) {
                    Vector3d vector3d3 = this.d_normal.getValue(unit).getV3d();
                    vector3d3.negate();
                    this.d_normal = new UnitPoint3D(vector3d3, unit);
                }
            }
        } else {
            point3d4 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)0).y ? new Point3d(this.d_quad.getPoint((int)0).x, this.d_quad.getPoint((int)0).y, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)0).z)) : new Point3d(this.d_quad.getPoint((int)0).x, this.d_quad.getPoint((int)0).y, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)0).z - unitDouble.getValue(unit)));
            point3d3 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)1).y ? new Point3d(this.d_quad.getPoint((int)1).x, this.d_quad.getPoint((int)1).y, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)1).z)) : new Point3d(this.d_quad.getPoint((int)1).x, this.d_quad.getPoint((int)1).y, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)1).z - unitDouble.getValue(unit)));
            point3d2 = unitDouble.getValue(unit) > this.d_quad.getPoint((int)2).y ? new Point3d(this.d_quad.getPoint((int)2).x, this.d_quad.getPoint((int)2).y, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)2).z)) : new Point3d(this.d_quad.getPoint((int)2).x, this.d_quad.getPoint((int)2).y, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)2).z - unitDouble.getValue(unit)));
            point3d = unitDouble.getValue(unit) > this.d_quad.getPoint((int)3).y ? new Point3d(this.d_quad.getPoint((int)3).x, this.d_quad.getPoint((int)3).y, unitDouble.getValue(unit) + (unitDouble.getValue(unit) - this.d_quad.getPoint((int)3).z)) : new Point3d(this.d_quad.getPoint((int)3).x, this.d_quad.getPoint((int)3).y, unitDouble.getValue(unit) - (this.d_quad.getPoint((int)3).z - unitDouble.getValue(unit)));
            if (point3d4.z == point3d2.z) {
                vector3d.negate();
                if (this.d_normal != null) {
                    Vector3d vector3d4 = this.d_normal.getValue(unit).getV3d();
                    vector3d4.negate();
                    this.d_normal = new UnitPoint3D(vector3d4, unit);
                }
            }
        }
        this.d_quad = new Quad(point3d4, point3d3, point3d2, point3d, null);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Iterator getVentIterator() {
        Vector<Vent> vector = new Vector<Vent>();
        vector.add(this);
        return vector.iterator();
    }

    @Override
    public String getFDSType() {
        return "VENT";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Object object;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("VENT");
        Vector<Double> vector = new Vector<Double>(6);
        UnitPoint3D unitPoint3D = this.getMinPoint();
        UnitPoint3D unitPoint3D2 = this.getMaxPoint();
        Point3D point3D = unitPoint3D.getValue(Geometry.GEOM_LENGTH_UNIT);
        Point3D point3D2 = unitPoint3D2.getValue(Geometry.GEOM_LENGTH_UNIT);
        vector.add(new Double(point3D.x));
        vector.add(new Double(point3D2.x));
        vector.add(new Double(point3D.y));
        vector.add(new Double(point3D2.y));
        vector.add(new Double(point3D.z));
        vector.add(new Double(point3D2.z));
        fDSInputRecord.setValue("XB", vector);
        int n = this.getFDSNormal();
        if (n != 0) {
            fDSInputRecord.setValue("IOR", new Integer(n));
        }
        fDSInputRecord.setValue("SURF_ID", this.d_material.getName());
        Color color = this.getColor();
        if (color != null) {
            object = color.getRGBComponents(null);
            Vector<Double> vector2 = new Vector<Double>(3);
            vector2.add(new Double((double)object[0]));
            vector2.add(new Double((double)object[1]));
            vector2.add(new Double((double)object[2]));
            fDSInputRecord.setValue("RGB", vector2);
        }
        if (!this.isVisible()) {
            fDSInputRecord.setValue("COLOR", "INVISIBLE");
        }
        fDSInputRecord.setComment(this.getName());
        object = this.getEventInputRecords(fDSInputRecord);
        if (object.size() != 0) {
            collection.addAll((Collection<FDSInputRecord>)object);
        } else {
            collection.add(fDSInputRecord);
        }
    }

    @Override
    public Map getEventInputRecordMap(int n) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (n == 0) {
            if (this.d_material.equals(Material.getPredefinedMaterial("OPEN"))) {
                treeMap.put(new Integer(0), "T_OPEN");
                treeMap.put(new Integer(1), "T_CLOSE");
            } else {
                treeMap.put(new Integer(0), "T_ACTIVATE");
                treeMap.put(new Integer(1), "T_DEACTIVATE");
            }
        } else if (n == 1) {
            treeMap.put(new Integer(0), "HEAT_ACTIVATE");
            treeMap.put(new Integer(1), "HEAT_DEACTIVATE");
        }
        return treeMap;
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry geometry = new Geometry();
        geometry.addQuad(this.d_quad);
        Point3D point3D = geometry.getMinPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry geometry = new Geometry();
        geometry.addQuad(this.d_quad);
        Point3D point3D = geometry.getMaxPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    public Quad getActualGeometry() {
        return this.d_quad;
    }

    @Override
    public void getGeometry(Geometry geometry) {
        Quad quad = (Quad)this.d_quad.clone();
        quad.setProps(new PrimProps(this.getMaterial(), this.getColor()));
        geometry.addQuad(quad);
        UnitPoint3D unitPoint3D = this.getNormal();
        if (unitPoint3D != null) {
            Unit unit = Geometry.GEOM_LENGTH_UNIT;
            Vector3d vector3d = unitPoint3D.getVector3dValue(unit);
            UnitPoint3D unitPoint3D2 = this.getMinPoint();
            UnitPoint3D unitPoint3D3 = this.getMaxPoint();
            Point3d point3d = new Point3d();
            point3d.add(unitPoint3D2.getPoint3dValue(unit), unitPoint3D3.getPoint3dValue(unit));
            point3d.scale(0.5);
            Point3d point3d2 = new Point3d(vector3d);
            point3d2.scale(this.getNormalDistFromCenter());
            point3d2.add(point3d);
            geometry.addLine(new Line(point3d, point3d2, vector3d, new PrimProps(null, Color.BLACK)));
        }
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public void setMaterial(Material material) {
        this.d_material = material;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        return this.d_material;
    }

    @Override
    public void setMaterial(int n, Material material) {
        this.d_material = material;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial(int n) {
        return this.d_material;
    }

    @Override
    public boolean isUniformMaterial() {
        return true;
    }

    @Override
    public void setSelected(boolean bl) {
        this.d_selected = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 0));
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public String getPropertyHashString() {
        String string = "";
        string = string + this.d_quad.getPoint((int)0).x + "," + this.d_quad.getPoint((int)0).y + "," + this.d_quad.getPoint((int)0).z + ";";
        string = string + this.d_quad.getPoint((int)1).x + "," + this.d_quad.getPoint((int)1).y + "," + this.d_quad.getPoint((int)1).z + ";";
        string = string + this.d_quad.getPoint((int)2).x + "," + this.d_quad.getPoint((int)2).y + "," + this.d_quad.getPoint((int)2).z + ";";
        string = string + this.d_quad.getPoint((int)3).x + "," + this.d_quad.getPoint((int)3).y + "," + this.d_quad.getPoint((int)3).z + ";";
        string = string + this.d_normal + ";";
        string = string + this.d_material.getName();
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Vent)) {
            return false;
        }
        Vent vent = (Vent)object;
        Vector vector = this.getEventsSeparatedByType();
        Vector vector2 = vent.getEventsSeparatedByType();
        return this.d_quad.equals(vent.d_quad) && this.d_material.equals(vent.d_material) && vector.equals(vector2) && this.getName().equals(vent.getName()) && (this.d_normal == null ? vent.d_normal == null : this.d_normal.equals(vent.d_normal));
    }

    @Override
    public UnitPoint3D[] getVerts() {
        return null;
    }

    @Override
    public FDSObject getAttachedObj() {
        return this;
    }

    @Override
    public IFDSFragGenerator getFDSFragGenerator() {
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Vent";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private UnitPoint3D d_normal;

        public SaveGeomTask(int n) {
            super(n, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(Vent.this);
            Vent.this.setActualGeometry(this.d_min, this.d_max);
            Vent.this.setNormal(this.d_normal);
            ADomainObject.resumeUpdates(Vent.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)Vent.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)Vent.this.getMaxPoint().clone();
            if (Vent.this.getNormal() != null) {
                this.d_normal = (UnitPoint3D)Vent.this.getNormal().clone();
            }
        }
    }
}

